/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.InsertQuery;
import org.jooq.Internal;
import org.jooq.SQLDialect;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.Update;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.AbstractQualifiedRecord;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;

@Internal
public class TableRecordImpl<R extends TableRecord<R>>
extends AbstractQualifiedRecord<R>
implements TableRecord<R> {
    private static final JooqLogger log = JooqLogger.getLogger(TableRecordImpl.class);
    private static final Set<SQLDialect> REFRESH_GENERATED_KEYS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REFRESH_GENERATED_KEYS_ON_UPDATE = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final long[] TRUNCATE = new long[]{1000L, 100L, 10L, 1L};

    public TableRecordImpl(Table<R> table) {
        super(table);
    }

    @Override
    public final Table<R> getTable() {
        return (Table)this.getQualifier();
    }

    @Override
    public final R original() {
        return (R)((TableRecord)super.original());
    }

    @Override
    public final <O extends UpdatableRecord<O>> O fetchParent(ForeignKey<R, O> key) {
        return (O)((UpdatableRecord)key.fetchParent(this));
    }

    @Override
    public final <O extends UpdatableRecord<O>> Table<O> parent(ForeignKey<R, O> key) {
        return key.parent(this);
    }

    @Override
    public final int insert() {
        return this.insert(this.fields.fields.fields);
    }

    @Override
    public final int insert(Field<?> ... storeFields) {
        return this.storeInsert(storeFields);
    }

    @Override
    public final int insert(Collection<? extends Field<?>> storeFields) {
        return this.insert(storeFields.toArray(Tools.EMPTY_FIELD));
    }

    final int storeInsert(Field<?>[] storeFields) {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.INSERT).operate(record -> {
            result[0] = this.storeInsert0(storeFields);
            return record;
        });
        return result[0];
    }

    final int storeInsert0(Field<?>[] storeFields) {
        DSLContext create = this.create();
        InsertQuery<R> insert = create.insertQuery(this.getTable());
        List<Field<?>> changedFields = this.addChangedValues(storeFields, insert, false);
        if (changedFields.isEmpty()) {
            if (Boolean.FALSE.equals(create.settings().isInsertUnchangedRecords())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Query is not executable", insert);
                }
                return 0;
            }
            insert.setDefaultValues();
        }
        BigInteger version = this.addRecordVersion(insert, false);
        Timestamp timestamp = this.addRecordTimestamp(insert, false);
        Collection<Field<?>> key = this.setReturningIfNeeded(insert);
        int result = insert.execute();
        if (result > 0) {
            for (Field<?> changedField : changedFields) {
                this.changed(changedField, false);
            }
            this.setRecordVersionAndTimestamp(version, timestamp);
            this.getReturningIfNeeded(insert, key);
            this.fetched = true;
        }
        return result;
    }

    final void getReturningIfNeeded(StoreQuery<R> query, Collection<Field<?>> key) {
        if (key != null && !key.isEmpty()) {
            Configuration c2;
            TableRecord record = (TableRecord)query.getReturnedRecord();
            if (record != null) {
                for (Field<?> field : key) {
                    int index = Tools.indexOrFail((Fields)this.fieldsRow(), field);
                    Object value = record.get(field);
                    this.values[index] = value;
                    this.originals[index] = value;
                }
            }
            if (Boolean.TRUE.equals((c2 = this.configuration()).settings().isReturnAllOnUpdatableRecord()) && (REFRESH_GENERATED_KEYS.contains((Object)c2.dialect()) || REFRESH_GENERATED_KEYS_ON_UPDATE.contains((Object)c2.dialect()) && query instanceof Update) && this instanceof UpdatableRecord) {
                ((UpdatableRecord)((Object)this)).refresh(key.toArray(Tools.EMPTY_FIELD));
            }
        }
    }

    final Collection<Field<?>> setReturningIfNeeded(StoreQuery<R> query) {
        Collection<Field<?>> key = null;
        if (this.configuration() != null && !Boolean.FALSE.equals(this.configuration().settings().isReturnIdentityOnUpdatableRecord())) {
            if (Boolean.TRUE.equals(this.configuration().settings().isReturnAllOnUpdatableRecord())) {
                key = Arrays.asList(this.fields());
            } else if (query instanceof InsertQuery || SettingsTools.updatablePrimaryKeys(Tools.settings(this))) {
                key = this.getReturning();
            }
        }
        if (key != null) {
            query.setReturning(key);
        }
        return key;
    }

    final void setRecordVersionAndTimestamp(BigInteger version, Timestamp timestamp) {
        Object value;
        int fieldIndex;
        TableField<R, ?> field;
        if (version != null) {
            field = this.getTable().getRecordVersion();
            fieldIndex = Tools.indexOrFail((Fields)this.fields, field);
            value = field.getDataType().convert((Object)version);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
        if (timestamp != null) {
            field = this.getTable().getRecordTimestamp();
            fieldIndex = Tools.indexOrFail((Fields)this.fields, field);
            value = field.getDataType().convert((Object)timestamp);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
    }

    final List<Field<?>> addChangedValues(Field<?>[] storeFields, StoreQuery<R> query, boolean forUpdate) {
        FieldsImpl f2 = new FieldsImpl(storeFields);
        ArrayList result = new ArrayList();
        for (Field<?> field : this.fields.fields.fields) {
            if (!this.changed(field) || f2.field(field) == null || !this.writable(field, forUpdate)) continue;
            this.addValue(query, field, forUpdate);
            result.add(field);
        }
        return result;
    }

    final boolean writable(Field<?> field, boolean forUpdate) {
        return true;
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field, Object value, boolean forUpdate) {
        store.addValue(field, Tools.field(value, field));
        if (forUpdate) {
            ((InsertQuery)store).addValueForUpdate(field, Tools.field(value, field));
        }
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field, boolean forUpdate) {
        this.addValue(store, field, this.get(field), forUpdate);
    }

    final Timestamp addRecordTimestamp(StoreQuery<?> store, boolean forUpdate) {
        Timestamp result = null;
        TableField<R, ?> timestamp = this.getTable().getRecordTimestamp();
        if (timestamp != null && this.isUpdateRecordTimestamp()) {
            result = new Timestamp(this.configuration().clock().millis());
            result = TableRecordImpl.truncate(result, timestamp.getDataType());
            this.addValue(store, timestamp, result, forUpdate);
        }
        return result;
    }

    private static final Timestamp truncate(Timestamp ts, DataType<?> type) {
        if (type.isDate()) {
            return new Timestamp(ts.getYear(), ts.getMonth(), ts.getDate(), 0, 0, 0, 0);
        }
        if (!type.precisionDefined() || type.precision() >= 3) {
            return ts;
        }
        return new Timestamp(ts.getTime() / TRUNCATE[type.precision()] * TRUNCATE[type.precision()]);
    }

    final BigInteger addRecordVersion(StoreQuery<?> store, boolean forUpdate) {
        BigInteger result = null;
        TableField<R, ?> version = this.getTable().getRecordVersion();
        if (version != null && this.isUpdateRecordVersion()) {
            Object value = this.get(version);
            result = value == null ? BigInteger.ONE : new BigInteger(value.toString()).add(BigInteger.ONE);
            this.addValue(store, version, result, forUpdate);
        }
        return result;
    }

    final Object getRecordVersion() {
        TableField<R, ?> field = this.getTable().getRecordVersion();
        return field != null ? this.get(field) : null;
    }

    final Object getRecordTimestamp() {
        TableField<R, ?> field = this.getTable().getRecordTimestamp();
        return field != null ? this.get(field) : null;
    }

    final boolean isUpdateRecordVersion() {
        Configuration configuration = this.configuration();
        return configuration != null ? !Boolean.FALSE.equals(configuration.settings().isUpdateRecordVersion()) : true;
    }

    final boolean isUpdateRecordTimestamp() {
        Configuration configuration = this.configuration();
        return configuration != null ? !Boolean.FALSE.equals(configuration.settings().isUpdateRecordTimestamp()) : true;
    }

    final boolean isTimestampOrVersionAvailable() {
        return this.getTable().getRecordTimestamp() != null && this.isUpdateRecordTimestamp() || this.getTable().getRecordVersion() != null && this.isUpdateRecordVersion();
    }

    final Collection<Field<?>> getReturning() {
        UniqueKey<?> key;
        LinkedHashSet result = new LinkedHashSet();
        Identity<R, ?> identity = this.getTable().getIdentity();
        if (identity != null) {
            result.add(identity.getField());
        }
        if ((key = this.getPrimaryKey()) != null) {
            result.addAll(key.getFields());
        }
        return result;
    }
}

