/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Merge;
import org.jooq.MergeMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldMapForUpdate;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.StringUtils;

final class InsertQueryImpl<R extends Record>
extends AbstractStoreQuery<R>
implements InsertQuery<R>,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.INSERT};
    private static final Set<SQLDialect> SUPPORT_INSERT_IGNORE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2);
    private static final Set<SQLDialect> NO_SUPPORT_SUBQUERY_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY);
    final FieldMapForUpdate updateMap;
    final FieldMapsForInsert insertMaps;
    Select<?> select;
    boolean defaultValues;
    boolean onDuplicateKeyUpdate;
    boolean onDuplicateKeyIgnore;
    Constraint onConstraint;
    UniqueKey<R> onConstraintUniqueKey;
    QueryPartList<Field<?>> onConflict;
    final ConditionProviderImpl onConflictWhere;
    final ConditionProviderImpl condition;

    InsertQueryImpl(Configuration configuration, WithImpl with, Table<R> into) {
        super(configuration, with, into);
        this.updateMap = new FieldMapForUpdate(into, Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
        this.insertMaps = new FieldMapsForInsert(into);
        this.onConflictWhere = new ConditionProviderImpl();
        this.condition = new ConditionProviderImpl();
    }

    @Override
    public final void newRecord() {
        this.insertMaps.newRecord();
    }

    @Override
    protected final Map<Field<?>, Field<?>> getValues() {
        return this.insertMaps.lastMap();
    }

    final FieldMapsForInsert getInsertMaps() {
        return this.insertMaps;
    }

    final Select<?> getSelect() {
        return this.select;
    }

    @Override
    public final void addRecord(R record) {
        this.newRecord();
        this.setRecord(record);
    }

    @Override
    public final void onConflict(Field<?> ... fields2) {
        this.onConflict(Arrays.asList(fields2));
    }

    @Override
    public final void onConflict(Collection<? extends Field<?>> fields2) {
        this.onConflict = new QueryPartList((Iterable<Field<?>>)fields2).qualify(false);
    }

    @Override
    public final void onConflictWhere(Condition conditions) {
        this.onConflictWhere.addConditions(conditions);
    }

    @Override
    public final void onConflictOnConstraint(Constraint constraint) {
        this.onConflictOnConstraint0(constraint);
    }

    @Override
    public void onConflictOnConstraint(UniqueKey<R> constraint) {
        if (StringUtils.isEmpty(constraint.getName())) {
            throw new IllegalArgumentException("UniqueKey's name is not specified");
        }
        this.onConstraintUniqueKey = constraint;
        this.onConflictOnConstraint0(DSL.constraint(DSL.name(constraint.getName())));
    }

    @Override
    public final void onConflictOnConstraint(Name constraint) {
        this.onConflictOnConstraint0(DSL.constraint(constraint));
    }

    private void onConflictOnConstraint0(Constraint constraint) {
        this.onConstraint = constraint;
        if (this.onConstraintUniqueKey == null) {
            this.onConstraintUniqueKey = Tools.findAny(this.table().getKeys(), key -> constraint.getName().equals(key.getName()));
        }
    }

    @Override
    public final void onDuplicateKeyUpdate(boolean flag) {
        this.onDuplicateKeyIgnore = false;
        this.onDuplicateKeyUpdate = flag;
    }

    @Override
    public final void onDuplicateKeyIgnore(boolean flag) {
        this.onDuplicateKeyUpdate = false;
        this.onDuplicateKeyIgnore = flag;
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, T value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, Field<T> value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final void addValuesForUpdate(Map<?, ?> map) {
        this.updateMap.set(map);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void setDefaultValues() {
        this.defaultValues = true;
    }

    private final boolean defaultValues(Configuration c2) {
        return this.defaultValues;
    }

    @Override
    public final void setSelect(Field<?>[] f2, Select<?> s2) {
        this.setSelect(Arrays.asList(f2), s2);
    }

    @Override
    public final void setSelect(Collection<? extends Field<?>> f2, Select<?> s2) {
        this.insertMaps.addFields(f2);
        this.select = s2;
    }

    @Override
    public final void addValues(Map<?, ?> map) {
        this.insertMaps.set(map);
    }

    @Override
    final void accept0(Context<?> ctx) {
        if (this.onDuplicateKeyUpdate) {
            switch (ctx.family()) {
                case POSTGRES: 
                case SQLITE: 
                case YUGABYTEDB: {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c2 -> this.toSQLInsert((Context<?>)c2));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT).sql(' ');
                    if (this.onConstraint != null) {
                        ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
                        ctx.visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint);
                        ctx.data().remove((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
                    } else {
                        ctx.sql('(');
                        if (this.onConflict != null && this.onConflict.size() > 0) {
                            ctx.visit(this.onConflict);
                        } else if (this.table().getPrimaryKey() == null) {
                            ctx.sql("[unknown primary key]");
                        } else {
                            ctx.qualify(false, c2 -> c2.visit(new FieldsImpl(this.table().getPrimaryKey().getFields())));
                        }
                        ctx.sql(')');
                    }
                    this.acceptOnConflictWhere(ctx);
                    ctx.formatSeparator().visit(Keywords.K_DO_UPDATE).formatSeparator().visit(Keywords.K_SET).formatIndentStart().formatSeparator().visit(this.updateMap).formatIndentEnd();
                    if (this.condition.hasWhere()) {
                        ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.condition);
                    }
                    ctx.end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                default: {
                    boolean oldQualify = ctx.qualify();
                    boolean newQualify = ctx.family() != SQLDialect.H2 && oldQualify;
                    this.toSQLInsert(ctx);
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).formatIndentStart().formatSeparator().qualify(newQualify);
                    if (this.condition.hasWhere()) {
                        ctx.data((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE, this.condition.getWhere());
                    }
                    ctx.visit(this.updateMap);
                    if (this.condition.hasWhere()) {
                        ctx.data().remove((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE);
                    }
                    ctx.qualify(oldQualify).formatIndentEnd().end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
            }
        } else if (this.onDuplicateKeyIgnore) {
            switch (ctx.dialect()) {
                case FIREBIRD: 
                case IGNITE: {
                    ctx.visit(this.toInsertSelect(ctx));
                    break;
                }
                case POSTGRES: 
                case SQLITE: 
                case YUGABYTEDB: {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c2 -> this.toSQLInsert((Context<?>)c2));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT);
                    if (this.onConstraint != null) {
                        ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true, c2 -> c2.sql(' ').visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint));
                    } else if (this.onConflict != null && this.onConflict.size() > 0) {
                        ctx.sql(" (").visit(this.onConflict).sql(')');
                        this.acceptOnConflictWhere(ctx);
                    }
                    ctx.formatSeparator().visit(Keywords.K_DO_NOTHING).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case CUBRID: {
                    FieldMapForUpdate update = new FieldMapForUpdate(this.table(), Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
                    Field<?> field = this.table().field(0);
                    update.put(field, field);
                    this.toSQLInsert(ctx);
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).sql(' ').visit(update).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                case DERBY: {
                    if (this.select != null) {
                        ctx.visit(this.toInsertSelect(ctx));
                        break;
                    }
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                default: {
                    this.toSQLInsert(ctx);
                    ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
            }
        } else {
            this.toSQLInsert(ctx);
            ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
        }
        ctx.start(Clause.INSERT_RETURNING);
        this.toSQLReturning(ctx);
        ctx.end(Clause.INSERT_RETURNING);
    }

    private final void acceptOnConflictWhere(Context<?> ctx) {
        if (this.onConflictWhere.hasWhere()) {
            ctx.qualify(false, c2 -> c2.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.onConflictWhere.getWhere()));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final void toSQLInsert(Context<?> ctx) {
        ctx.start(Clause.INSERT_INSERT_INTO).visit(Keywords.K_INSERT).sql(' ');
        if (this.onDuplicateKeyIgnore && SUPPORT_INSERT_IGNORE.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_IGNORE).sql(' ');
        }
        ctx.visit(Keywords.K_INTO).sql(' ').declareTables(true, c2 -> c2.visit(this.table((Context<?>)c2)));
        List<Field<?>> fields2 = this.insertMaps.toSQLReferenceKeys(ctx);
        ctx.end(Clause.INSERT_INSERT_INTO);
        if (this.select != null) {
            if (this.insertMaps.keysFlattened(ctx).size() == 0) {
                ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST, true);
            }
            ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT, true);
            Select<?> s2 = this.select;
            ctx.formatSeparator().start(Clause.INSERT_SELECT).visit(s2).end(Clause.INSERT_SELECT);
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST);
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT);
        } else if (this.defaultValues(ctx.configuration())) {
            switch (ctx.family()) {
                case DERBY: 
                case MARIADB: 
                case MYSQL: {
                    this.acceptDefaultValuesEmulation(ctx, this.table().fields().length);
                    break;
                }
                default: {
                    ctx.formatSeparator().visit(Keywords.K_DEFAULT_VALUES);
                    break;
                }
            }
        } else {
            ctx.visit(this.insertMaps);
        }
    }

    private final void acceptDefaultValuesEmulation(Context<?> ctx, int length) {
        ctx.formatSeparator().visit(Keywords.K_VALUES).sql(" (").visit(QueryPartListView.wrap(Collections.nCopies(length, Keywords.K_DEFAULT))).sql(')');
    }

    private final List<List<? extends Field<?>>> conflictingKeys(Context<?> ctx) {
        if (this.onConflict != null && this.onConflict.size() > 0) {
            return Collections.singletonList(this.onConflict);
        }
        if (this.onConstraintUniqueKey != null) {
            return Collections.singletonList(this.onConstraintUniqueKey.getFields());
        }
        if (Boolean.TRUE.equals(Tools.settings(ctx.configuration()).isEmulateOnDuplicateKeyUpdateOnPrimaryKeyOnly())) {
            return Collections.singletonList(this.table().getPrimaryKey().getFields());
        }
        return Tools.map(this.table().getKeys(), k2 -> k2.getFields());
    }

    private final QueryPart toInsertSelect(Context<?> ctx) {
        List<List<Field<?>>> keys = this.conflictingKeys(ctx);
        if (!keys.isEmpty()) {
            Select rows = null;
            Set<Field<?>> fields2 = this.insertMaps.keysFlattened(ctx);
            if (this.select != null) {
                HashMap map = new HashMap();
                Field<?>[] names = Tools.fields(Tools.degree(this.select));
                ArrayList f2 = new ArrayList(fields2);
                for (int i2 = 0; i2 < fields2.size() && i2 < names.length; ++i2) {
                    map.put((Field)f2.get(i2), names[i2]);
                }
                rows = DSL.selectFrom(this.select.asTable(DSL.table(DSL.name("t")), names)).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(ctx, map)));
            } else {
                for (Map<Field<?>, Field<?>> map : this.insertMaps.maps()) {
                    SelectConditionStep row = DSL.select(Tools.aliasedFields(map.entrySet().stream().filter(e2 -> fields2.contains(e2.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()))).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(ctx, map)));
                    if (rows == null) {
                        rows = row;
                        continue;
                    }
                    rows = rows.unionAll(row);
                }
            }
            return ctx.dsl().insertInto(this.table()).columns(fields2).select(DSL.selectFrom(rows.asTable("t")));
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into tables without any known keys : " + this.table());
    }

    private final Merge<R> toMerge(Context<?> ctx) {
        if (this.onConflict != null && this.onConflict.size() > 0 || this.onConstraint != null || !this.table().getKeys().isEmpty()) {
            MergeOnConditionStep on2;
            Table t2 = null;
            Set<Field<?>> k2 = this.insertMaps.keysFlattened(ctx);
            Set<Field<?>> f2 = null;
            if (!NO_SUPPORT_SUBQUERY_IN_MERGE_USING.contains((Object)ctx.dialect())) {
                Select<?> s2;
                f2 = k2.isEmpty() ? Arrays.asList(this.table().fields()) : k2;
                Select<Object> select = s2 = this.select != null ? this.select : this.insertMaps.insertSelect(ctx);
                if (s2 == null) {
                    s2 = DSL.select(Tools.map(f2, x2 -> x2.getDataType().defaulted() ? x2.getDataType().default_() : DSL.NULL(x2)));
                }
                t2 = s2.asTable("t", Tools.map(f2, Field::getName, String[]::new));
                if (NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING.contains((Object)ctx.dialect())) {
                    t2 = DSL.selectFrom(t2).asTable("t");
                }
            }
            MergeMatchedStep notMatched = on2 = t2 != null ? ctx.dsl().mergeInto(this.table()).using(t2).on(this.matchByConflictingKeys(ctx, t2)) : ctx.dsl().mergeInto(this.table()).usingDual().on(this.matchByConflictingKeys(ctx, this.insertMaps.lastMap()));
            if (this.onDuplicateKeyUpdate) {
                notMatched = this.condition.hasWhere() ? on2.whenMatchedAnd(this.condition.getWhere()).thenUpdate().set(this.updateMap) : on2.whenMatchedThenUpdate().set(this.updateMap);
            }
            return t2 != null ? notMatched.whenNotMatchedThenInsert(f2).values(t2.fields()) : notMatched.whenNotMatchedThenInsert(k2).values(this.insertMaps.lastMap().entrySet().stream().filter(e2 -> k2.contains(e2.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into non-updatable tables : " + this.table());
    }

    private final Condition matchByConflictingKeys(Context<?> ctx, Map<Field<?>, Field<?>> map) {
        Condition or2 = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields2 : this.conflictingKeys(ctx)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields2.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f2 = field = iterator.next();
                Condition other = this.matchByConflictingKey(ctx, f2, map.get(f2));
                and = and == null ? other : and.and(other);
            }
            or2 = or2 == null ? and : or2.or(and);
        }
        return or2;
    }

    private final Condition matchByConflictingKeys(Context<?> ctx, Table<?> s2) {
        Condition or2 = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields2 : this.conflictingKeys(ctx)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields2.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f2 = field = iterator.next();
                Condition other = this.matchByConflictingKey(ctx, f2, s2.field(f2));
                and = and == null ? other : and.and(other);
            }
            or2 = or2 == null ? and : or2.or(and);
        }
        return or2;
    }

    private final <T> Condition matchByConflictingKey(Context<?> ctx, Field<T> f2, Field<T> v2) {
        return f2.eq(v2);
    }

    @Override
    public final boolean isExecutable() {
        return this.insertMaps.isExecutable() || this.defaultValues(this.configuration()) || this.select != null;
    }
}

