/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.ParamType;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.AbstractDMLQuery;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.JoinTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.TableList;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;

final class DeleteQueryImpl<R extends Record>
extends AbstractDMLQuery<R>
implements DeleteQuery<R>,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.DELETE};
    private static final Set<SQLDialect> SPECIAL_DELETE_AS_SYNTAX = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_SUPPORT_LIMIT = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> NO_SUPPORT_ORDER_BY_LIMIT = SQLDialect.supportedBy(SQLDialect.IGNITE);
    private static final Set<SQLDialect> SUPPORT_MULTITABLE_DELETE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REQUIRE_REPEAT_FROM_IN_USING = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_SUPPORT_REPEAT_FROM_IN_USING = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final TableList using = new TableList();
    private final ConditionProviderImpl condition = new ConditionProviderImpl();
    private final SortFieldList orderBy = new SortFieldList();
    private Param<? extends Number> limit;

    DeleteQueryImpl(Configuration configuration, WithImpl with, Table<R> table) {
        super(configuration, with, table);
    }

    final Condition getWhere() {
        return this.condition.getWhere();
    }

    final boolean hasWhere() {
        return this.condition.hasWhere();
    }

    final TableList getUsing() {
        return this.using;
    }

    @Override
    public final void addUsing(Collection<? extends TableLike<?>> f2) {
        for (TableLike<?> provider : f2) {
            this.using.add(provider.asTable());
        }
    }

    @Override
    public final void addUsing(TableLike<?> f2) {
        this.using.add(f2.asTable());
    }

    @Override
    public final void addUsing(TableLike<?> ... f2) {
        for (TableLike<?> provider : f2) {
            this.using.add(provider.asTable());
        }
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addOrderBy(OrderField<?> ... fields2) {
        this.addOrderBy(Arrays.asList(fields2));
    }

    @Override
    public final void addOrderBy(Collection<? extends OrderField<?>> fields2) {
        this.orderBy.addAll(Tools.sortFields(fields2));
    }

    @Override
    public final void addLimit(Number numberOfRows) {
        this.addLimit(DSL.val(numberOfRows));
    }

    @Override
    public final void addLimit(Param<? extends Number> numberOfRows) {
        this.limit = numberOfRows;
    }

    @Override
    final void accept0(Context<?> ctx) {
        ctx.start(Clause.DELETE_DELETE).visit(Keywords.K_DELETE).sql(' ');
        Table<?> t2 = this.table(ctx);
        boolean multiTableJoin = SUPPORT_MULTITABLE_DELETE.contains((Object)ctx.dialect()) && t2 instanceof JoinTable;
        boolean specialDeleteAsSyntax = SPECIAL_DELETE_AS_SYNTAX.contains((Object)ctx.dialect());
        if (multiTableJoin) {
            ctx.visit(Keywords.K_FROM).sql(' ').visit(Tools.traverseJoins(t2, new TableList(), null, (r2, x2) -> {
                r2.add(x2);
                return r2;
            })).formatSeparator();
        } else {
            ctx.visit(Keywords.K_FROM).sql(' ').declareTables(!specialDeleteAsSyntax, c2 -> c2.visit(t2));
        }
        if (!this.using.isEmpty() || multiTableJoin || specialDeleteAsSyntax && Tools.alias(t2) != null) {
            TableList u2;
            if (REQUIRE_REPEAT_FROM_IN_USING.contains((Object)ctx.dialect()) && !Tools.containsDeclaredTable(this.using, t2)) {
                u2 = new TableList(t2);
                u2.addAll(this.using);
            } else if (NO_SUPPORT_REPEAT_FROM_IN_USING.contains((Object)ctx.dialect()) && Tools.containsDeclaredTable(this.using, t2)) {
                u2 = new TableList(this.using);
                u2.remove(t2);
            } else {
                u2 = this.using;
            }
            ctx.formatSeparator().visit(Keywords.K_USING).sql(' ').declareTables(true, c2 -> c2.visit(u2));
        }
        ctx.end(Clause.DELETE_DELETE);
        boolean noSupportParametersInWhere = false;
        if (this.limit != null && NO_SUPPORT_LIMIT.contains((Object)ctx.dialect()) || !this.orderBy.isEmpty() && NO_SUPPORT_ORDER_BY_LIMIT.contains((Object)ctx.dialect())) {
            Field[] fieldArray;
            if (this.table().getKeys().isEmpty()) {
                Field[] fieldArray2 = new Field[1];
                fieldArray = fieldArray2;
                fieldArray2[0] = this.table().rowid();
            } else {
                fieldArray = (this.table().getPrimaryKey() != null ? this.table().getPrimaryKey() : this.table().getKeys().get(0)).getFieldsArray();
            }
            Field[] keyFields = fieldArray;
            ctx.start(Clause.DELETE_WHERE).formatSeparator().visit(Keywords.K_WHERE).sql(' ');
            ctx.paramTypeIf(ParamType.INLINED, noSupportParametersInWhere, c2 -> {
                if (keyFields.length == 1) {
                    c2.visit(keyFields[0].in(DSL.select(keyFields[0]).from((TableLike<?>)this.table()).where(this.getWhere()).orderBy(this.orderBy).limit(this.limit)));
                } else {
                    c2.visit(DSL.row(keyFields).in(DSL.select(keyFields).from((TableLike<?>)this.table()).where(this.getWhere()).orderBy(this.orderBy).limit(this.limit)));
                }
            });
            ctx.end(Clause.DELETE_WHERE);
        } else {
            ctx.start(Clause.DELETE_WHERE);
            if (this.hasWhere()) {
                ctx.paramTypeIf(ParamType.INLINED, noSupportParametersInWhere, c2 -> c2.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.getWhere()));
            }
            ctx.end(Clause.DELETE_WHERE);
            if (!this.orderBy.isEmpty()) {
                ctx.formatSeparator().visit(Keywords.K_ORDER_BY).sql(' ').visit(this.orderBy);
            }
            if (this.limit != null) {
                ctx.formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.limit);
            }
        }
        ctx.start(Clause.DELETE_RETURNING);
        this.toSQLReturning(ctx);
        ctx.end(Clause.DELETE_RETURNING);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final boolean isExecutable() {
        if (!this.condition.hasWhere()) {
            this.executeWithoutWhere("DELETE without WHERE", SettingsTools.getExecuteDeleteWithoutWhere(this.configuration().settings()));
        }
        return super.isExecutable();
    }
}

