/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jooq.BatchBindStep;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.Query;
import org.jooq.TableRecord;
import org.jooq.UpdatableRecord;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractBatch;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.tools.JooqLogger;

final class BatchCRUD
extends AbstractBatch {
    private static final JooqLogger log = JooqLogger.getLogger(BatchCRUD.class);
    private final TableRecord<?>[] records;
    private final Action action;

    BatchCRUD(Configuration configuration, Action action, TableRecord<?>[] records) {
        super(configuration);
        this.action = action;
        this.records = records;
    }

    @Override
    public final int size() {
        return this.records.length;
    }

    @Override
    public final int[] execute() throws DataAccessException {
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    private final Configuration deriveConfiguration(QueryCollector collector) {
        Configuration local = this.configuration.deriveAppending(collector);
        local.settings().withExecuteLogging(false).withReturnAllOnUpdatableRecord(false).withReturnIdentityOnUpdatableRecord(false);
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] executePrepared() {
        LinkedHashMap<String, List> queries = new LinkedHashMap<String, List>();
        QueryCollector collector = new QueryCollector();
        Configuration local = this.deriveConfiguration(collector);
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            Configuration previous = this.records[i2].configuration();
            try {
                this.records[i2].attach(local);
                this.executeAction(i2);
                continue;
            }
            catch (QueryCollectorSignal e2) {
                Query query = e2.getQuery();
                String sql = e2.getSQL();
                if (!query.isExecutable()) continue;
                queries.computeIfAbsent(sql, s2 -> new ArrayList()).add(query);
                continue;
            }
            finally {
                this.records[i2].attach(previous);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Batch " + this.action + " of " + this.records.length + " records using " + queries.size() + " distinct queries (lower is better) with an average number of bind variable sets of " + queries.values().stream().mapToInt(List::size).average().orElse(0.0) + " (higher is better)");
        }
        ArrayList result = new ArrayList();
        queries.forEach((k2, v2) -> {
            int[] array;
            BatchBindStep batch = this.dsl.batch((Query)v2.get(0));
            for (Query query : v2) {
                batch.bind(query.getBindValues().toArray());
            }
            for (int i2 : array = batch.execute()) {
                result.add(i2);
            }
        });
        int[] array = new int[result.size()];
        for (int i3 = 0; i3 < result.size(); ++i3) {
            array[i3] = (Integer)result.get(i3);
        }
        this.updateChangedFlag();
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] executeStatic() {
        ArrayList<Query> queries = new ArrayList<Query>();
        QueryCollector collector = new QueryCollector();
        Configuration local = this.deriveConfiguration(collector);
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            Configuration previous = this.records[i2].configuration();
            try {
                this.records[i2].attach(local);
                this.executeAction(i2);
                continue;
            }
            catch (QueryCollectorSignal e2) {
                Query query = e2.getQuery();
                if (!query.isExecutable()) continue;
                queries.add(query);
                continue;
            }
            finally {
                this.records[i2].attach(previous);
            }
        }
        int[] result = this.dsl.batch(queries).execute();
        this.updateChangedFlag();
        return result;
    }

    private void executeAction(int i2) {
        switch (this.action) {
            case STORE: {
                ((UpdatableRecord)this.records[i2]).store();
                break;
            }
            case INSERT: {
                this.records[i2].insert();
                break;
            }
            case UPDATE: {
                ((UpdatableRecord)this.records[i2]).update();
                break;
            }
            case MERGE: {
                ((UpdatableRecord)this.records[i2]).merge();
                break;
            }
            case DELETE: {
                ((UpdatableRecord)this.records[i2]).delete();
            }
        }
    }

    private final void updateChangedFlag() {
        for (TableRecord<?> record : this.records) {
            record.changed(this.action == Action.DELETE);
            if (!(record instanceof AbstractRecord)) continue;
            ((AbstractRecord)((Object)record)).fetched = this.action != Action.DELETE;
        }
    }

    private static class QueryCollectorSignal
    extends ControlFlowSignal {
        private final String sql;
        private final Query query;

        QueryCollectorSignal(String sql, Query query) {
            this.sql = sql;
            this.query = query;
        }

        String getSQL() {
            return this.sql;
        }

        Query getQuery() {
            return this.query;
        }
    }

    private static class QueryCollector
    extends DefaultExecuteListener {
        private QueryCollector() {
        }

        @Override
        public void renderEnd(ExecuteContext ctx) {
            throw new QueryCollectorSignal(ctx.sql(), ctx.query());
        }
    }

    static enum Action {
        STORE,
        INSERT,
        UPDATE,
        MERGE,
        DELETE;

    }
}

