/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.RecordImplN;

final class ArrayTableEmulation
extends AbstractTable<Record>
implements QOM.UTransient {
    private final Object[] array;
    private final FieldsImpl<Record> field;
    private final Name alias;
    private final Name fieldAlias;
    private transient Table<Record> table;

    ArrayTableEmulation(Object[] array) {
        this(array, Names.N_ARRAY_TABLE, null);
    }

    ArrayTableEmulation(Object[] array, Name alias) {
        this(array, alias, null);
    }

    ArrayTableEmulation(Object[] array, Name alias, Name fieldAlias) {
        super(TableOptions.expression(), alias);
        this.array = array;
        this.alias = alias;
        this.fieldAlias = fieldAlias == null ? Names.N_COLUMN_VALUE : fieldAlias;
        this.field = new FieldsImpl(DSL.field(DSL.name(alias.last(), this.fieldAlias.last()), DSL.getDataType(array.getClass().getComponentType())));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as2) {
        return new ArrayTableEmulation(this.array, as2);
    }

    @Override
    public final Table<Record> as(Name as2, Name ... fieldAliases) {
        if (fieldAliases == null) {
            return new ArrayTableEmulation(this.array, as2);
        }
        if (fieldAliases.length == 1) {
            return new ArrayTableEmulation(this.array, as2, fieldAliases[0]);
        }
        throw new IllegalArgumentException("Array table simulations can only have a single field alias");
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    private final Table<Record> table(Configuration configuration) {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param val = DSL.val(element, this.field.fields[0].getDataType());
                SelectSelectStep<Record> subselect = DSL.using(configuration).select(val.as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.using(configuration).select(DSL.one().as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = select.asTable(this.alias);
        }
        return this.table;
    }
}

