/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.RowN;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

abstract class AbstractInList<T>
extends AbstractCondition {
    static final int IN_LIMIT = 1000;
    static final Set<SQLDialect> REQUIRES_IN_LIMIT = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> NO_SUPPORT_EMPTY_LISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final Field<T> field;
    final QueryPartList<Field<T>> values;

    AbstractInList(Field<T> field, List<? extends Field<?>> values) {
        this.field = field;
        this.values = new QueryPartList((Iterable<Field<?>>)values);
    }

    abstract Function2<? super RowN, ? super RowN[], ? extends Condition> rowCondition();

    @Override
    public final void accept(Context<?> ctx) {
        if (this.field.getDataType().isEmbeddable()) {
            ctx.visit(this.rowCondition().apply(DSL.row(Tools.embeddedFields(this.field)), AbstractInList.rows(this.values)));
        } else if (this.field.getDataType().isMultiset() && !Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONDITION))) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONDITION, true, c2 -> c2.visit(this));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean in2 = this instanceof QOM.InList;
        if (this.values.size() == 0 && NO_SUPPORT_EMPTY_LISTS.contains((Object)ctx.dialect())) {
            if (in2) {
                ctx.visit(DSL.falseCondition());
            } else {
                ctx.visit(DSL.trueCondition());
            }
        } else if (this.values.size() > 1000) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sqlIndentStart('(');
                    for (int i2 = 0; i2 < this.values.size(); i2 += 1000) {
                        if (i2 > 0) {
                            if (in2) {
                                ctx.formatSeparator().visit(Keywords.K_OR).sql(' ');
                            } else {
                                ctx.formatSeparator().visit(Keywords.K_AND).sql(' ');
                            }
                        }
                        AbstractInList.toSQLSubValues(ctx, this.field, in2, AbstractInList.padded(ctx, this.values.subList(i2, Math.min(i2 + 1000, this.values.size()))));
                    }
                    ctx.sqlIndentEnd(')');
                    break;
                }
                default: {
                    AbstractInList.toSQLSubValues(ctx, this.field, in2, this.values);
                    break;
                }
            }
        } else {
            AbstractInList.toSQLSubValues(ctx, this.field, in2, AbstractInList.padded(ctx, this.values));
        }
    }

    static final RowN[] rows(List<? extends Field<?>> values) {
        return Tools.map(values, v2 -> DSL.row(Tools.embeddedFields(v2)), RowN[]::new);
    }

    static final <T> List<T> padded(Context<?> ctx, List<T> list) {
        return ctx.paramType() == ParamType.INDEXED && Boolean.TRUE.equals(ctx.settings().isInListPadding()) ? new PaddedList(list, REQUIRES_IN_LIMIT.contains((Object)ctx.dialect()) ? 1000 : Integer.MAX_VALUE, StringUtils.defaultIfNull(ctx.settings().getInListPadBase(), 2)) : list;
    }

    static final void toSQLSubValues(Context<?> ctx, Field<?> field, boolean in2, List<? extends Field<?>> subValues) {
        ctx.visit(field).sql(' ').visit(in2 ? Keywords.K_IN : Keywords.K_NOT_IN).sql(" (");
        if (subValues.size() > 1) {
            ctx.formatIndentStart().formatNewLine();
        }
        String separator = "";
        for (Field<?> value : subValues) {
            ctx.sql(separator).formatNewLineAfterPrintMargin().visit(value);
            separator = ", ";
        }
        if (subValues.size() > 1) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }

    public final Field<T> $arg1() {
        return this.field;
    }

    public final QOM.UnmodifiableList<? extends Field<T>> $arg2() {
        return QOM.unmodifiable(this.values);
    }

    static final class PaddedList<T>
    extends AbstractList<T> {
        private final List<T> delegate;
        private final int realSize;
        private final int padSize;

        PaddedList(List<T> delegate, int maxPadding, int padBase) {
            int b2 = Math.max(2, padBase);
            this.delegate = delegate;
            this.realSize = delegate.size();
            this.padSize = Math.min(maxPadding, (int)Math.round(Math.pow(b2, Math.ceil(Math.log(this.realSize) / Math.log(b2)))));
        }

        @Override
        public T get(int index) {
            return index < this.realSize ? this.delegate.get(index) : this.delegate.get(this.realSize - 1);
        }

        @Override
        public int size() {
            return this.padSize;
        }
    }
}

