/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jooq.tools.StringUtils;

final class FlywayVersion
implements Comparable<FlywayVersion> {
    public static final FlywayVersion EMPTY = new FlywayVersion(null);
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\.(?=\\d)");
    private final List<BigInteger> versionParts;

    public static FlywayVersion fromVersion(String version) {
        if (StringUtils.isEmpty(version)) {
            return EMPTY;
        }
        return new FlywayVersion(version);
    }

    private FlywayVersion(String version) {
        if (!StringUtils.isEmpty(version)) {
            String normalizedVersion = version.replace('_', '.');
            this.versionParts = this.tokenize(normalizedVersion);
        } else {
            this.versionParts = new ArrayList<BigInteger>();
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FlywayVersion version1 = (FlywayVersion)o2;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    @Override
    public int compareTo(FlywayVersion o2) {
        if (o2 == null) {
            return 1;
        }
        if (this == EMPTY) {
            if (o2 == EMPTY) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }
        if (o2 == EMPTY) {
            return Integer.MAX_VALUE;
        }
        List<BigInteger> parts1 = this.versionParts;
        List<BigInteger> parts2 = o2.versionParts;
        int largestNumberOfParts = Math.max(parts1.size(), parts2.size());
        for (int i2 = 0; i2 < largestNumberOfParts; ++i2) {
            int compared = this.getOrZero(parts1, i2).compareTo(this.getOrZero(parts2, i2));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    private BigInteger getOrZero(List<BigInteger> elements, int i2) {
        return i2 < elements.size() ? elements.get(i2) : BigInteger.ZERO;
    }

    private List<BigInteger> tokenize(String versionStr) {
        ArrayList<BigInteger> parts = new ArrayList<BigInteger>();
        for (String part : SPLIT_REGEX.split(versionStr)) {
            parts.add(new BigInteger(part));
        }
        for (int i2 = parts.size() - 1; i2 > 0 && ((BigInteger)parts.get(i2)).equals(BigInteger.ZERO); --i2) {
            parts.remove(i2);
        }
        return parts;
    }
}

