/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Collections;
import java.util.List;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;

public class ProjectedCoordinateReferenceSystem
extends CoordinateReferenceSystem {
    private final Projection projection;
    private final GeographicCoordinateReferenceSystem geoCRS;
    private final List<CrsParameter> parameters;

    public ProjectedCoordinateReferenceSystem(CrsId crsId, String name, GeographicCoordinateReferenceSystem geoCRS, Projection projection, List<CrsParameter> parameters, CoordinateSystemAxis ... axes) {
        super(crsId, name, axes);
        this.geoCRS = geoCRS;
        this.projection = projection;
        this.parameters = parameters;
    }

    public List<CrsParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public GeographicCoordinateReferenceSystem getGeographicCoordinateSystem() {
        return this.geoCRS;
    }

    public Projection getProjection() {
        return this.projection;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ProjectedCoordinateReferenceSystem)) {
            return false;
        }
        ProjectedCoordinateReferenceSystem that = (ProjectedCoordinateReferenceSystem)o2;
        if (this.geoCRS != null ? !this.geoCRS.equals(that.geoCRS) : that.geoCRS != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.projection != null ? !this.projection.equals(that.projection) : that.projection != null);
    }

    @Override
    public int hashCode() {
        int result = this.projection != null ? this.projection.hashCode() : 0;
        result = 31 * result + (this.geoCRS != null ? this.geoCRS.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

