/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WktEncoder;

class PostgisWktEncoder
implements WktEncoder {
    private static final PostgisWktVariant WKT_WORDS = new PostgisWktVariant();
    private static final int MAX_FRACTIONAL_DIGITS = 24;
    private static final DecimalFormatSymbols US_DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private final FieldPosition fp = new FieldPosition(0);
    private final NumberFormat formatter = new DecimalFormat("0.#", US_DECIMAL_FORMAT_SYMBOLS);
    private StringBuffer builder;
    private boolean inGeometryCollection = false;

    public PostgisWktEncoder() {
        this.formatter.setMaximumFractionDigits(24);
    }

    @Override
    public String encode(Geometry geometry) {
        this.prepare();
        this.addSridIfValid(geometry);
        this.addGeometry(geometry);
        return this.result();
    }

    private void prepare() {
        this.builder = new StringBuffer();
        this.inGeometryCollection = false;
    }

    private void addSridIfValid(Geometry geometry) {
        if (geometry.getSRID() < 1) {
            return;
        }
        this.builder.append("SRID=").append(geometry.getSRID()).append(";");
    }

    private void addGeometry(Geometry geometry) {
        this.addGeometryTag(geometry);
        this.addGeometryText(geometry);
    }

    private void addGeometryText(Geometry geometry) {
        if (geometry.isEmpty()) {
            this.addEmptyKeyword();
            return;
        }
        GeometryType type = geometry.getGeometryType();
        switch (type) {
            case POINT: 
            case LINE_STRING: 
            case LINEAR_RING: {
                this.addPointList(geometry.getPoints());
                break;
            }
            case POLYGON: {
                this.addStartList();
                this.addLinearRings((Polygon)geometry);
                this.addEndList();
                break;
            }
            case GEOMETRY_COLLECTION: {
                this.addStartList();
                this.addGeometries((GeometryCollection)geometry, true);
                this.addEndList();
                break;
            }
            case MULTI_POINT: 
            case MULTI_LINE_STRING: 
            case MULTI_POLYGON: {
                this.addStartList();
                this.addGeometries((GeometryCollection)geometry, false);
                this.addEndList();
                break;
            }
            default: {
                throw new UnsupportedConversionException(String.format("Geometry type %s not supported.", new Object[]{type}));
            }
        }
    }

    private void addGeometries(GeometryCollection collection, boolean withTag) {
        this.inGeometryCollection = true;
        for (int i2 = 0; i2 < collection.getNumGeometries(); ++i2) {
            if (i2 > 0) {
                this.addDelimiter();
            }
            Geometry geom = collection.getGeometryN(i2);
            if (withTag) {
                this.addGeometry(geom);
                continue;
            }
            this.addGeometryText(geom);
        }
    }

    private void addLinearRings(Polygon geometry) {
        this.addRing(geometry.getExteriorRing());
        for (int i2 = 0; i2 < geometry.getNumInteriorRing(); ++i2) {
            this.addDelimiter();
            this.addRing(geometry.getInteriorRingN(i2));
        }
    }

    private void addRing(LinearRing ring) {
        this.addPointList(ring.getPoints());
    }

    private void addPointList(PointCollection points) {
        this.addStartList();
        double[] coords = new double[points.getCoordinateDimension()];
        for (int i2 = 0; i2 < points.size(); ++i2) {
            if (i2 > 0) {
                this.addDelimiter();
            }
            points.getCoordinates(coords, i2);
            this.addPoint(coords);
        }
        this.addEndList();
    }

    private void addEndList() {
        this.builder.append(')');
    }

    private void addPoint(double[] coords) {
        for (int i2 = 0; i2 < coords.length; ++i2) {
            if (i2 > 0) {
                this.addWhitespace();
            }
            this.addNumber(coords[i2]);
        }
    }

    private void addNumber(double value) {
        this.formatter.format(value, this.builder, this.fp);
    }

    private void addWhitespace() {
        this.builder.append(" ");
    }

    private void addDelimiter() {
        this.builder.append(",");
    }

    private void addStartList() {
        this.builder.append("(");
    }

    private void addEmptyKeyword() {
        this.builder.append(" EMPTY");
    }

    private void addGeometryTag(Geometry geometry) {
        if (this.inGeometryCollection) {
            this.builder.append(WKT_WORDS.wordFor(geometry, true));
        } else {
            this.builder.append(WKT_WORDS.wordFor(geometry, false));
        }
    }

    private String result() {
        return this.builder.toString();
    }
}

