/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Point;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;

abstract class AbstractWkbEncoder
implements WkbEncoder {
    AbstractWkbEncoder() {
    }

    @Override
    public ByteBuffer encode(Geometry geometry, ByteOrder byteOrder) {
        ByteBuffer output = ByteBuffer.allocate(this.calculateSize(geometry, true));
        if (byteOrder != null) {
            output.setByteOrder(byteOrder);
        }
        this.writeGeometry(geometry, output);
        output.rewind();
        return output;
    }

    protected void writeGeometry(Geometry geom, ByteBuffer output) {
        geom.accept(this.newWkbVisitor(output));
    }

    protected WkbVisitor newWkbVisitor(ByteBuffer output) {
        return new WkbVisitor(output);
    }

    protected int calculateSize(Geometry geom, boolean includeSrid) {
        int size = 5;
        if (geom.getSRID() > 0 && includeSrid) {
            size += 4;
        }
        if (geom.isEmpty()) {
            return size + this.sizeEmptyGeometry(geom);
        }
        if (geom instanceof GeometryCollection) {
            size += this.sizeOfGeometryCollection((GeometryCollection)geom);
        } else if (geom instanceof Polygon) {
            size += this.getPolygonSize((Polygon)geom);
        } else if (geom instanceof Point) {
            size += this.getPointByteSize(geom);
        } else if (geom instanceof PolyHedralSurface) {
            size += this.getPolyHedralSurfaceSize((PolyHedralSurface)geom);
        } else {
            size += 4;
            size += this.getPointByteSize(geom) * geom.getNumPoints();
        }
        return size;
    }

    protected abstract int sizeEmptyGeometry(Geometry var1);

    private int getPointByteSize(Geometry geom) {
        return geom.getCoordinateDimension() * 8;
    }

    private int getPolyHedralSurfaceSize(PolyHedralSurface geom) {
        int size = 4;
        for (int i2 = 0; i2 < geom.getNumPatches(); ++i2) {
            size += this.getPolygonSize(geom.getPatchN(i2));
        }
        return size;
    }

    private int getPolygonSize(Polygon geom) {
        int size = 4;
        size += geom.isEmpty() ? 0 : 4 * (geom.getNumInteriorRing() + 1);
        return size += this.getPointByteSize(geom) * geom.getNumPoints();
    }

    private int sizeOfGeometryCollection(GeometryCollection collection) {
        int size = 4;
        for (Geometry g2 : collection) {
            size += this.calculateSize(g2, false);
        }
        return size;
    }
}

