/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Point;
import org.geolatte.geom.Points;

public class Vector {
    public static double[] pointToSegment2D(Point p0, Point p1, Point y2) {
        Point d2 = Vector.substract(p1, p0);
        Point ymp0 = Vector.substract(y2, p0);
        double t2 = Vector.dot(d2, ymp0, true);
        double dd2 = Vector.dot(d2, d2);
        if (t2 <= 0.0) {
            return new double[]{Vector.dot(ymp0, ymp0), t2 / dd2};
        }
        if (t2 >= dd2) {
            Point ymp1 = Vector.substract(y2, p1);
            return new double[]{Vector.dot(ymp1, ymp1), t2 / dd2};
        }
        return new double[]{Vector.dot(ymp0, ymp0) - t2 * t2 / dd2, t2 / dd2};
    }

    public static double dot(Point p0, Point p1) {
        return Vector.dot(p0, p1, false);
    }

    public static double dot(Point p0, Point p1, boolean limit2D) {
        if (limit2D || !p0.is3D() || !p1.is3D()) {
            return p0.getX() * p1.getX() + p0.getY() * p1.getY();
        }
        return p0.getX() * p1.getX() + p0.getY() * p1.getY() + p0.getZ() * p1.getZ();
    }

    public static Point add(Point p0, Point p1) {
        if (p0.is3D() && p1.is3D()) {
            return Points.create3D(p0.getX() + p1.getX(), p0.getY() + p1.getY(), p0.getZ() + p1.getZ());
        }
        return Points.create2D(p0.getX() + p1.getX(), p0.getY() + p1.getY());
    }

    public static Point substract(Point p0, Point p1) {
        if (p0.is3D() && p1.is3D()) {
            return Points.create3D(p0.getX() - p1.getX(), p0.getY() - p1.getY(), p0.getZ() - p1.getZ());
        }
        return Points.create2D(p0.getX() - p1.getX(), p0.getY() - p1.getY());
    }

    public static Point perp(Point p2) {
        if (p2 == null || p2.isEmpty()) {
            return Points.createEmpty();
        }
        if (p2.is3D() && p2.isMeasured()) {
            return Points.create3DM(-p2.getY(), p2.getX(), p2.getZ(), p2.getM(), p2.getCrsId());
        }
        if (p2.is3D()) {
            return Points.create3D(-p2.getY(), p2.getX(), p2.getZ(), p2.getCrsId());
        }
        if (p2.isMeasured()) {
            return Points.create2DM(-p2.getY(), p2.getX(), p2.getM(), p2.getCrsId());
        }
        return Points.create2D(-p2.getY(), p2.getX(), p2.getCrsId());
    }

    public static double perpDot(Point p0, Point p1) {
        if (p0 == null || p1 == null || p0.isEmpty() || p1.isEmpty()) {
            throw new IllegalArgumentException("Null or empty Point passed.");
        }
        return -p0.getY() * p1.getX() + p0.getX() * p1.getY();
    }
}

