/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import org.geolatte.common.transformer.ObservableTransformer;
import org.geolatte.common.transformer.TransformerErrorEvent;
import org.geolatte.common.transformer.TransformerEventListener;

public abstract class AbstractObservableTransformer<Source, Target>
extends ObservableTransformer<Source, Target> {
    private ArrayList<TransformerEventListener> transformerEventListeners = new ArrayList();

    @Override
    public void addTransformerEventListener(TransformerEventListener listener) {
        if (listener != null) {
            this.transformerEventListeners.add(listener);
        }
    }

    @Override
    public void removeTransformerEventListener(TransformerEventListener listener) {
        this.transformerEventListeners.remove(listener);
    }

    protected void onTransformerErrorOccurred(Source failedObject, Exception exception) {
        for (TransformerEventListener listener : this.transformerEventListeners) {
            this.fireErrorEvent(listener, new TransformerErrorEvent(this, failedObject, exception));
        }
    }

    protected void onTransformerErrorOccurred(TransformerErrorEvent event) {
        for (TransformerEventListener listener : this.transformerEventListeners) {
            this.fireErrorEvent(listener, event);
        }
    }

    private void fireErrorEvent(TransformerEventListener listener, TransformerErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e2) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bed behaved listener.");
            e2.printStackTrace();
            this.removeTransformerEventListener(listener);
        }
    }
}

