/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.expressions;

import java.util.Date;
import org.geolatte.common.expressions.BasicTypeSwitch;
import org.geolatte.common.expressions.ComparableExpression;

public abstract class DateExpression
implements ComparableExpression<Date> {
    @Override
    public int compareTo(Object evaluateObject, Date value) throws ClassCastException, NullPointerException {
        Date thisDate = (Date)this.evaluate(evaluateObject);
        if (thisDate == null) {
            throw new NullPointerException("This date evaluated to null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The given date value is null");
        }
        if (thisDate.equals(value)) {
            return 0;
        }
        return thisDate.before(value) ? -1 : 1;
    }

    @Override
    public void switchOn(BasicTypeSwitch switcher) {
        switcher.caseDate(this);
    }
}

