/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PoolingDataSource<C extends Connection>
implements DataSource,
AutoCloseable {
    private static final Log log = LogFactory.getLog(PoolingDataSource.class);
    private boolean accessToUnderlyingConnectionAllowed;
    private PrintWriter logWriter;
    private final ObjectPool<C> pool;

    public PoolingDataSource(ObjectPool<C> pool) {
        Objects.requireNonNull(pool, "Pool must not be null.");
        this.pool = pool;
        if (this.pool instanceof GenericObjectPool) {
            PoolableConnectionFactory pcf = (PoolableConnectionFactory)((GenericObjectPool)this.pool).getFactory();
            Objects.requireNonNull(pcf, "PoolableConnectionFactory must not be null.");
            if (pcf.getPool() != this.pool) {
                log.warn(Utils.getMessage("poolingDataSource.factoryConfig"));
                ObjectPool<PoolableConnection> p2 = this.pool;
                pcf.setPool(p2);
            }
        }
    }

    @Override
    public void close() throws RuntimeException, SQLException {
        try {
            this.pool.close();
        }
        catch (RuntimeException rte) {
            throw new RuntimeException(Utils.getMessage("pool.close.fail"), rte);
        }
        catch (Exception e2) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), e2);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Connection conn = (Connection)this.pool.borrowObject();
            if (conn == null) {
                return null;
            }
            return new PoolGuardConnectionWrapper(this, conn);
        }
        catch (NoSuchElementException e2) {
            throw new SQLException("Cannot get a connection, pool error " + e2.getMessage(), e2);
        }
        catch (RuntimeException | SQLException e3) {
            throw e3;
        }
        catch (InterruptedException e4) {
            Thread.currentThread().interrupt();
            throw new SQLException("Cannot get a connection, general error", e4);
        }
        catch (Exception e5) {
            throw new SQLException("Cannot get a connection, general error", e5);
        }
    }

    @Override
    public Connection getConnection(String uname, String passwd) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected ObjectPool<C> getPool() {
        return this.pool;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isInstance(this);
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(this + " is not a wrapper for " + iface);
    }

    private static class PoolGuardConnectionWrapper<D extends Connection>
    extends DelegatingConnection<D> {
        final /* synthetic */ PoolingDataSource this$0;

        PoolGuardConnectionWrapper(D delegate) {
            this.this$0 = var1_1;
            super(delegate);
        }

        @Override
        public void close() throws SQLException {
            if (this.getDelegateInternal() != null) {
                super.close();
                super.setDelegate(null);
            }
        }

        @Override
        public D getDelegate() {
            return this.this$0.isAccessToUnderlyingConnectionAllowed() ? (D)super.getDelegate() : null;
        }

        @Override
        public Connection getInnermostDelegate() {
            return this.this$0.isAccessToUnderlyingConnectionAllowed() ? super.getInnermostDelegate() : null;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.getDelegateInternal() == null || super.isClosed();
        }
    }
}

