/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.threeten;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.threeten.NegativeDayOfMonthPattern;

final class SPX
implements Externalizable {
    static final int NEGATIVE_DAY_OF_MONTH_PATTERN_TYPE = 123;
    private static final long serialVersionUID = 5389786104865417939L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 123: {
                SPX.writePattern(this.obj, objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        switch (by2) {
            case 123: {
                this.obj = SPX.readPattern(objectInput);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private static void writePattern(Object object, ObjectOutput objectOutput) throws IOException {
        NegativeDayOfMonthPattern negativeDayOfMonthPattern = (NegativeDayOfMonthPattern)object;
        objectOutput.writeInt(negativeDayOfMonthPattern.getMonth().getValue());
        objectOutput.writeObject(negativeDayOfMonthPattern.getTimeOfDay());
        objectOutput.writeObject((Object)negativeDayOfMonthPattern.getIndicator());
        objectOutput.writeInt(negativeDayOfMonthPattern.getSavings());
        objectOutput.writeInt(negativeDayOfMonthPattern.getDomIndicator());
        objectOutput.writeByte(negativeDayOfMonthPattern.getDayOfWeek());
    }

    private static DaylightSavingRule readPattern(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Month month = Month.valueOf(objectInput.readInt());
        PlainTime plainTime = (PlainTime)objectInput.readObject();
        OffsetIndicator offsetIndicator = (OffsetIndicator)((Object)objectInput.readObject());
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        Weekday weekday = Weekday.valueOf(objectInput.readByte());
        return new NegativeDayOfMonthPattern(month, n3, weekday, plainTime, offsetIndicator, n2);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

