/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.Moment;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.WallTime;
import net.time4j.engine.EpochDays;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.ArrayTransitionModel;
import net.time4j.tz.model.CompositeTransitionModel;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.EmptyTransitionModel;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.RuleComparator;

public abstract class TransitionModel
implements TransitionHistory,
Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");

    TransitionModel() {
    }

    public static TransitionHistory of(List<ZonalTransition> list) {
        return new ArrayTransitionModel(list);
    }

    public static TransitionHistory of(ZonalOffset zonalOffset, List<DaylightSavingRule> list) {
        if (list.isEmpty()) {
            return new EmptyTransitionModel(zonalOffset);
        }
        return new RuleBasedTransitionModel(zonalOffset, list);
    }

    public static TransitionHistory of(ZonalOffset zonalOffset, List<ZonalTransition> list, List<DaylightSavingRule> list2) {
        return TransitionModel.of(zonalOffset, list, list2, true, true);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean hasNegativeDST() {
        return false;
    }

    static TransitionHistory of(ZonalOffset zonalOffset, List<ZonalTransition> list, List<DaylightSavingRule> list2, boolean bl2, boolean bl3) {
        long l2;
        List<DaylightSavingRule> list3;
        List<ZonalTransition> list4;
        if (bl2) {
            list4 = new ArrayList<ZonalTransition>(list);
            list3 = new ArrayList<DaylightSavingRule>(list2);
            Collections.sort(list4);
            list3.sort(RuleComparator.INSTANCE);
        } else {
            list4 = list;
            list3 = list2;
        }
        int n2 = list4.size();
        if (n2 == 0) {
            if (list3.isEmpty()) {
                return new EmptyTransitionModel(zonalOffset);
            }
            return new RuleBasedTransitionModel(zonalOffset, list3, false);
        }
        ZonalOffset zonalOffset2 = ZonalOffset.ofTotalSeconds(list4.get(0).getPreviousOffset());
        if (bl3 && !zonalOffset.equals(zonalOffset2)) {
            throw new IllegalArgumentException("Initial offset " + zonalOffset + " not equal to previous offset of first transition: " + zonalOffset2);
        }
        if (list3.isEmpty()) {
            return new ArrayTransitionModel(list4, false, bl3);
        }
        ZonalTransition zonalTransition = list4.get(n2 - 1);
        long l3 = zonalTransition.getPosixTime() + 1L;
        if (l3 < (l2 = TransitionModel.getFutureMoment(1))) {
            list4.addAll(RuleBasedTransitionModel.getTransitions(zonalTransition, list3, l3, l2));
        }
        return new CompositeTransitionModel(n2, list4, list3, false, bl3);
    }

    static List<ZonalOffset> toList(int n2) {
        return Collections.singletonList(ZonalOffset.ofTotalSeconds(n2));
    }

    static List<ZonalOffset> toList(int n2, int n3) {
        ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds(n2);
        ZonalOffset zonalOffset2 = ZonalOffset.ofTotalSeconds(n3);
        ArrayList<ZonalOffset> arrayList = new ArrayList<ZonalOffset>(2);
        arrayList.add(zonalOffset);
        arrayList.add(zonalOffset2);
        return Collections.unmodifiableList(arrayList);
    }

    static long toLocalSecs(GregorianDate gregorianDate, WallTime wallTime) {
        long l2 = GregorianMath.toMJD(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
        long l3 = MathUtils.safeMultiply(EpochDays.UNIX.transform(l2, EpochDays.MODIFIED_JULIAN_DATE), 86400L);
        l3 += (long)(wallTime.getHour() * 3600);
        l3 += (long)(wallTime.getMinute() * 60);
        return l3 += (long)wallTime.getSecond();
    }

    static void dump(ZonalTransition zonalTransition, Appendable appendable) throws IOException {
        Moment moment = Moment.of(zonalTransition.getPosixTime(), TimeScale.POSIX);
        appendable.append(">>> Transition at: ").append(moment.toString());
        appendable.append(" from ").append(TransitionModel.format(zonalTransition.getPreviousOffset()));
        appendable.append(" to ").append(TransitionModel.format(zonalTransition.getTotalOffset()));
        appendable.append(", DST=");
        appendable.append(TransitionModel.format(zonalTransition.getExtraOffset()));
        appendable.append(NEW_LINE);
    }

    static long getFutureMoment(int n2) {
        long l2 = (long)(3.1556952E7 * (double)n2);
        return System.currentTimeMillis() / 1000L + l2;
    }

    private static String format(int n2) {
        return ZonalOffset.ofTotalSeconds(n2).toString();
    }
}

