/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import net.time4j.ClockUnit;
import net.time4j.DayCycles;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.base.GregorianDate;
import net.time4j.format.CalendarType;
import net.time4j.tz.model.OffsetIndicator;

public abstract class DaylightSavingRule {
    private final transient long dayOverflow;
    private final transient PlainTime timeOfDay;
    private final transient OffsetIndicator indicator;
    private final transient int savings;

    protected DaylightSavingRule(int n2, OffsetIndicator offsetIndicator, int n3) {
        if (offsetIndicator == null) {
            throw new NullPointerException("Missing offset indicator.");
        }
        if (n3 != Integer.MAX_VALUE && (n3 < -64800 || n3 > 64800)) {
            throw new IllegalArgumentException("DST out of range: " + n3);
        }
        if (n2 == 86400) {
            this.dayOverflow = 0L;
            this.timeOfDay = PlainTime.midnightAtEndOfDay();
        } else {
            DayCycles dayCycles = PlainTime.midnightAtStartOfDay().roll(n2, ClockUnit.SECONDS);
            this.dayOverflow = dayCycles.getDayOverflow();
            this.timeOfDay = dayCycles.getWallTime();
        }
        this.indicator = offsetIndicator;
        this.savings = n3 == Integer.MAX_VALUE ? 0 : n3;
    }

    public abstract PlainDate getDate(int var1);

    public final PlainTime getTimeOfDay() {
        return this.timeOfDay;
    }

    public final OffsetIndicator getIndicator() {
        return this.indicator;
    }

    public final int getSavings() {
        return this.savings;
    }

    protected abstract int toCalendarYear(long var1);

    protected abstract int toCalendarYear(GregorianDate var1);

    protected String getCalendarType() {
        CalendarType calendarType = this.getClass().getAnnotation(CalendarType.class);
        if (calendarType == null) {
            throw new IllegalStateException("Cannot find calendar type annotation: " + this.getClass());
        }
        return calendarType.value();
    }

    protected final long getDayOverflow() {
        return this.dayOverflow;
    }

    int getType() {
        return 0;
    }
}

