/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.NameStyle;
import net.time4j.tz.NamedID;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class PlatformTimezone
extends Timezone {
    private static final long serialVersionUID = -8432968264242113551L;
    private final TZID id;
    private final TimeZone tz;
    private final boolean strict;
    private final transient ZonalOffset fixedOffset;

    PlatformTimezone() {
        this.id = null;
        this.tz = null;
        this.strict = false;
        this.fixedOffset = null;
    }

    PlatformTimezone(TZID tZID) {
        this(tZID, TimeZone.getDefault(), false);
    }

    PlatformTimezone(TZID tZID, String string) {
        this(tZID, PlatformTimezone.findZone(string), false);
    }

    private PlatformTimezone(TZID tZID, TimeZone timeZone, boolean bl2) {
        this.id = tZID;
        this.tz = (TimeZone)timeZone.clone();
        this.strict = bl2;
        if (this.tz.useDaylightTime()) {
            this.fixedOffset = null;
        } else {
            String string = this.tz.getID();
            boolean bl3 = string.startsWith("GMT") || string.startsWith("Etc/") || string.equals("Greenwich") || string.equals("UCT") || string.equals("UTC") || string.equals("Universal") || string.equals("Zulu");
            this.fixedOffset = bl3 ? PlatformTimezone.fromOffsetMillis(this.tz.getOffset(System.currentTimeMillis())) : null;
        }
    }

    @Override
    public TZID getID() {
        if (this.id == null) {
            String string = TimeZone.getDefault().getID();
            return new NamedID(string);
        }
        return this.id;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        TimeZone timeZone;
        if (this.id == null) {
            timeZone = TimeZone.getDefault();
        } else {
            if (this.fixedOffset != null) {
                return this.fixedOffset;
            }
            timeZone = this.tz;
        }
        return PlatformTimezone.fromOffsetMillis(timeZone.getOffset(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public ZonalOffset getRawOffset(UnixTime unixTime) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(unixTime.getPosixTime() * 1000L);
        return PlatformTimezone.fromOffsetMillis(gregorianCalendar.get(15));
    }

    @Override
    public ZonalOffset getExtraOffset(UnixTime unixTime) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(unixTime.getPosixTime() * 1000L);
        return PlatformTimezone.fromOffsetMillis(gregorianCalendar.get(16));
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        int n2;
        int n3;
        if (this.fixedOffset != null) {
            return this.fixedOffset;
        }
        int n4 = gregorianDate.getYear();
        int n5 = gregorianDate.getMonth();
        int n6 = gregorianDate.getDayOfMonth();
        if (wallTime.getHour() == 24) {
            long l2 = MathUtils.safeAdd(GregorianMath.toMJD(gregorianDate), 1L);
            long l3 = GregorianMath.toPackedDate(l2);
            n4 = GregorianMath.readYear(l3);
            n5 = GregorianMath.readMonth(l3);
            n6 = GregorianMath.readDayOfMonth(l3);
        }
        if (n4 > 0) {
            n3 = 1;
            n2 = n4;
        } else {
            n3 = 0;
            n2 = 1 - n4;
        }
        int n7 = GregorianMath.getDayOfWeek(n4, n5, n6) + 1;
        if (n7 == 8) {
            n7 = 1;
        }
        int n8 = wallTime.getHour() == 24 ? 0 : (wallTime.getHour() * 3600 + wallTime.getMinute() * 60 + wallTime.getSecond()) * 1000 + wallTime.getNanosecond() / 1000000;
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return PlatformTimezone.fromOffsetMillis(timeZone.getOffset(n3, n2, n5 - 1, n6, n7, n8));
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        if (this.fixedOffset != null) {
            return false;
        }
        int n2 = gregorianDate.getYear();
        int n3 = gregorianDate.getMonth();
        int n4 = gregorianDate.getDayOfMonth();
        int n5 = wallTime.getHour();
        int n6 = wallTime.getMinute();
        int n7 = wallTime.getSecond();
        int n8 = wallTime.getNanosecond() / 1000000;
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(14, n8);
        gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, n7);
        return gregorianCalendar.get(1) != n2 || gregorianCalendar.get(2) + 1 != n3 || gregorianCalendar.get(5) != n4 || gregorianCalendar.get(11) != n5 || gregorianCalendar.get(12) != n6 || gregorianCalendar.get(13) != n7 || gregorianCalendar.get(14) != n8;
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        if (this.fixedOffset != null) {
            return false;
        }
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.inDaylightTime(new Date(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public boolean isFixed() {
        return this.fixedOffset != null;
    }

    @Override
    public TransitionHistory getHistory() {
        return this.fixedOffset == null ? null : this.fixedOffset.getModel();
    }

    public boolean equals(Object object) {
        if (object instanceof PlatformTimezone) {
            PlatformTimezone platformTimezone = (PlatformTimezone)object;
            if (this.id == null) {
                return platformTimezone.id == null;
            }
            if (!this.tz.equals(platformTimezone.tz) || this.strict != platformTimezone.strict) {
                return false;
            }
            if (this.fixedOffset == null) {
                return platformTimezone.fixedOffset == null;
            }
            return this.fixedOffset.equals(platformTimezone.fixedOffset);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.tz.hashCode();
    }

    public String toString() {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(timeZone);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.getDisplayName(nameStyle.isDaylightSaving(), nameStyle.isAbbreviation() ? 0 : 1, locale);
    }

    @Override
    public TransitionStrategy getStrategy() {
        return this.strict ? STRICT_MODE : DEFAULT_CONFLICT_STRATEGY;
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        if (this.id == null || this.getStrategy() == transitionStrategy) {
            return this;
        }
        if (transitionStrategy == DEFAULT_CONFLICT_STRATEGY) {
            return new PlatformTimezone(this.id, this.tz, false);
        }
        if (transitionStrategy == STRICT_MODE) {
            return new PlatformTimezone(this.id, this.tz, true);
        }
        throw new UnsupportedOperationException(transitionStrategy.toString());
    }

    static TimeZone findZone(String string) {
        if (string.equals("Z")) {
            return TimeZone.getTimeZone("GMT+00:00");
        }
        if (string.startsWith("UTC")) {
            return TimeZone.getTimeZone("GMT" + string.substring(3));
        }
        if (string.startsWith("UT")) {
            return TimeZone.getTimeZone("GMT" + string.substring(2));
        }
        return TimeZone.getTimeZone(string);
    }

    boolean isGMT() {
        TimeZone timeZone = this.id == null ? TimeZone.getDefault() : this.tz;
        return timeZone.getID().equals("GMT");
    }

    private static ZonalOffset fromOffsetMillis(int n2) {
        return ZonalOffset.ofTotalSeconds(MathUtils.floorDivide(n2, 1000));
    }

    private Object readResolve() {
        if (this.id == null) {
            return new PlatformTimezone();
        }
        return new PlatformTimezone(this.id, this.tz, this.strict);
    }
}

