/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.TemporalType;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimePoint;
import net.time4j.scale.TimeScale;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public abstract class JDBCAdapter<S, T>
extends TemporalType<S, T> {
    private static final boolean WITH_SQL_UTC_CONVERSION = Boolean.getBoolean("net.time4j.sql.utc.conversion");
    private static final PlainDate UNIX_DATE = PlainDate.of(0L, EpochDays.UNIX);
    public static final JDBCAdapter<Date, PlainDate> SQL_DATE = new SqlDateRule();
    public static final JDBCAdapter<Time, PlainTime> SQL_TIME = new SqlTimeRule();
    public static final JDBCAdapter<Timestamp, PlainTimestamp> SQL_TIMESTAMP = new SqlTimestampRule();
    public static final JDBCAdapter<Timestamp, Moment> SQL_TIMESTAMP_WITH_ZONE = new SqlMomentRule();

    private JDBCAdapter() {
    }

    private static class SqlDateRule
    extends JDBCAdapter<Date, PlainDate> {
        private SqlDateRule() {
        }

        @Override
        public PlainDate translate(Date date) {
            long l2 = date.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l2, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l2 += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return PlainDate.axis().getCalendarSystem().transform(MathUtils.floorDivide(l2, 86400000) - 730L);
        }

        @Override
        public Date from(PlainDate plainDate) {
            int n2 = plainDate.getYear();
            if (n2 < 1900 || n2 > 9999) {
                throw new ChronoException("SQL-Date is only defined in year range of 1900-9999.");
            }
            long l2 = MathUtils.safeMultiply(plainDate.get(EpochDays.UNIX), 86400000L);
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(plainDate, PlainTime.of(0));
                l2 -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Date(l2);
        }

        @Override
        public Class<Date> getSourceType() {
            return Date.class;
        }
    }

    private static class SqlTimeRule
    extends JDBCAdapter<Time, PlainTime> {
        private SqlTimeRule() {
        }

        @Override
        public PlainTime translate(Time time) {
            long l2 = time.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l2, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l2 += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return (PlainTime)PlainTime.midnightAtStartOfDay().with((ChronoElement<Integer>)PlainTime.MILLI_OF_DAY, MathUtils.floorModulo(l2, 86400000));
        }

        @Override
        public Time from(PlainTime plainTime) {
            long l2 = plainTime.getInt(PlainTime.MILLI_OF_DAY);
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(UNIX_DATE, plainTime);
                l2 -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Time(l2);
        }

        @Override
        public Class<Time> getSourceType() {
            return Time.class;
        }
    }

    private static class SqlTimestampRule
    extends JDBCAdapter<Timestamp, PlainTimestamp> {
        private SqlTimestampRule() {
        }

        @Override
        public PlainTimestamp translate(Timestamp timestamp) {
            Comparable<ZonalOffset> comparable;
            TimePoint timePoint;
            long l2 = timestamp.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                timePoint = Moment.of(MathUtils.floorDivide(l2, 1000), TimeScale.POSIX);
                comparable = Timezone.ofSystem().getOffset((UnixTime)((Object)timePoint));
                l2 += (long)(comparable.getIntegralAmount() * 1000);
            }
            timePoint = PlainDate.of(MathUtils.floorDivide(l2, 86400000), EpochDays.UNIX);
            comparable = PlainTime.of(0).plus((long)MathUtils.floorModulo(l2, 86400000), ClockUnit.MILLIS);
            PlainTimestamp plainTimestamp = PlainTimestamp.of((PlainDate)timePoint, (PlainTime)comparable);
            return (PlainTimestamp)plainTimestamp.with((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, timestamp.getNanos());
        }

        @Override
        public Timestamp from(PlainTimestamp plainTimestamp) {
            Comparable<ZonalOffset> comparable;
            long l2 = MathUtils.safeMultiply(plainTimestamp.getCalendarDate().get(EpochDays.UNIX), 86400000L);
            long l3 = plainTimestamp.getInt(PlainTime.MILLI_OF_DAY);
            if (!WITH_SQL_UTC_CONVERSION) {
                comparable = Timezone.ofSystem().getOffset(plainTimestamp, plainTimestamp);
                l3 -= (long)(((ZonalOffset)comparable).getIntegralAmount() * 1000);
            }
            comparable = new Timestamp(MathUtils.safeAdd(l2, l3));
            ((Timestamp)comparable).setNanos(plainTimestamp.getInt(PlainTime.NANO_OF_SECOND));
            return comparable;
        }

        @Override
        public Class<Timestamp> getSourceType() {
            return Timestamp.class;
        }
    }

    private static class SqlMomentRule
    extends JDBCAdapter<Timestamp, Moment> {
        private SqlMomentRule() {
        }

        @Override
        public Moment translate(Timestamp timestamp) {
            try {
                return Moment.of(MathUtils.floorDivide(timestamp.getTime(), 1000), timestamp.getNanos(), TimeScale.POSIX);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public Timestamp from(Moment moment) {
            Timestamp timestamp = new Timestamp(MathUtils.safeMultiply(moment.getPosixTime(), 1000L));
            timestamp.setNanos(moment.getNanosecond());
            return timestamp;
        }

        @Override
        public Class<Timestamp> getSourceType() {
            return Timestamp.class;
        }
    }
}

