/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;

public enum TimeScale {
    POSIX,
    UTC,
    TAI,
    GPS,
    TT,
    UT;


    public static double deltaT(int n2, int n3) {
        if (n3 < 1 || n3 > 12) {
            throw new IllegalArgumentException("Month out of range: " + n3);
        }
        double d2 = (double)n2 + ((double)n3 - 0.5) / 12.0;
        return TimeScale.deltaT(n2, d2);
    }

    public static double deltaT(GregorianDate gregorianDate) {
        int n2 = gregorianDate.getYear();
        int n3 = GregorianMath.isLeapYear(n2) ? 366 : 365;
        int n4 = 0;
        int n5 = gregorianDate.getMonth();
        for (int i2 = 1; i2 < n5; ++i2) {
            n4 += GregorianMath.getLengthOfMonth(n2, i2);
        }
        if ((n4 += gregorianDate.getDayOfMonth()) > n3) {
            throw new IllegalArgumentException(gregorianDate.toString());
        }
        if (n2 == -2001 && n4 == 365) {
            n2 = -2000;
            n4 = 1;
        }
        double d2 = (double)n2 + ((double)n4 - 1.0) / (double)n3;
        return TimeScale.deltaT(n2, d2);
    }

    private static double deltaT(int n2, double d2) {
        if (n2 < -2000 || n2 > 3000) {
            throw new IllegalArgumentException("Year out of range: " + n2);
        }
        if (n2 > 2050) {
            double d3 = (d2 - 1820.0) / 100.0;
            return -20.0 + 32.0 * d3 * d3;
        }
        if (n2 >= 2018) {
            double d4 = d2 - 2000.0;
            return 64.16 + (0.0533 + 0.012125 * d4) * d4;
        }
        if (n2 >= 2005) {
            double d5 = d2 - 2000.0;
            return 63.5934 + (0.171417 + (0.014201 + (-0.00112745 + 4.2060317E-5 * d5) * d5) * d5) * d5;
        }
        if (n2 >= 1986) {
            double d6 = d2 - 2000.0;
            return 63.86 + (0.3345 + (-0.060374 + (0.0017275 + (6.51814E-4 + 2.373599E-5 * d6) * d6) * d6) * d6) * d6;
        }
        if (n2 >= 1961) {
            double d7 = d2 - 1975.0;
            return 45.45 + (1.067 + (0.0 - d7 / 718.0) * d7) * d7;
        }
        if (n2 >= 1941) {
            double d8 = d2 - 1950.0;
            return 29.07 + (0.407 + (0.0 + d8 / 2547.0) * d8) * d8;
        }
        if (n2 >= 1920) {
            double d9 = d2 - 1920.0;
            return 21.2 + (0.84493 + (-0.0761 + 0.0020936 * d9) * d9) * d9;
        }
        if (n2 >= 1900) {
            double d10 = d2 - 1900.0;
            return -2.79 + (1.494119 + (-0.0598939 + (0.0061966 - 1.97E-4 * d10) * d10) * d10) * d10;
        }
        if (n2 >= 1860) {
            double d11 = d2 - 1860.0;
            return 7.62 + (0.5737 + (-0.251754 + (0.01680668 + (-4.473624E-4 + d11 / 233174.0) * d11) * d11) * d11) * d11;
        }
        if (n2 >= 1800) {
            double d12 = d2 - 1800.0;
            return 13.72 + (-0.332447 + (0.0068612 + (0.0041116 + (-3.7436E-4 + (1.21272E-5 + (-1.699E-7 + 8.75E-10 * d12) * d12) * d12) * d12) * d12) * d12) * d12;
        }
        if (n2 >= 1700) {
            double d13 = d2 - 1700.0;
            return 8.83 + (0.1603 + (-0.0059285 + (1.3336E-4 + d13 / 1174000.0) * d13) * d13) * d13;
        }
        if (n2 >= 1600) {
            double d14 = d2 - 1600.0;
            return 120.0 + (-0.9808 + (-0.01532 + d14 / 7129.0) * d14) * d14;
        }
        if (n2 >= 500) {
            double d15 = (d2 - 1000.0) / 100.0;
            return 1574.2 + (-556.01 + (71.23472 + (0.319781 + (-0.8503463 + (-0.005050998 + 0.0083572073 * d15) * d15) * d15) * d15) * d15) * d15;
        }
        if (n2 >= -500) {
            double d16 = d2 / 100.0;
            return 10583.6 + (-1014.41 + (33.78311 + (-5.952053 + (-0.1798452 + (0.022174192 + 0.0090316521 * d16) * d16) * d16) * d16) * d16) * d16;
        }
        double d17 = (d2 - 1820.0) / 100.0;
        return -20.0 + 32.0 * d17 * d17;
    }
}

