/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;

enum YearParser implements ChronoParser<Integer>
{
    YEAR,
    YEAR_OF_WEEKDATE;


    @Override
    public Integer parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n2;
        Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n3 = 1;
        int n4 = 9;
        if (!leniency.isLax()) {
            n3 = 4;
        }
        int n5 = charSequence.length();
        int n6 = n2 = parseLog.getPosition();
        int n7 = attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n7 > 0) {
            n5 -= n7;
        }
        if (n6 >= n5) {
            parseLog.setError(n2, "Missing digits for: " + this.name());
            parseLog.setWarning();
            return null;
        }
        boolean bl2 = false;
        char c2 = charSequence.charAt(n6);
        if (c2 == '-' || c2 == '+') {
            bl2 = c2 == '-';
            ++n6;
            ++n2;
        }
        if (n6 >= n5) {
            parseLog.setError(n2, "Missing digits for: " + this.name());
            return null;
        }
        int n8 = n6 + n3;
        int n9 = Math.min(n5, n6 + n4);
        int n10 = 0;
        boolean bl3 = true;
        while (n6 < n9) {
            int n11 = charSequence.charAt(n6) - 48;
            if (n11 >= 0 && n11 <= 9) {
                n10 = n10 * 10 + n11;
                ++n6;
                bl3 = false;
                continue;
            }
            if (!bl3) break;
            parseLog.setError(n2, "Digit expected.");
            return null;
        }
        if (n6 < n8 && (bl3 || !leniency.isLax())) {
            parseLog.setError(n2, "Not enough digits found for " + this.name());
            return null;
        }
        if (bl2) {
            if (n10 == 0 && leniency.isStrict()) {
                parseLog.setError(n2 - 1, "Negative zero is not allowed.");
                return null;
            }
            n10 = -n10;
        } else if (leniency.isStrict()) {
            if (c2 == '+' && n6 <= n8) {
                parseLog.setError(n2 - 1, "Positive sign only allowed for big number.");
                return null;
            }
            if (c2 != '+' && n6 > n8) {
                parseLog.setError(n2, "Positive sign must be present for big number.");
                return null;
            }
        }
        if (n6 >= n5) {
            parseLog.setError(n6, "Missing literal '-' after: " + this.name());
            return null;
        }
        if (charSequence.charAt(n6) != '-') {
            parseLog.setError(n6, "Literal '-' expected after: " + this.name());
            return null;
        }
        parseLog.setPosition(++n6);
        return n10;
    }
}

