/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.engine.Temporal;
import net.time4j.range.ClockInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.TimestampInterval;

public enum IntervalRelation {
    PRECEDES,
    MEETS,
    OVERLAPS,
    FINISHES,
    STARTS,
    ENCLOSES,
    EQUIVALENT,
    ENCLOSED_BY,
    STARTED_BY,
    FINISHED_BY,
    OVERLAPPED_BY,
    MET_BY,
    PRECEDED_BY;

    private static final IntervalRelation[] VALUES;
    private static final IntervalRelation[] A_AFTER_B;
    private static final IntervalRelation[] EQUAL_START;
    private static final IntervalRelation[] A_BEFORE_B;

    public IntervalRelation inverse() {
        return VALUES[12 - this.ordinal()];
    }

    public boolean matches(DateInterval dateInterval, DateInterval dateInterval2) {
        return this.matches0(dateInterval, dateInterval2);
    }

    public boolean matches(ClockInterval clockInterval, ClockInterval clockInterval2) {
        return this.matches0(clockInterval, clockInterval2);
    }

    public boolean matches(TimestampInterval timestampInterval, TimestampInterval timestampInterval2) {
        return this.matches0(timestampInterval, timestampInterval2);
    }

    public boolean matches(MomentInterval momentInterval, MomentInterval momentInterval2) {
        return this.matches0(momentInterval, momentInterval2);
    }

    public static IntervalRelation between(DateInterval dateInterval, DateInterval dateInterval2) {
        return IntervalRelation.between0(dateInterval, dateInterval2);
    }

    public static IntervalRelation between(ClockInterval clockInterval, ClockInterval clockInterval2) {
        return IntervalRelation.between0(clockInterval, clockInterval2);
    }

    public static IntervalRelation between(TimestampInterval timestampInterval, TimestampInterval timestampInterval2) {
        return IntervalRelation.between0(timestampInterval, timestampInterval2);
    }

    public static IntervalRelation between(MomentInterval momentInterval, MomentInterval momentInterval2) {
        return IntervalRelation.between0(momentInterval, momentInterval2);
    }

    private <T extends Temporal<? super T>, I extends IsoInterval<T, I>> boolean matches0(I i2, I i3) {
        switch (this) {
            case PRECEDES: {
                return i2.precedes(i3);
            }
            case MEETS: {
                return i2.meets(i3);
            }
            case OVERLAPS: {
                return i2.overlaps(i3);
            }
            case FINISHES: {
                return i2.finishes(i3);
            }
            case STARTS: {
                return i2.starts(i3);
            }
            case ENCLOSES: {
                return i2.encloses(i3);
            }
            case EQUIVALENT: {
                return i2.equivalentTo(i3);
            }
            case ENCLOSED_BY: {
                return i2.enclosedBy(i3);
            }
            case STARTED_BY: {
                return i2.startedBy(i3);
            }
            case FINISHED_BY: {
                return i2.finishedBy(i3);
            }
            case OVERLAPPED_BY: {
                return i2.overlappedBy(i3);
            }
            case MET_BY: {
                return i2.metBy(i3);
            }
            case PRECEDED_BY: {
                return i2.precededBy(i3);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalRelation between0(I i2, I i3) {
        Temporal temporal = (Temporal)i2.getStart().getTemporal();
        Temporal temporal2 = (Temporal)i3.getStart().getTemporal();
        IntervalRelation[] intervalRelationArray = temporal != null && temporal2 != null ? (temporal.isAfter(temporal2) ? A_AFTER_B : (temporal.isSimultaneous(temporal2) ? EQUAL_START : A_BEFORE_B)) : (temporal == null && temporal2 == null ? EQUAL_START : (temporal == null && temporal2 != null ? A_BEFORE_B : A_AFTER_B));
        for (IntervalRelation intervalRelation : intervalRelationArray) {
            if (!intervalRelation.matches0(i2, i3)) continue;
            return intervalRelation;
        }
        throw new IllegalStateException("Cannot determine relation between: " + i2 + " and " + i3);
    }

    static {
        VALUES = IntervalRelation.values();
        A_AFTER_B = new IntervalRelation[]{ENCLOSED_BY, FINISHES, OVERLAPPED_BY, MET_BY, PRECEDED_BY};
        EQUAL_START = new IntervalRelation[]{STARTS, EQUIVALENT, STARTED_BY};
        A_BEFORE_B = new IntervalRelation[]{PRECEDES, MEETS, OVERLAPS, FINISHED_BY, ENCLOSES};
    }
}

