/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalCreator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IsoInterval;

class IntervalParser<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoParser<I> {
    private final IntervalFactory<T, I> factory;
    private final ChronoParser<T> startFormat;
    private final ChronoParser<T> endFormat;
    private final BracketPolicy policy;
    private final Character separator;

    IntervalParser(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, Character c2) {
        if (bracketPolicy == null) {
            throw new NullPointerException("Missing bracket policy.");
        }
        this.factory = intervalFactory;
        this.startFormat = chronoParser;
        this.endFormat = chronoParser2;
        this.policy = bracketPolicy;
        this.separator = c2;
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, BracketPolicy bracketPolicy) {
        if (chronoParser == null) {
            throw new NullPointerException("Missing boundary parser.");
        }
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser, bracketPolicy, null);
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, char c2) {
        if (chronoParser == null) {
            throw new NullPointerException("Missing start boundary parser.");
        }
        if (chronoParser2 == null) {
            throw new NullPointerException("Missing end boundary parser.");
        }
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser2, bracketPolicy, Character.valueOf(c2));
    }

    I parse(String string) throws ParseException {
        ParseLog parseLog = new ParseLog();
        AttributeQuery attributeQuery = this.startFormat.getAttributes();
        Object object = this.parse(string, parseLog, attributeQuery);
        int n2 = parseLog.getPosition();
        int n3 = string.length();
        if (object == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (n2 < n3 && !attributeQuery.get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            String string2 = n3 - n2 <= 10 ? string.subSequence(n2, n3).toString() : string.subSequence(n2, n2 + 10).toString() + "...";
            throw new ParseException("Unparsed trailing characters: " + string2, n2);
        }
        return (I)object;
    }

    @Override
    public I parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n2;
        int n3;
        int n4;
        int n5 = parseLog.getPosition();
        int n6 = n5;
        if (n6 >= (n4 = charSequence.length())) {
            throw new IndexOutOfBoundsException("[" + n6 + "]: " + charSequence.toString());
        }
        IntervalEdge intervalEdge = IntervalEdge.CLOSED;
        IntervalEdge intervalEdge2 = this.factory.isCalendrical() ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        Temporal temporal = null;
        Temporal temporal2 = null;
        Boundary<Object> boundary = null;
        Boundary<Object> boundary2 = null;
        int n7 = -1;
        int n8 = -1;
        ParseLog parseLog2 = null;
        ParseLog parseLog3 = null;
        String string = null;
        int n9 = 0;
        char c2 = charSequence.charAt(n6);
        boolean bl2 = c2 == '[' || c2 == '(';
        boolean bl3 = false;
        if (bl2) {
            if (this.policy == BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n6, "Illegal start boundary due to bracket policy " + (Object)((Object)this.policy) + ": " + c2);
            } else if (c2 == '(') {
                intervalEdge = IntervalEdge.OPEN;
            }
            ++n6;
        } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
            parseLog.setError(n6, "Missing start boundary bracket.");
        }
        if (parseLog.isError()) {
            return null;
        }
        if (n6 >= n4) {
            parseLog.setError(n6, "Missing interval start component, end of text reached.");
            return null;
        }
        c2 = charSequence.charAt(n6);
        if (c2 == 'P') {
            n7 = n6;
            n3 = n6;
            n2 = -1;
            while (++n3 < n4) {
                if (charSequence.charAt(n3) != '/') continue;
                n2 = n3;
                break;
            }
            if (n2 == -1) {
                parseLog.setError(n6, "Solidus char separating start and end boundaries expected.");
                return null;
            }
            string = charSequence.subSequence(n6, n2).toString();
            n6 = n2 + 1;
        } else if (c2 == '-' && n6 + 1 < n4 && this.isExpectedSeparator(charSequence.charAt(n6 + 1))) {
            if (intervalEdge == IntervalEdge.CLOSED && bl2) {
                parseLog.setError(n6 - 1, "Open boundary expected.");
                return null;
            }
            intervalEdge = IntervalEdge.OPEN;
            boundary = Boundary.infinitePast();
            n9 = 1;
            n6 += 2;
        } else if (c2 == '-' && n6 + 1 < n4 && charSequence.charAt(n6 + 1) == '\u221e') {
            if (intervalEdge == IntervalEdge.CLOSED && bl2) {
                parseLog.setError(n6 - 1, "Open boundary expected.");
                return null;
            }
            intervalEdge = IntervalEdge.OPEN;
            boundary = Boundary.infinitePast();
            this.checkSeparatorChar(charSequence, parseLog, n6 += 2, n4);
            if (parseLog.isError()) {
                return null;
            }
            n9 = 2;
            ++n6;
        } else {
            parseLog2 = new ParseLog(n6);
            temporal = (Temporal)this.startFormat.parse(charSequence, parseLog2, attributeQuery);
            if (temporal == null || parseLog2.isError()) {
                parseLog.setError(n6, parseLog2.getErrorMessage());
                return null;
            }
            boundary = Boundary.of(intervalEdge, temporal);
            n6 = parseLog2.getPosition();
            this.checkSeparatorChar(charSequence, parseLog, n6, n4);
            if (parseLog.isError()) {
                return null;
            }
            ++n6;
        }
        if (n6 >= n4) {
            parseLog.setError(n6, "Missing interval end component, end of text reached.");
            return null;
        }
        c2 = charSequence.charAt(n6);
        if (c2 == 'P') {
            if (temporal == null) {
                parseLog.setError(n6, "Cannot process end period without start time.");
                return null;
            }
            n8 = n6;
            n3 = n4;
            n2 = charSequence.charAt(n3 - 1);
            if (n2 == 93 || n2 == 41) {
                --n3;
            }
            string = charSequence.subSequence(n6, n3).toString();
            n6 = n3;
        } else if (c2 == '-' && (n6 + 1 >= n4 || charSequence.charAt(n6 + 1) == ')')) {
            if (n9 == 2) {
                parseLog.setError(n6, "Mixed infinity symbols not allowed.");
                return null;
            }
            intervalEdge2 = IntervalEdge.OPEN;
            boundary2 = Boundary.infiniteFuture();
            n9 = 1;
            ++n6;
        } else if (c2 == '+' && n6 + 1 < n4 && charSequence.charAt(n6 + 1) == '\u221e') {
            if (n6 + 2 < n4 && charSequence.charAt(n6 + 2) == ']' && this.policy != BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n6 + 2, "Open boundary expected.");
                return null;
            }
            if (n9 == 1) {
                parseLog.setError(n6, "Mixed infinity symbols not allowed.");
                return null;
            }
            intervalEdge2 = IntervalEdge.OPEN;
            boundary2 = Boundary.infiniteFuture();
            n9 = 2;
            n6 += 2;
        } else {
            parseLog3 = new ParseLog(n6);
            temporal2 = parseLog2 == null ? (Temporal)this.startFormat.parse(charSequence, parseLog3, attributeQuery) : (this.endFormat == null ? this.parseReducedEnd(charSequence, temporal, parseLog2, parseLog3, attributeQuery) : (Temporal)this.endFormat.parse(charSequence, parseLog3, attributeQuery));
            if (temporal2 == null || parseLog3.isError()) {
                parseLog.setError(n6, parseLog3.getErrorMessage());
                return null;
            }
            boundary2 = Boundary.of(intervalEdge2, temporal2);
            n6 = parseLog3.getPosition();
        }
        if (n6 >= n4) {
            if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n6, "Missing end boundary bracket.");
            }
        } else {
            c2 = charSequence.charAt(n6);
            if (c2 == ']' || c2 == ')') {
                if (this.policy == BracketPolicy.SHOW_NEVER) {
                    parseLog.setError(n6, "Illegal end boundary due to bracket policy " + (Object)((Object)this.policy) + ": " + c2);
                } else {
                    bl3 = true;
                    IntervalEdge intervalEdge3 = intervalEdge2 = c2 == ']' ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
                    if (temporal2 != null) {
                        boundary2 = Boundary.of(intervalEdge2, temporal2);
                    }
                    ++n6;
                }
            } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n6, "Missing end boundary bracket.");
            }
        }
        if (parseLog.isError()) {
            return null;
        }
        if (string != null) {
            IntervalFactory<Temporal, I> intervalFactory = this.factory;
            if (boundary == null) {
                if (temporal2 == null) {
                    parseLog.setError(n7, "Cannot process start period without end time.");
                    return null;
                }
                temporal = intervalFactory.minusPeriod(temporal2, string, parseLog3, attributeQuery);
                if (temporal == null) {
                    parseLog.setError(n7, "Wrong period: " + string);
                    return null;
                }
                boundary = Boundary.of(intervalEdge, temporal);
            }
            if (boundary2 == null) {
                temporal2 = intervalFactory.plusPeriod(temporal, string, parseLog2, attributeQuery);
                if (temporal2 == null) {
                    parseLog.setError(n8, "Wrong period: " + string);
                    return null;
                }
                boundary2 = Boundary.of(intervalEdge2, temporal2);
            }
        }
        if (n9 == 0 && this.factory.supportsInfinity()) {
            boundary = this.resolveInfinity(bl2, boundary);
            boundary2 = this.resolveInfinity(bl3, boundary2);
        }
        try {
            IsoInterval isoInterval = (IsoInterval)this.factory.between(boundary, boundary2);
            if (this.policy == BracketPolicy.SHOW_WHEN_NON_STANDARD) {
                n2 = this.policy.display(isoInterval) ? 1 : 0;
                if (!(n2 == 0 || bl2 && bl3)) {
                    int n10 = !bl3 ? n6 : n5;
                    parseLog.setError(n10, "Missing boundary.");
                    return null;
                }
                if (n2 == 0 && (bl2 || bl3)) {
                    int n11 = bl3 ? n6 : n5;
                    parseLog.setError(n11, "Standard boundary not allowed due to bracket policy: " + (Object)((Object)this.policy));
                    return null;
                }
            }
            parseLog.setPosition(n6);
            return (I)isoInterval;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parseLog.setError(n6, illegalArgumentException.getMessage());
            return null;
        }
    }

    static <T, I extends ChronoInterval<T>> I parsePattern(CharSequence charSequence, IntervalCreator<T, I> intervalCreator, ChronoParser<T> chronoParser, String string) throws ParseException {
        String[] stringArray;
        ParseLog parseLog = new ParseLog();
        for (String string2 : stringArray = string.split("\\|")) {
            parseLog.reset();
            I i2 = IntervalParser.parseComponent(charSequence, intervalCreator, chronoParser, string2, parseLog);
            if (i2 == null || parseLog.isError()) continue;
            return i2;
        }
        if (parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        throw new ParseException("Parsing of interval failed: " + charSequence, parseLog.getPosition());
    }

    private static <T, I extends ChronoInterval<T>> I parseComponent(CharSequence charSequence, IntervalCreator<T, I> intervalCreator, ChronoParser<T> chronoParser, String string, ParseLog parseLog) {
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        Object t2 = null;
        Object t3 = null;
        int n4 = 0;
        int n5 = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        AttributeQuery attributeQuery = chronoParser.getAttributes();
        while (n4 < n5) {
            char c2 = string.charAt(n4);
            if (c2 == '{' && n4 + 2 < n5 && string.charAt(n4 + 2) == '}') {
                char c3 = string.charAt(n4 + 1);
                if (c3 == '0') {
                    if (bl2) {
                        parseLog.setError(n2, "Cannot parse start component more than once.");
                        return null;
                    }
                    parseLog.setPosition(n2);
                    if (n2 + 1 < n3 && charSequence.charAt(n2) == '-' && charSequence.charAt(n2 + 1) == '\u221e') {
                        n2 += 2;
                    } else {
                        t2 = chronoParser.parse(charSequence, parseLog, attributeQuery);
                        if (t2 == null || parseLog.isError()) {
                            return null;
                        }
                        n2 = parseLog.getPosition();
                    }
                    bl2 = true;
                    n4 += 3;
                    continue;
                }
                if (c3 == '1') {
                    if (bl3) {
                        parseLog.setError(n2, "Cannot parse end component more than once.");
                        return null;
                    }
                    parseLog.setPosition(n2);
                    if (n2 + 1 < n3 && charSequence.charAt(n2) == '+' && charSequence.charAt(n2 + 1) == '\u221e') {
                        n2 += 2;
                    } else {
                        t3 = chronoParser.parse(charSequence, parseLog, attributeQuery);
                        if (t3 == null || parseLog.isError()) {
                            return null;
                        }
                        n2 = parseLog.getPosition();
                    }
                    bl3 = true;
                    n4 += 3;
                    continue;
                }
            } else if (c2 == '[' || c2 == ']' || c2 == '(' || c2 == ')') {
                parseLog.setError(n2, "Brackets representing interval boundaries cannot be parsed: " + charSequence);
                return null;
            }
            if (n2 >= n3) {
                parseLog.setError(n2, "End of text reached.");
                return null;
            }
            if (c2 != charSequence.charAt(n2)) {
                parseLog.setError(n2, "Literal mismatched: " + charSequence.toString() + " (expected=" + string + ")");
                return null;
            }
            ++n4;
            ++n2;
        }
        if (n2 < n3 && !attributeQuery.get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            parseLog.setError(n2, "Trailing characters found: " + charSequence);
            return null;
        }
        Boundary<Object> boundary = Boundary.infinitePast();
        Boundary<Object> boundary2 = Boundary.infiniteFuture();
        if (t2 != null) {
            boundary = Boundary.ofClosed(t2);
        }
        if (t3 != null) {
            boundary2 = intervalCreator.isCalendrical() ? Boundary.ofClosed(t3) : Boundary.ofOpen(t3);
        }
        try {
            return intervalCreator.between(boundary, boundary2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parseLog.setError(n2, illegalArgumentException.getMessage());
            return null;
        }
    }

    protected T parseReducedEnd(CharSequence charSequence, T t2, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
        return null;
    }

    private Boundary<T> resolveInfinity(boolean bl2, Boundary<T> boundary) {
        if (!(boundary.isInfinite() || bl2 && !boundary.isOpen())) {
            TimeLine<T> timeLine = this.factory.getTimeLine();
            Temporal temporal = (Temporal)boundary.getTemporal();
            if (temporal.equals(timeLine.getMinimum())) {
                return Boundary.infinitePast();
            }
            if (temporal.equals(timeLine.getMaximum())) {
                return Boundary.infiniteFuture();
            }
        }
        return boundary;
    }

    private void checkSeparatorChar(CharSequence charSequence, ParseLog parseLog, int n2, int n3) {
        if (n2 >= n3) {
            parseLog.setError(n2, "Reached end of text, but not found any separation char.");
            return;
        }
        if (!this.isExpectedSeparator(charSequence.charAt(n2))) {
            parseLog.setError(n2, "Missing or misplaced separation char between start and end boundaries: " + (this.separator == null ? "/ or -" : this.separator.toString()));
        }
    }

    private boolean isExpectedSeparator(char c2) {
        if (this.separator == null) {
            return c2 == '/' || c2 == '-';
        }
        return c2 == this.separator.charValue();
    }
}

