/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.util.Locale;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;
import net.time4j.range.BusinessDayUnit;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateInterval;

@FunctionalInterface
public interface HolidayModel
extends ChronoCondition<PlainDate> {
    @Override
    public boolean test(PlainDate var1);

    default public boolean isBusinessDay(PlainDate plainDate) {
        return !this.test(plainDate);
    }

    public static HolidayModel ofSaturdayOrSunday() {
        return plainDate -> {
            Weekday weekday = plainDate.getDayOfWeek();
            return weekday == Weekday.SATURDAY || weekday == Weekday.SUNDAY;
        };
    }

    public static HolidayModel ofWeekend(Locale locale) {
        return plainDate -> plainDate.matches(Weekmodel.of(locale).weekend());
    }

    default public ChronoOperator<PlainDate> nextBusinessDay() {
        return plainDate -> {
            while (this.test(plainDate = plainDate.plus(1L, CalendarUnit.DAYS))) {
            }
            return plainDate;
        };
    }

    default public ChronoOperator<PlainDate> nextOrSameBusinessDay() {
        return plainDate -> {
            while (this.test((PlainDate)plainDate)) {
                plainDate = plainDate.plus(1L, CalendarUnit.DAYS);
            }
            return plainDate;
        };
    }

    default public ChronoOperator<PlainDate> previousBusinessDay() {
        return plainDate -> {
            while (this.test(plainDate = plainDate.minus(1L, CalendarUnit.DAYS))) {
            }
            return plainDate;
        };
    }

    default public ChronoOperator<PlainDate> previousOrSameBusinessDay() {
        return plainDate -> {
            while (this.test((PlainDate)plainDate)) {
                plainDate = plainDate.minus(1L, CalendarUnit.DAYS);
            }
            return plainDate;
        };
    }

    default public ChronoFunction<ChronoInterval<PlainDate>, PlainDate> firstBusinessDay() {
        return chronoInterval -> {
            if (!chronoInterval.isFinite()) {
                throw new ChronoException("Cannot query infinite intervals.");
            }
            PlainDate plainDate = (PlainDate)chronoInterval.getStart().getTemporal();
            PlainDate plainDate2 = (PlainDate)chronoInterval.getEnd().getTemporal();
            while (this.test(plainDate)) {
                if (!(plainDate = plainDate.plus(1L, CalendarUnit.DAYS)).isAfter(plainDate2)) continue;
                return null;
            }
            return plainDate;
        };
    }

    default public ChronoFunction<ChronoInterval<PlainDate>, PlainDate> lastBusinessDay() {
        return chronoInterval -> {
            if (!chronoInterval.isFinite()) {
                throw new ChronoException("Cannot query infinite intervals.");
            }
            PlainDate plainDate = (PlainDate)chronoInterval.getStart().getTemporal();
            PlainDate plainDate2 = (PlainDate)chronoInterval.getEnd().getTemporal();
            while (this.test(plainDate2)) {
                if (!plainDate.isAfter(plainDate2 = plainDate2.minus(1L, CalendarUnit.DAYS))) continue;
                return null;
            }
            return plainDate2;
        };
    }

    default public ChronoFunction<ChronoInterval<PlainDate>, Integer> countOfBusinessDays() {
        return chronoInterval -> {
            if (!chronoInterval.isFinite()) {
                throw new ChronoException("Cannot query infinite intervals.");
            }
            if (chronoInterval.isEmpty()) {
                return 0;
            }
            DateInterval dateInterval = DateInterval.from(chronoInterval);
            PlainDate plainDate = (PlainDate)dateInterval.getClosedFiniteStart();
            PlainDate plainDate2 = (PlainDate)dateInterval.getClosedFiniteEnd();
            long l2 = 0L;
            while (!plainDate.isAfter(plainDate2)) {
                if (!this.test(plainDate)) {
                    ++l2;
                }
                plainDate = plainDate.plus(1L, CalendarUnit.DAYS);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ArithmeticException("Numerical overflow.");
            }
            return (int)l2;
        };
    }

    default public ChronoFunction<ChronoInterval<PlainDate>, Integer> countOfHolidays() {
        return chronoInterval -> {
            if (!chronoInterval.isFinite()) {
                throw new ChronoException("Cannot query infinite intervals.");
            }
            if (chronoInterval.isEmpty()) {
                return 0;
            }
            DateInterval dateInterval = DateInterval.from(chronoInterval);
            PlainDate plainDate = (PlainDate)dateInterval.getClosedFiniteStart();
            PlainDate plainDate2 = (PlainDate)dateInterval.getClosedFiniteEnd();
            long l2 = 0L;
            while (!plainDate.isAfter(plainDate2)) {
                if (this.test(plainDate)) {
                    ++l2;
                }
                plainDate = plainDate.plus(1L, CalendarUnit.DAYS);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ArithmeticException("Numerical overflow.");
            }
            return (int)l2;
        };
    }

    default public ChronoCondition<PlainDate> firstBusinessDayInMonth() {
        return plainDate -> !this.test((PlainDate)plainDate) && plainDate.with(this.previousBusinessDay()).getMonth() != plainDate.getMonth();
    }

    default public ChronoCondition<PlainDate> lastBusinessDayInMonth() {
        return plainDate -> !this.test((PlainDate)plainDate) && plainDate.with(this.nextBusinessDay()).getMonth() != plainDate.getMonth();
    }

    default public IsoDateUnit businessDays() {
        return new BusinessDayUnit(this);
    }
}

