/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class TwoDigitYearProcessor
implements FormatProcessor<Integer> {
    private final ChronoElement<Integer> element;
    private final boolean protectedMode;
    private final int reserved;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final int protectedLength;
    private final int pivotYear;

    TwoDigitYearProcessor(ChronoElement<Integer> chronoElement, boolean bl2) {
        if (!chronoElement.name().startsWith("YEAR")) {
            throw new IllegalArgumentException("Year element required: " + chronoElement);
        }
        this.element = chronoElement;
        this.protectedMode = bl2;
        this.reserved = 0;
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.protectedLength = 0;
        this.pivotYear = 100;
    }

    private TwoDigitYearProcessor(ChronoElement<Integer> chronoElement, boolean bl2, int n2, char c2, Leniency leniency, int n3, int n4) {
        this.element = chronoElement;
        this.protectedMode = bl2;
        this.reserved = n2;
        this.zeroDigit = c2;
        this.lenientMode = leniency;
        this.protectedLength = n3;
        this.pivotYear = n4;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        int n2;
        char c2;
        int n3 = chronoDisplay.getInt(this.element);
        if (n3 < 0) {
            if (n3 == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Format context has no year: " + chronoDisplay);
            }
            throw new IllegalArgumentException("Negative year cannot be printed as two-digit-year: " + n3);
        }
        int n4 = this.getPivotYear(bl2, attributeQuery) == 100 ? n3 : MathUtils.floorModulo(n3, 100);
        String string = Integer.toString(n4);
        char c3 = c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        if (c2 != '0') {
            n2 = c2 - 48;
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = (char)(cArray[i2] + n2);
            }
            string = new String(cArray);
        }
        n2 = -1;
        int n5 = 0;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        if (n4 < 10) {
            appendable.append(c2);
            ++n5;
        }
        appendable.append(string);
        if (n2 != -1 && (n5 += string.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n2, n2 + n5));
        }
        return n5;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        char c2;
        int n7;
        int n8 = charSequence.length();
        int n9 = parseLog.getPosition();
        int n10 = n7 = bl2 ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n7 > 0) {
            n8 -= n7;
        }
        if (n9 >= n8) {
            parseLog.setError(n9, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        Leniency leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n11 = leniency.isStrict() ? 2 : 9;
        char c3 = c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        if (this.reserved > 0 && n7 <= 0) {
            n6 = 0;
            for (n5 = n9; n5 < n8 && (n4 = charSequence.charAt(n5) - c2) >= 0 && n4 <= 9; ++n5) {
                ++n6;
            }
            n11 = Math.min(n11, n6 - this.reserved);
        }
        n6 = n9 + 2;
        n5 = Math.min(n8, n9 + n11);
        n4 = 0;
        boolean bl3 = true;
        for (n3 = n9; n3 < n5; ++n3) {
            n2 = charSequence.charAt(n3) - c2;
            if (n2 >= 0 && n2 <= 9) {
                n4 = n4 * 10 + n2;
                bl3 = false;
                continue;
            }
            if (!bl3) break;
            parseLog.setError(n9, "Digit expected.");
            return;
        }
        if (n3 < n6) {
            parseLog.setError(n9, "Not enough digits found for: " + this.element.name());
            return;
        }
        if (n3 == n9 + 2) {
            assert (n4 >= 0 && n4 <= 99);
            n2 = TwoDigitYearProcessor.toYear(n4, this.getPivotYear(bl2, attributeQuery));
        } else {
            n2 = n4;
        }
        parsedEntity.put(this.element, n2);
        parseLog.setPosition(n3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TwoDigitYearProcessor) {
            TwoDigitYearProcessor twoDigitYearProcessor = (TwoDigitYearProcessor)object;
            return this.element.equals(twoDigitYearProcessor.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        return new TwoDigitYearProcessor(chronoElement, false);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<Integer> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new TwoDigitYearProcessor(this.element, this.protectedMode, n2, attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0), attributeQuery.get(Attributes.PIVOT_YEAR, chronoFormatter.getChronology().getDefaultPivotYear()));
    }

    private static int toYear(int n2, int n3) {
        int n4 = n2 >= n3 % 100 ? (n3 / 100 - 1) * 100 : n3 / 100 * 100;
        return n4 + n2;
    }

    private int getPivotYear(boolean bl2, AttributeQuery attributeQuery) {
        int n2;
        int n3 = n2 = bl2 ? this.pivotYear : attributeQuery.get(Attributes.PIVOT_YEAR, this.pivotYear);
        if (n2 < 100) {
            throw new IllegalArgumentException("Pivot year must not be smaller than 100: " + n2);
        }
        return n2;
    }
}

