/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Iterator;
import java.util.Set;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.TZID;

abstract class ParsedEntity<T extends ParsedEntity<T>>
extends ChronoEntity<T> {
    ParsedEntity() {
    }

    @Override
    public <V> boolean isValid(ChronoElement<V> chronoElement, V v2) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return true;
    }

    @Override
    public <V> T with(ChronoElement<V> chronoElement, V v2) {
        this.put(chronoElement, v2);
        return (T)this;
    }

    @Override
    public T with(ChronoElement<Integer> chronoElement, int n2) {
        this.put(chronoElement, n2);
        return (T)this;
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return chronoElement.getDefaultMinimum();
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return chronoElement.getDefaultMaximum();
    }

    @Override
    public final boolean hasTimezone() {
        return this.contains(TimezoneElement.TIMEZONE_ID) || this.contains(TimezoneElement.TIMEZONE_OFFSET);
    }

    @Override
    public final TZID getTimezone() {
        TZID tZID = null;
        if (this.contains(TimezoneElement.TIMEZONE_ID)) {
            tZID = this.get(TimezoneElement.TIMEZONE_ID);
        } else if (this.contains(TimezoneElement.TIMEZONE_OFFSET)) {
            tZID = this.get(TimezoneElement.TIMEZONE_OFFSET);
        }
        if (tZID instanceof TZID) {
            return (TZID)TZID.class.cast(tZID);
        }
        return super.getTimezone();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ParsedEntity) {
            ChronoElement<Object> chronoElement2;
            ParsedEntity parsedEntity = (ParsedEntity)object;
            Set<ChronoElement<?>> set = this.getRegisteredElements();
            Set<ChronoElement<?>> set2 = parsedEntity.getRegisteredElements();
            if (set.size() != set2.size()) {
                return false;
            }
            for (ChronoElement<Object> chronoElement2 : set) {
                if (set2.contains(chronoElement2) && this.get(chronoElement2).equals(parsedEntity.get(chronoElement2))) continue;
                return false;
            }
            Iterator<ChronoElement<Object>> iterator = this.getResult();
            chronoElement2 = parsedEntity.getResult();
            if (iterator == null) {
                return chronoElement2 == null;
            }
            return iterator.equals(chronoElement2);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = this.getRegisteredElements().hashCode();
        Object e2 = this.getResult();
        if (e2 != null) {
            n2 += 31 * e2.hashCode();
        }
        return n2;
    }

    public String toString() {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('{');
        for (ChronoElement<?> chronoElement : this.getRegisteredElements()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(this.get(chronoElement));
        }
        stringBuilder.append('}');
        Iterator<ChronoElement<Object>> iterator = this.getResult();
        if (iterator != null) {
            stringBuilder.append(">>>result=");
            stringBuilder.append(iterator);
        }
        return stringBuilder.toString();
    }

    @Override
    protected final Chronology<T> getChronology() {
        throw new UnsupportedOperationException("Parsed values do not have any chronology.");
    }

    abstract void put(ChronoElement<?> var1, int var2);

    abstract void put(ChronoElement<?> var1, Object var2);

    abstract void setResult(Object var1);

    abstract <E> E getResult();
}

