/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class OrdinalProcessor
implements FormatProcessor<Integer> {
    private static final Map<PluralCategory, String> ENGLISH_ORDINALS;
    private final ChronoElement<Integer> element;
    private final Map<PluralCategory, String> indicators;
    private final int reserved;
    private final int protectedLength;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final Locale locale;

    OrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = chronoElement;
        if (map == null) {
            this.indicators = null;
        } else {
            this.indicators = Collections.unmodifiableMap(new EnumMap<PluralCategory, String>(map));
            if (!this.indicators.containsKey((Object)PluralCategory.OTHER)) {
                throw new IllegalArgumentException("Missing plural category OTHER: " + map);
            }
        }
        this.reserved = 0;
        this.protectedLength = 0;
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    private OrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map, int n2, int n3, char c2, Leniency leniency, Locale locale) {
        this.element = chronoElement;
        this.indicators = map;
        this.reserved = n2;
        this.protectedLength = n3;
        this.zeroDigit = c2;
        this.lenientMode = leniency;
        this.locale = locale;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        int n2;
        char c2;
        int n3 = chronoDisplay.getInt(this.element);
        if (n3 < 0) {
            if (n3 == Integer.MIN_VALUE) {
                return -1;
            }
            throw new IllegalArgumentException("Cannot format negative ordinal numbers: " + chronoDisplay);
        }
        String string = Integer.toString(n3);
        char c3 = c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        if (c2 != '0') {
            n2 = c2 - 48;
            char[] cArray = string.toCharArray();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = (char)(cArray[i2] + n2);
            }
            string = new String(cArray);
        }
        n2 = -1;
        int n4 = 0;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        n4 += string.length();
        String string2 = this.getIndicator(attributeQuery, bl2, n3);
        appendable.append(string2);
        if (n2 != -1 && (n4 += string2.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n2, n2 + n4));
        }
        return n4;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        int n3;
        int n4;
        char c2;
        int n5;
        int n6;
        int n7 = 1;
        int n8 = 9;
        int n9 = charSequence.length();
        int n10 = n6 = parseLog.getPosition();
        Leniency leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n11 = n5 = bl2 ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n5 > 0) {
            n9 -= n5;
        }
        if (n10 >= n9) {
            parseLog.setError(n10, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        char c3 = c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        if (this.reserved > 0 && n5 <= 0) {
            int n12;
            n4 = 0;
            for (n3 = n10; n3 < n9 && (n12 = charSequence.charAt(n3) - c2) >= 0 && n12 <= 9; ++n3) {
                ++n4;
            }
            n8 = Math.min(n8, n4 - this.reserved);
        }
        n4 = n10 + n7;
        n3 = Math.min(n9, n10 + n8);
        long l2 = 0L;
        boolean bl3 = true;
        while (n10 < n3) {
            n2 = charSequence.charAt(n10) - c2;
            if (n2 >= 0 && n2 <= 9) {
                l2 = l2 * 10L + (long)n2;
                ++n10;
                bl3 = false;
                continue;
            }
            if (!bl3) break;
            parseLog.setError(n6, "Digit expected.");
            return;
        }
        if (n10 < n4) {
            parseLog.setError(n6, "Not enough digits found for: " + this.element.name());
            return;
        }
        n2 = (int)l2;
        String string = this.getIndicator(attributeQuery, bl2, n2);
        int n13 = n10 + string.length();
        if (n13 >= n9) {
            parseLog.setError(n10, "Missing or wrong ordinal indicator for: " + this.element.name());
            return;
        }
        String string2 = charSequence.subSequence(n10, n13).toString();
        if (string2.equals(string)) {
            n10 = n13;
        } else if (!leniency.isLax()) {
            parseLog.setError(n10, "Wrong ordinal indicator for: " + this.element.name() + " (expected=" + string + ", found=" + string2 + ")");
            return;
        }
        parsedEntity.put(this.element, n2);
        parseLog.setPosition(n10);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OrdinalProcessor) {
            OrdinalProcessor ordinalProcessor = (OrdinalProcessor)object;
            return this.element.equals(ordinalProcessor.element) && this.getIndicators().equals(ordinalProcessor.getIndicators());
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.getIndicators().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", indicators=");
        stringBuilder.append(this.getIndicators());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String getIndicator(AttributeQuery attributeQuery, boolean bl2, int n2) {
        Locale locale = this.isEnglish() ? Locale.ENGLISH : (bl2 ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        PluralCategory pluralCategory = PluralRules.of(locale, NumberType.ORDINALS).getCategory(n2);
        if (!this.getIndicators().containsKey((Object)pluralCategory)) {
            pluralCategory = PluralCategory.OTHER;
        }
        return this.getIndicators().get((Object)pluralCategory);
    }

    private boolean isEnglish() {
        return this.indicators == null;
    }

    private Map<PluralCategory, String> getIndicators() {
        if (this.isEnglish()) {
            return ENGLISH_ORDINALS;
        }
        return this.indicators;
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new OrdinalProcessor(chronoElement, this.indicators);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<Integer> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new OrdinalProcessor(this.element, this.indicators, n2, attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0), attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
    }

    static {
        EnumMap<PluralCategory, String> enumMap = new EnumMap<PluralCategory, String>(PluralCategory.class);
        enumMap.put(PluralCategory.ONE, "st");
        enumMap.put(PluralCategory.TWO, "nd");
        enumMap.put(PluralCategory.FEW, "rd");
        enumMap.put(PluralCategory.OTHER, "th");
        ENGLISH_ORDINALS = Collections.unmodifiableMap(enumMap);
    }
}

