/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumericalElement;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.internal.DualFormatElement;

class NumberProcessor<V>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final boolean fixedWidth;
    private final int minDigits;
    private final int maxDigits;
    private final SignPolicy signPolicy;
    private final boolean protectedMode;
    private final boolean yearOfEra;
    private final Leniency lenientMode;
    private final int reserved;
    private final char zeroDigit;
    private final NumberSystem numberSystem;
    private final int protectedLength;
    private final int scaleOfNumsys;
    private final boolean fixedInt;
    private static final int[] THRESHOLDS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    NumberProcessor(ChronoElement<V> chronoElement, boolean bl2, int n2, int n3, SignPolicy signPolicy, boolean bl3) {
        this(chronoElement, bl2, n2, n3, signPolicy, bl3, 0, '0', NumberSystem.ARABIC, Leniency.SMART, 0, false);
    }

    private NumberProcessor(ChronoElement<V> chronoElement, boolean bl2, int n2, int n3, SignPolicy signPolicy, boolean bl3, int n4, char c2, NumberSystem numberSystem, Leniency leniency, int n5, boolean bl4) {
        this.element = chronoElement;
        this.fixedWidth = bl2;
        this.minDigits = n2;
        this.maxDigits = n3;
        this.signPolicy = signPolicy;
        this.protectedMode = bl3;
        this.fixedInt = bl4;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (signPolicy == null) {
            throw new NullPointerException("Missing sign policy.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Not positive: " + n2);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Max smaller than min: " + n3 + " < " + n2);
        }
        if (bl2 && n2 != n3) {
            throw new IllegalArgumentException("Variable width in fixed-width-mode: " + n3 + " != " + n2);
        }
        if (bl2 && signPolicy != SignPolicy.SHOW_NEVER) {
            throw new IllegalArgumentException("Sign policy must be SHOW_NEVER in fixed-width-mode.");
        }
        int n6 = this.getScale(numberSystem);
        if (numberSystem.isDecimal()) {
            if (n2 > n6) {
                throw new IllegalArgumentException("Min digits out of range: " + n2);
            }
            if (n3 > n6) {
                throw new IllegalArgumentException("Max digits out of range: " + n3);
            }
        }
        this.yearOfEra = this.element.name().equals("YEAR_OF_ERA");
        this.reserved = n4;
        this.zeroDigit = c2;
        this.numberSystem = numberSystem;
        this.lenientMode = leniency;
        this.protectedLength = n5;
        this.scaleOfNumsys = n6;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        char c2;
        NumberSystem numberSystem;
        int n2 = appendable instanceof CharSequence ? ((CharSequence)((Object)appendable)).length() : -1;
        int n3 = 0;
        if (bl2) {
            numberSystem = this.numberSystem;
            c2 = this.zeroDigit;
        } else {
            numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            char c3 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (c2 = numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        }
        if (bl2 && this.fixedInt) {
            int n4 = chronoDisplay.getInt(this.element);
            if (n4 < 0) {
                if (n4 == Integer.MIN_VALUE) {
                    return -1;
                }
                throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
            }
            int n5 = NumberProcessor.length(n4);
            if (n5 > this.maxDigits) {
                throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the formatted value " + n4 + " exceeds the maximum width of " + this.maxDigits + ".");
            }
            int n6 = this.minDigits - n5;
            for (int i2 = 0; i2 < n6; ++i2) {
                appendable.append('0');
                ++n3;
            }
            if (n5 == 2) {
                NumberProcessor.appendTwoDigits(n4, appendable, '0');
            } else if (n5 == 1) {
                appendable.append((char)(n4 + 48));
            } else if (n4 >= 2000 && n4 < 2100) {
                appendable.append('2');
                appendable.append('0');
                NumberProcessor.appendTwoDigits(n4 - 2000, appendable, '0');
            } else if (n4 >= 1900 && n4 < 2000) {
                appendable.append('1');
                appendable.append('9');
                NumberProcessor.appendTwoDigits(n4 - 1900, appendable, '0');
            } else {
                appendable.append(Integer.toString(n4));
            }
            n3 += n5;
        } else if (this.yearOfEra && this.element instanceof DualFormatElement) {
            DualFormatElement dualFormatElement = (DualFormatElement)DualFormatElement.class.cast(this.element);
            StringBuilder stringBuilder = new StringBuilder();
            dualFormatElement.print(chronoDisplay, stringBuilder, attributeQuery, numberSystem, c2, this.minDigits, this.maxDigits);
            appendable.append(stringBuilder.toString());
            n3 = stringBuilder.length();
        } else {
            int n7;
            int n8;
            int n9;
            char c4 = numberSystem.getDigits().charAt(0);
            Class<V> clazz = this.element.getType();
            boolean bl3 = false;
            String string = null;
            if (clazz == Integer.class) {
                n9 = chronoDisplay.getInt(this.element);
                if (n9 == Integer.MIN_VALUE) {
                    return -1;
                }
                bl3 = n9 < 0;
                n8 = Math.abs(n9);
                n7 = NumberProcessor.length(n8);
            } else if (clazz == Long.class) {
                V v2 = chronoDisplay.get(this.element);
                long l2 = (Long)Long.class.cast(v2);
                bl3 = l2 < 0L;
                string = l2 == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l2));
                n8 = Integer.MIN_VALUE;
                n7 = string.length();
                c4 = '0';
            } else if (Enum.class.isAssignableFrom(clazz)) {
                n9 = Integer.MIN_VALUE;
                if (this.element instanceof NumericalElement) {
                    n9 = NumberProcessor.enumToInt(this.element, chronoDisplay, attributeQuery);
                    boolean bl4 = bl3 = n9 < 0;
                }
                if (n9 == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Cannot print: " + this.element);
                }
                n8 = Math.abs(n9);
                n7 = NumberProcessor.length(n8);
            } else {
                throw new IllegalArgumentException("Not formattable: " + this.element);
            }
            if (numberSystem.hasDecimalCodepoints()) {
                if (c2 != c4) {
                    n9 = c2 - c4;
                    if (string == null) {
                        string = numberSystem.toNumeral(n8);
                    }
                    char[] cArray = string.toCharArray();
                    for (int i3 = 0; i3 < cArray.length; ++i3) {
                        cArray[i3] = (char)(cArray[i3] + n9);
                    }
                    string = new String(cArray);
                }
                if (n7 > this.maxDigits) {
                    if (string == null) {
                        string = numberSystem.toNumeral(n8);
                    }
                    throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the formatted value " + string + " exceeds the maximum width of " + this.maxDigits + ".");
                }
            }
            if (bl3) {
                if (this.signPolicy == SignPolicy.SHOW_NEVER) {
                    throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
                }
                appendable.append('-');
                ++n3;
            } else {
                switch (this.signPolicy) {
                    case SHOW_ALWAYS: {
                        appendable.append('+');
                        ++n3;
                        break;
                    }
                    case SHOW_WHEN_BIG_NUMBER: {
                        if (!numberSystem.isDecimal() || n7 <= this.minDigits) break;
                        appendable.append('+');
                        ++n3;
                        break;
                    }
                }
            }
            if (numberSystem.isDecimal()) {
                int n10 = this.minDigits - n7;
                for (n9 = 0; n9 < n10; ++n9) {
                    appendable.append(c2);
                    ++n3;
                }
            }
            if (string == null) {
                if (numberSystem.hasDecimalCodepoints()) {
                    if (n7 == 2) {
                        NumberProcessor.appendTwoDigits(n8, appendable, c2);
                    } else if (n7 == 1) {
                        appendable.append((char)(n8 + c2));
                    } else if (n8 >= 2000 && n8 < 2100) {
                        appendable.append((char)(2 + c2));
                        appendable.append(c2);
                        NumberProcessor.appendTwoDigits(n8 - 2000, appendable, c2);
                    } else if (n8 >= 1900 && n8 < 2000) {
                        appendable.append((char)('\u0001' + c2));
                        appendable.append((char)(9 + c2));
                        NumberProcessor.appendTwoDigits(n8 - 1900, appendable, c2);
                    } else {
                        appendable.append(numberSystem.toNumeral(n8));
                    }
                } else {
                    n7 = numberSystem.toNumeral(n8, appendable);
                }
            } else {
                appendable.append(string);
                n7 = string.length();
            }
            n3 += n7;
        }
        if (n2 != -1 && n3 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n2, n2 + n3));
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parse(CharSequence var1_1, ParseLog var2_2, AttributeQuery var3_3, ParsedEntity<?> var4_4, boolean var5_5) {
        var6_6 = var1_1.length();
        var7_7 = var2_2.getPosition();
        if (var5_5 && this.fixedInt) {
            if (var7_7 >= var6_6) {
                var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
                var2_2.setWarning();
                return;
            }
            var8_8 = var1_1.charAt(var7_7);
            if (var8_8 == '-' || var8_8 == '+') {
                var2_2.setError(var7_7, "Sign not allowed due to sign policy.");
                return;
            }
            var9_10 = var7_7 + this.minDigits;
            var10_13 = Math.min(var6_6, var9_10);
            var11_16 = 0L;
            for (var13_18 = var7_7; var13_18 < var10_13 && (var14_20 = var1_1.charAt(var13_18) - 48) >= 0 && var14_20 <= 9; ++var13_18) {
                var11_16 = var11_16 * 10L + (long)var14_20;
            }
            if (var11_16 > 0x7FFFFFFFL) {
                var2_2.setError(var7_7, "Parsed number does not fit into an integer: " + var11_16);
                return;
            }
            if (var13_18 < var9_10) {
                if (var13_18 == var7_7) {
                    var2_2.setError(var7_7, "Digit expected.");
                } else {
                    var2_2.setError(var7_7, "Not enough digits found for: " + this.element.name());
                }
                return;
            }
            var4_4.put(this.element, (int)var11_16);
            var2_2.setPosition(var13_18);
            return;
        }
        v0 = var8_9 = var5_5 != false ? this.protectedLength : var3_3.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (var8_9 > 0) {
            var6_6 -= var8_9;
        }
        if (var7_7 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            var2_2.setWarning();
            return;
        }
        if (this.yearOfEra && this.element instanceof DualFormatElement) {
            var9_11 = (DualFormatElement)DualFormatElement.class.cast(this.element);
            var10_14 = var9_11.parse(var1_1, var2_2.getPP(), var3_3, var4_4);
            if (var2_2.isError()) {
                var2_2.setError(var2_2.getErrorIndex(), "Unparseable element: " + this.element.name());
            } else if (var10_14 == null) {
                var2_2.setError(var7_7, "No interpretable value.");
            } else {
                var4_4.put(this.element, var10_14);
            }
            return;
        }
        var11_17 = 1;
        if (var5_5) {
            var9_12 = this.numberSystem;
            var12_22 = this.scaleOfNumsys;
            var10_15 = this.zeroDigit;
        } else {
            var9_12 = var3_3.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            var12_22 = this.getScale(var9_12);
            var10_15 = var3_3.contains(Attributes.ZERO_DIGIT) != false ? (int)var3_3.get(Attributes.ZERO_DIGIT).charValue() : (var9_12.isDecimal() != false ? (int)var9_12.getDigits().charAt(0) : 48);
        }
        v1 = var13_19 = var5_5 != false ? this.lenientMode : var3_3.get(Attributes.LENIENCY, Leniency.SMART);
        if (var9_12.isDecimal() && (this.fixedWidth || !var13_19.isLax())) {
            var11_17 = this.minDigits;
            var12_22 = this.maxDigits;
        }
        var14_21 = var7_7;
        var15_23 = false;
        var16_24 = var1_1.charAt(var14_21);
        if (var16_24 == '-' || var16_24 == '+') {
            if (this.signPolicy == SignPolicy.SHOW_NEVER && (this.fixedWidth || var13_19.isStrict())) {
                var2_2.setError(var7_7, "Sign not allowed due to sign policy.");
                return;
            }
            if (this.signPolicy == SignPolicy.SHOW_WHEN_NEGATIVE && var16_24 == '+' && var13_19.isStrict()) {
                var2_2.setError(var7_7, "Positive sign not allowed due to sign policy.");
                return;
            }
            var15_23 = var16_24 == '-';
            ++var14_21;
            ++var7_7;
        } else if (this.signPolicy == SignPolicy.SHOW_ALWAYS && var13_19.isStrict()) {
            var2_2.setError(var7_7, "Missing sign of number.");
            return;
        }
        if (var14_21 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            return;
        }
        if (!this.fixedWidth && this.reserved > 0 && var8_9 <= 0) {
            var17_25 = 0;
            if (var9_12.hasDecimalCodepoints()) {
                for (var18_26 = var14_21; var18_26 < var6_6 && (var19_27 = var1_1.charAt(var18_26) - var10_15) >= 0 && var19_27 <= 9; ++var18_26) {
                    ++var17_25;
                }
            } else {
                for (var18_26 = var14_21; var18_26 < var6_6 && var9_12.contains(var1_1.charAt(var18_26)); ++var18_26) {
                    ++var17_25;
                }
            }
            var12_22 = Math.min(var12_22, var17_25 - this.reserved);
        }
        var17_25 = var14_21 + var11_17;
        var18_26 = Math.min(var6_6, var14_21 + var12_22);
        var19_28 = 0L;
        if (var9_12.hasDecimalCodepoints()) {
            while (var14_21 < var18_26 && (var21_29 = var1_1.charAt(var14_21) - var10_15) >= 0 && var21_29 <= 9) {
                var19_28 = var19_28 * 10L + (long)var21_29;
                ++var14_21;
            }
        } else {
            var21_29 = 0;
            while (var14_21 < var18_26 && var9_12.contains(var1_1.charAt(var14_21))) {
                ++var21_29;
                ++var14_21;
            }
            try {
                if (var21_29 <= 0) ** GOTO lbl113
                var19_28 = var9_12.toInteger(var1_1.subSequence(var14_21 - var21_29, var14_21).toString(), var13_19);
            }
            catch (NumberFormatException var22_31) {
                var2_2.setError(var7_7, var22_31.getMessage());
                return;
            }
        }
lbl113:
        // 3 sources

        var21_30 = this.element.getType();
        if (var19_28 > 0x7FFFFFFFL && var21_30 == Integer.class) {
            var2_2.setError(var7_7, "Parsed number does not fit into an integer: " + var19_28);
            return;
        }
        if (var14_21 < var17_25) {
            if (var14_21 == var7_7) {
                var2_2.setError(var7_7, "Digit expected.");
                return;
            }
            if (this.fixedWidth || !var13_19.isLax()) {
                var2_2.setError(var7_7, "Not enough digits found for: " + this.element.name());
                return;
            }
        }
        if (var15_23) {
            if (var19_28 == 0L && var13_19.isStrict()) {
                var2_2.setError(var7_7 - 1, "Negative zero is not allowed.");
                return;
            }
            var19_28 = -var19_28;
        } else if (this.signPolicy == SignPolicy.SHOW_WHEN_BIG_NUMBER && var13_19.isStrict() && var9_12.isDecimal()) {
            if (var16_24 == '+' && var14_21 <= var17_25) {
                var2_2.setError(var7_7 - 1, "Positive sign only allowed for big number.");
            } else if (var16_24 != '+' && var14_21 > var17_25) {
                var2_2.setError(var7_7, "Positive sign must be present for big number.");
            }
        }
        if (var21_30 == Integer.class) {
            var4_4.put(this.element, (int)var19_28);
        } else if (var21_30 == Long.class) {
            var22_32 = var19_28;
            var4_4.put(this.element, var22_32);
        } else if (this.element == PlainDate.MONTH_OF_YEAR) {
            var4_4.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, (int)var19_28);
        } else if (Enum.class.isAssignableFrom(var21_30)) {
            var22_33 = false;
            if (this.element instanceof NumericalElement) {
                var23_34 = (NumericalElement)this.element;
                var22_33 = var23_34.parseFromInt(var4_4, (int)var19_28);
            }
            if (!var22_33) {
                var2_2.setError(var16_24 == '-' || var16_24 == '+' ? var7_7 - 1 : var7_7, "[" + this.element.name() + "] No enum found for value: " + var19_28);
                return;
            }
        } else {
            throw new IllegalArgumentException("Not parseable: " + this.element);
        }
        var2_2.setPosition(var14_21);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NumberProcessor) {
            NumberProcessor numberProcessor = (NumberProcessor)object;
            return this.element.equals(numberProcessor.element) && this.fixedWidth == numberProcessor.fixedWidth && this.minDigits == numberProcessor.minDigits && this.maxDigits == numberProcessor.maxDigits && this.signPolicy == numberProcessor.signPolicy && this.protectedMode == numberProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", fixed-width-mode=");
        stringBuilder.append(this.fixedWidth);
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(", sign-policy=");
        stringBuilder.append((Object)this.signPolicy);
        stringBuilder.append(", protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        return new NumberProcessor<V>(chronoElement, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, false);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<V> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        char c2 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        int n3 = attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        boolean bl2 = numberSystem == NumberSystem.ARABIC && c2 == '0' && this.fixedWidth && n3 == 0 && this.element.getType() == Integer.class && !this.yearOfEra;
        return new NumberProcessor<V>(this.element, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, this.protectedMode, n2, c2, numberSystem, attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), n3, bl2);
    }

    private int getScale(NumberSystem numberSystem) {
        if (numberSystem.isDecimal()) {
            Class<V> clazz = this.element.getType();
            if (clazz == Integer.class) {
                return 10;
            }
            if (clazz == Long.class) {
                return 18;
            }
            return 9;
        }
        return 100;
    }

    private static int length(int n2) {
        assert (n2 >= 0);
        int n3 = 0;
        while (n2 > THRESHOLDS[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    private static void appendTwoDigits(int n2, Appendable appendable, char c2) throws IOException {
        int n3 = n2 * 103 >>> 10;
        int n4 = n2 - ((n3 << 3) + (n3 << 1));
        appendable.append((char)(n3 + c2));
        appendable.append((char)(n4 + c2));
    }

    private static <V extends Enum<V>> int enumToInt(ChronoElement<?> chronoElement, ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        Enum enum_ = (Enum)chronoDisplay.get(chronoElement);
        return ((NumericalElement)chronoElement).printToInt(enum_, chronoDisplay, attributeQuery);
    }
}

