/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.text.ParseException;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Locale;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.tz.ZonalOffset;

public class Iso8601Format {
    private static final IsoDecimalStyle DEFAULT_ISO_DECIMAL_STYLE = Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? IsoDecimalStyle.DOT : IsoDecimalStyle.COMMA;
    private static final NonZeroCondition NON_ZERO_SECOND = new NonZeroCondition(PlainTime.SECOND_OF_MINUTE);
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition(PlainTime.NANO_OF_SECOND);
    private static final ChronoCondition<ChronoDisplay> SECOND_PART = NON_ZERO_SECOND.or(NON_ZERO_FRACTION);
    public static final ChronoFormatter<PlainDate> BASIC_CALENDAR_DATE = Iso8601Format.calendarFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_CALENDAR_DATE = Iso8601Format.calendarFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_ORDINAL_DATE = Iso8601Format.ordinalFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_ORDINAL_DATE = Iso8601Format.ordinalFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_WEEK_DATE = Iso8601Format.weekdateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_WEEK_DATE = Iso8601Format.weekdateFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_DATE = Iso8601Format.generalDateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_DATE = Iso8601Format.generalDateFormat(true);
    public static final ChronoFormatter<PlainTime> BASIC_WALL_TIME = Iso8601Format.timeFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTime> EXTENDED_WALL_TIME = Iso8601Format.timeFormat(true, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTimestamp> BASIC_DATE_TIME = Iso8601Format.timestampFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTimestamp> EXTENDED_DATE_TIME = Iso8601Format.timestampFormat(true, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<Moment> BASIC_DATE_TIME_OFFSET = Iso8601Format.momentFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<Moment> EXTENDED_DATE_TIME_OFFSET = Iso8601Format.momentFormat(true, DEFAULT_ISO_DECIMAL_STYLE);

    private Iso8601Format() {
    }

    public static ChronoPrinter<PlainDate> ofDate(IsoDateStyle isoDateStyle) {
        switch (isoDateStyle) {
            case BASIC_CALENDAR_DATE: {
                return BASIC_CALENDAR_DATE;
            }
            case BASIC_ORDINAL_DATE: {
                return BASIC_ORDINAL_DATE;
            }
            case BASIC_WEEK_DATE: {
                return BASIC_WEEK_DATE;
            }
            case EXTENDED_CALENDAR_DATE: {
                return EXTENDED_CALENDAR_DATE;
            }
            case EXTENDED_ORDINAL_DATE: {
                return EXTENDED_ORDINAL_DATE;
            }
            case EXTENDED_WEEK_DATE: {
                return EXTENDED_WEEK_DATE;
            }
        }
        throw new UnsupportedOperationException(isoDateStyle.name());
    }

    public static ChronoPrinter<PlainTime> ofBasicTime(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        Iso8601Format.addWallTime(builder, false, isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<PlainTime> ofExtendedTime(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        Iso8601Format.addWallTime(builder, true, isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<PlainTimestamp> ofTimestamp(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.axis(), Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.ofDate(isoDateStyle), (charSequence, parseLog, attributeQuery) -> null);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, isoDateStyle.isExtended(), isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<Moment> ofMoment(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.axis(), Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.ofDate(isoDateStyle), (charSequence, parseLog, attributeQuery) -> null);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, isoDateStyle.isExtended(), isoDecimalStyle, clockUnit);
        builder.addTimezoneOffset(FormatStyle.MEDIUM, isoDateStyle.isExtended(), Collections.singletonList("Z"));
        return ((ChronoFormatter)builder.build().with(Leniency.STRICT)).withTimezone(zonalOffset);
    }

    public static PlainDate parseDate(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        PlainDate plainDate = Iso8601Format.parseDate(charSequence, parseLog);
        if (plainDate == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return plainDate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PlainDate parseDate(CharSequence charSequence, ParseLog parseLog) {
        PlainDate plainDate;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = charSequence.length();
        int n6 = n5 - (n3 = parseLog.getPosition());
        if (n6 < 7) {
            parseLog.setError(n5, "Too short to be compatible with ISO-8601: " + charSequence.subSequence(n3, n5));
            return null;
        }
        block5: for (n2 = n3 + 1; n2 < n5; ++n2) {
            switch (charSequence.charAt(n2)) {
                case '-': {
                    ++n4;
                    break;
                }
                case 'W': {
                    PlainDate plainDate2;
                    if (n4 > 0) {
                        plainDate2 = EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                        return plainDate2;
                    }
                    plainDate2 = BASIC_WEEK_DATE.parse(charSequence, parseLog);
                    return plainDate2;
                }
                case '/': 
                case 'T': {
                    n6 = n2 - n3;
                    break block5;
                }
            }
        }
        if (n4 != 0) {
            if (n4 != 1) return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
            return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
        }
        n6 -= 4;
        n2 = charSequence.charAt(n3);
        if (n2 == 43 || n2 == 45) {
            n6 -= 2;
        }
        if (n6 == 3) {
            plainDate = BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
            return plainDate;
        }
        plainDate = BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
        return plainDate;
    }

    private static ChronoFormatter<PlainDate> calendarFormat(boolean bl2) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl2) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
        if (bl2) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger(PlainDate.DAY_OF_MONTH, 2).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> ordinalFormat(boolean bl2) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl2) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger(PlainDate.DAY_OF_YEAR, 3).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> weekdateFormat(boolean bl2) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl2) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger(Weekmodel.ISO.weekOfYear(), 2);
        if (bl2) {
            builder.addLiteral('-');
        }
        return builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> generalDateFormat(boolean bl2) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl2), Iso8601Format.generalDateParser(bl2));
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTime> timeFormat(boolean bl2, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        builder.skipUnknown(n2 -> n2 == 84, 1);
        Iso8601Format.addWallTime(builder, bl2, isoDecimalStyle);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormat(boolean bl2, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<PlainTimestamp> builder = ChronoFormatter.setUp(PlainTimestamp.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl2), Iso8601Format.generalDateParser(bl2));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl2, isoDecimalStyle);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<Moment> momentFormat(boolean bl2, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(Moment.axis().element(), Iso8601Format.momentFormat(FormatStyle.MEDIUM, bl2, isoDecimalStyle), Iso8601Format.momentFormat(FormatStyle.SHORT, bl2, isoDecimalStyle));
        return ((ChronoFormatter)builder.build().with(Leniency.STRICT)).withTimezone(ZonalOffset.UTC);
    }

    private static ChronoFormatter<Moment> momentFormat(FormatStyle formatStyle, boolean bl2, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl2), Iso8601Format.generalDateParser(bl2));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl2, isoDecimalStyle);
        builder.addTimezoneOffset(formatStyle, bl2, Collections.singletonList("Z"));
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoPrinter<PlainDate> generalDatePrinter(boolean bl2) {
        return (plainDate, stringBuilder, attributeQuery) -> {
            ChronoFormatter<PlainDate> chronoFormatter = bl2 ? EXTENDED_CALENDAR_DATE : BASIC_CALENDAR_DATE;
            return chronoFormatter.print((PlainDate)plainDate, stringBuilder);
        };
    }

    private static ChronoParser<PlainDate> generalDateParser(boolean bl2) {
        return (charSequence, parseLog, attributeQuery) -> {
            int n2;
            int n3 = 0;
            int n4 = charSequence.length();
            int n5 = parseLog.getPosition();
            int n6 = n4 - n5;
            block5: for (n2 = n5 + 1; n2 < n4; ++n2) {
                switch (charSequence.charAt(n2)) {
                    case '-': {
                        ++n3;
                        break;
                    }
                    case 'W': {
                        if (bl2) {
                            return EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                        }
                        return BASIC_WEEK_DATE.parse(charSequence, parseLog);
                    }
                    case '/': 
                    case 'T': {
                        n6 = n2 - n5;
                        break block5;
                    }
                }
            }
            if (bl2) {
                if (n3 == 1) {
                    return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
                }
                return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
            }
            n6 -= 4;
            n2 = charSequence.charAt(n5);
            if (n2 == 43 || n2 == 45) {
                n6 -= 2;
            }
            if (n6 == 3) {
                return BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
            }
            return BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
        };
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl2, IsoDecimalStyle isoDecimalStyle) {
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger(PlainTime.HOUR_FROM_0_TO_24, 2);
        builder.startOptionalSection();
        if (bl2) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2);
        builder.startOptionalSection(SECOND_PART);
        if (bl2) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection(NON_ZERO_FRACTION);
        switch (isoDecimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(isoDecimalStyle.name());
            }
        }
        builder.addFraction(PlainTime.NANO_OF_SECOND, 1, 9, false);
        for (int i2 = 0; i2 < 5; ++i2) {
            builder.endSection();
        }
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl2, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        if (clockUnit == null) {
            throw new NullPointerException("Missing precision.");
        }
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger(PlainTime.HOUR_FROM_0_TO_24, 2);
        if (clockUnit == ClockUnit.HOURS) {
            builder.endSection();
            builder.endSection();
            return;
        }
        if (bl2) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2);
        if (clockUnit == ClockUnit.MINUTES) {
            builder.endSection();
            builder.endSection();
            return;
        }
        if (bl2) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2);
        if (clockUnit == ClockUnit.SECONDS) {
            builder.endSection();
            builder.endSection();
            return;
        }
        switch (isoDecimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(isoDecimalStyle.name());
            }
        }
        if (clockUnit == ClockUnit.MILLIS) {
            builder.addFraction(PlainTime.NANO_OF_SECOND, 3, 3, false);
        } else if (clockUnit == ClockUnit.MICROS) {
            builder.addFraction(PlainTime.NANO_OF_SECOND, 6, 6, false);
        } else if (clockUnit == ClockUnit.NANOS) {
            builder.addFraction(PlainTime.NANO_OF_SECOND, 9, 9, false);
        }
        builder.endSection();
        builder.endSection();
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> chronoElement) {
            this.element = chronoElement;
        }

        @Override
        public boolean test(ChronoDisplay chronoDisplay) {
            return chronoDisplay.getInt(this.element) > 0;
        }

        ChronoCondition<ChronoDisplay> or(NonZeroCondition nonZeroCondition) {
            return chronoDisplay -> this.test((ChronoDisplay)chronoDisplay) || nonZeroCondition.test((ChronoDisplay)chronoDisplay);
        }
    }
}

