/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FractionalElement;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class FractionProcessor
implements FormatProcessor<Integer> {
    private static final int MRD_MINUS_1 = 999999999;
    private final FormatProcessor<Void> decimalSeparator;
    private final ChronoElement<Integer> element;
    private final int minDigits;
    private final int maxDigits;
    private final boolean fixedWidth;
    private final char zeroDigit;
    private final Leniency lenientMode;

    FractionProcessor(ChronoElement<Integer> chronoElement, int n2, int n3, boolean bl2) {
        this.element = chronoElement;
        this.minDigits = n2;
        this.maxDigits = n3;
        this.fixedWidth = !bl2 && n2 == n3;
        LiteralProcessor literalProcessor = this.decimalSeparator = bl2 ? new LiteralProcessor(Attributes.DECIMAL_SEPARATOR) : null;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative min digits: " + n2);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Max smaller than min: " + n3 + " < " + n2);
        }
        if (n2 > 9) {
            throw new IllegalArgumentException("Min digits out of range: " + n2);
        }
        if (n3 > 9) {
            throw new IllegalArgumentException("Max digits out of range: " + n3);
        }
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
    }

    private FractionProcessor(FormatProcessor<Void> formatProcessor, ChronoElement<Integer> chronoElement, int n2, int n3, boolean bl2, char c2, Leniency leniency) {
        this.decimalSeparator = formatProcessor;
        this.element = chronoElement;
        this.minDigits = n2;
        this.maxDigits = n3;
        this.fixedWidth = bl2;
        this.zeroDigit = c2;
        this.lenientMode = leniency;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = FractionProcessor.toDecimal(chronoDisplay.get(this.element));
        BigDecimal bigDecimal3 = FractionProcessor.toDecimal(chronoDisplay.getMinimum(this.element));
        BigDecimal bigDecimal4 = FractionProcessor.toDecimal(chronoDisplay.getMaximum(this.element));
        if (bigDecimal2.compareTo(bigDecimal4) > 0) {
            bigDecimal2 = bigDecimal4;
        }
        bigDecimal = (bigDecimal = bigDecimal2.subtract(bigDecimal3).divide(bigDecimal4.subtract(bigDecimal3).add(BigDecimal.ONE), 9, RoundingMode.FLOOR)).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal.stripTrailingZeros();
        char c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        int n2 = -1;
        int n3 = 0;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        if (bigDecimal.scale() == 0) {
            if (this.minDigits > 0) {
                if (this.hasDecimalSeparator()) {
                    this.decimalSeparator.print(chronoDisplay, appendable, attributeQuery, set, bl2);
                    ++n3;
                }
                for (int i2 = 0; i2 < this.minDigits; ++i2) {
                    appendable.append(c2);
                }
                n3 += this.minDigits;
            }
        } else {
            if (this.hasDecimalSeparator()) {
                this.decimalSeparator.print(chronoDisplay, appendable, attributeQuery, set, bl2);
                ++n3;
            }
            int n4 = Math.min(Math.max(bigDecimal.scale(), this.minDigits), this.maxDigits);
            bigDecimal = bigDecimal.setScale(n4, RoundingMode.FLOOR);
            String string = bigDecimal.toPlainString();
            int n5 = c2 - 48;
            int n6 = string.length();
            for (int i3 = 2; i3 < n6; ++i3) {
                char c3 = (char)(string.charAt(i3) + n5);
                appendable.append(c3);
                ++n3;
            }
        }
        if (n2 != -1 && n3 > 1 && set != null) {
            set.add(new ElementPosition(this.element, n2 + 1, n2 + n3));
        }
        return n3;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        Leniency leniency = bl2 ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n3 = 0;
        int n4 = 9;
        if (!leniency.isLax() || this.fixedWidth) {
            n3 = this.minDigits;
            n4 = this.maxDigits;
        }
        int n5 = charSequence.length();
        if (parseLog.getPosition() >= n5) {
            if (n3 > 0) {
                parseLog.setError(parseLog.getPosition(), "Expected fraction digits not found for: " + this.element.name());
            }
            return;
        }
        if (this.hasDecimalSeparator()) {
            this.decimalSeparator.parse(charSequence, parseLog, attributeQuery, null, bl2);
            if (parseLog.isError()) {
                if (n3 == 0) {
                    parseLog.clearError();
                }
                return;
            }
        }
        int n6 = n2 + n3;
        int n7 = Math.min(n2 + n4, n5);
        if (n6 > n5 && leniency.isStrict()) {
            parseLog.setError(parseLog.getPosition(), "Expected at least " + n3 + " digits.");
            return;
        }
        char c2 = bl2 ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        long l2 = 0L;
        for (n2 = parseLog.getPosition(); n2 < n7; ++n2) {
            int n8 = charSequence.charAt(n2) - c2;
            if (n8 >= 0 && n8 <= 9) {
                l2 = l2 * 10L + (long)n8;
                continue;
            }
            if (n2 >= n6 || !leniency.isStrict()) break;
            parseLog.setError(parseLog.getPosition(), "Expected at least " + n3 + " digits.");
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(l2);
        bigDecimal = bigDecimal.movePointLeft(n2 - parseLog.getPosition());
        if (this.element.name().equals("NANO_OF_SECOND")) {
            int n9 = this.getRealValue(bigDecimal, 0, 999999999);
            parsedEntity.put(this.element, n9);
        } else {
            parsedEntity.put(FractionalElement.FRACTION, bigDecimal);
            parsedEntity.put((ChronoElement<?>)this.element, this.element.getDefaultMinimum());
        }
        parseLog.setPosition(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FractionProcessor) {
            FractionProcessor fractionProcessor = (FractionProcessor)object;
            return this.element.equals(fractionProcessor.element) && this.minDigits == fractionProcessor.minDigits && this.maxDigits == fractionProcessor.maxDigits && this.hasDecimalSeparator() == fractionProcessor.hasDecimalSeparator();
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new FractionProcessor(chronoElement, this.minDigits, this.maxDigits, this.hasDecimalSeparator());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<Integer> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return new FractionProcessor(this.decimalSeparator, this.element, this.minDigits, this.maxDigits, this.fixedWidth, attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
    }

    ChronoEntity<?> update(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        if (!chronoEntity2.contains(FractionalElement.FRACTION)) {
            return chronoEntity;
        }
        BigDecimal bigDecimal = chronoEntity2.get(FractionalElement.FRACTION);
        int n2 = chronoEntity.getMinimum(this.element);
        int n3 = chronoEntity.getMaximum(this.element);
        int n4 = this.getRealValue(bigDecimal, n2, n3);
        chronoEntity2.with(FractionalElement.FRACTION, null);
        chronoEntity2.with(this.element, n4);
        return chronoEntity.with(this.element, n4);
    }

    private int getRealValue(BigDecimal bigDecimal, int n2, int n3) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(n3).subtract(bigDecimal2).add(BigDecimal.ONE);
        BigDecimal bigDecimal4 = bigDecimal.multiply(bigDecimal3).setScale(0, RoundingMode.FLOOR).add(bigDecimal2);
        return bigDecimal4.intValueExact();
    }

    private static BigDecimal toDecimal(Number number) {
        return BigDecimal.valueOf(number.longValue());
    }

    private boolean hasDecimalSeparator() {
        return this.decimalSeparator != null;
    }
}

