/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.FormatUtils;
import net.time4j.format.internal.IsoTextProviderSPI;
import net.time4j.format.internal.PropertyBundle;

public final class CalendarText {
    private static final Set<String> RTL;
    private static final FormatPatternProvider FORMAT_PATTERN_PROVIDER;
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final TextProvider JDK_PROVIDER;
    private static final TextProvider ROOT_PROVIDER;
    private static final ConcurrentMap<String, CalendarText> CACHE;
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> weekdays;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> meridiems;
    private final Map<TextWidth, TextAccessor> eras;
    private final Map<String, String> textForms;
    private final String calendarType;
    private final Locale locale;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, TextProvider textProvider) {
        void var10_22;
        void var11_29;
        void var10_18;
        this.provider = textProvider.toString();
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, textProvider, false));
        Map<TextWidth, Map<OutputContext, TextAccessor>> map = CalendarText.getMonths(string, locale, textProvider, true);
        this.leapMonths = map.isEmpty() ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> object = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                object.put(outputContext, new TextAccessor(textProvider.quarters(string, locale, textWidth, outputContext)));
            }
            enumMap.put(textWidth, object);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        for (TextWidth missingResourceException : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap3 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap3.put(outputContext, new TextAccessor(textProvider.weekdays(string, locale, missingResourceException, outputContext)));
            }
            enumMap2.put(missingResourceException, enumMap3);
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        EnumMap enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n2 = ((TextWidth[])enumMap4).length;
        boolean bl2 = false;
        while (var10_18 < n2) {
            TextWidth textWidth = enumMap4[var10_18];
            enumMap3.put(textWidth, new TextAccessor(textProvider.eras(string, locale, textWidth)));
            ++var10_18;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        Object hashMap = TextWidth.values();
        int n3 = ((TextWidth[])hashMap).length;
        boolean bl3 = false;
        while (var11_29 < n3) {
            TextWidth textWidth = hashMap[var11_29];
            EnumMap<OutputContext, TextAccessor> enumMap5 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap5.put(outputContext, new TextAccessor(textProvider.meridiems(string, locale, textWidth, outputContext)));
            }
            enumMap4.put(textWidth, enumMap5);
            ++var11_29;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
        hashMap = new HashMap();
        Object var10_20 = null;
        try {
            StringBuilder stringBuilder = new StringBuilder("names/");
            stringBuilder.append(string);
            stringBuilder.append("/");
            stringBuilder.append(string);
            PropertyBundle propertyBundle = PropertyBundle.load(stringBuilder.toString(), locale);
            for (String string2 : propertyBundle.keySet()) {
                hashMap.put(string2, propertyBundle.getString(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
        }
        this.textForms = Collections.unmodifiableMap(hashMap);
        this.calendarType = string;
        this.locale = locale;
        this.mre = var10_22;
    }

    public static CalendarText getIsoInstance(Locale locale) {
        return CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        String string2;
        Object object;
        String string3;
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        String string4 = FormatUtils.getRegion(locale);
        if (!string4.isEmpty()) {
            stringBuilder.append('-');
            stringBuilder.append(string4);
        }
        if (!(string3 = locale.getScript()).isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(string3);
        }
        if ((object = (CalendarText)CACHE.get(string2 = stringBuilder.toString())) == null) {
            Object object2;
            Object object3 = null;
            if (locale.getLanguage().isEmpty() && string.equals(ISO_CALENDAR_TYPE)) {
                object3 = ROOT_PROVIDER;
            } else {
                for (TextProvider textProvider : ResourceLoader.getInstance().services(TextProvider.class)) {
                    if (!textProvider.supportsCalendarType(string) || !textProvider.supportsLanguage(locale)) continue;
                    object3 = textProvider;
                    break;
                }
                if (object3 == null) {
                    object2 = JDK_PROVIDER;
                    if (object2.supportsCalendarType(string) && object2.supportsLanguage(locale)) {
                        object3 = object2;
                    }
                    if (object3 == null) {
                        object3 = ROOT_PROVIDER;
                    }
                }
            }
            object = new CalendarText(string, locale, (TextProvider)object3);
            object2 = CACHE.putIfAbsent(string2, (CalendarText)object);
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    public TextAccessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public TextAccessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public TextAccessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public TextAccessor getMeridiems(TextWidth textWidth, OutputContext outputContext) {
        return this.meridiems.get((Object)textWidth).get((Object)outputContext);
    }

    public Map<String, String> getTextForms() {
        return this.textForms;
    }

    public <V extends Enum<V>> TextAccessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        return this.getTextForms(chronoElement.name(), chronoElement.getType(), stringArray);
    }

    public <V extends Enum<V>> TextAccessor getTextForms(String string, Class<V> clazz, String ... stringArray) {
        if (this.mre != null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n2 = enumArray.length;
        String[] stringArray2 = new String[n2];
        String string2 = this.getKeyPrefix(string);
        int n3 = CalendarEra.class.isAssignableFrom(clazz) ? 0 : 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3;
            int n4 = 0;
            String string4 = null;
            while ((string3 = CalendarText.getKeyStart(string2, n4, stringArray)) != null) {
                String string5 = CalendarText.toKey(string3, i2, n3);
                if (this.textForms.containsKey(string5)) {
                    string4 = string5;
                    break;
                }
                ++n4;
            }
            if (string4 == null) {
                if (this.textForms.containsKey(string)) {
                    stringArray2[i2] = this.textForms.get(string);
                    continue;
                }
                stringArray2[i2] = enumArray[i2].name();
                continue;
            }
            stringArray2[i2] = this.textForms.get(string4);
        }
        return new TextAccessor(stringArray2);
    }

    @Deprecated
    public static String patternForDate(DisplayMode displayMode, Locale locale) {
        return CalendarText.patternForDate(displayMode.toThreeten(), locale);
    }

    @Deprecated
    public static String patternForTime(DisplayMode displayMode, Locale locale) {
        return CalendarText.patternForTime(displayMode.toThreeten(), locale);
    }

    @Deprecated
    public static String patternForTimestamp(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        return CalendarText.patternForTimestamp(displayMode.toThreeten(), displayMode2.toThreeten(), locale);
    }

    @Deprecated
    public static String patternForMoment(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        return CalendarText.patternForMoment(displayMode.toThreeten(), displayMode2.toThreeten(), locale);
    }

    public static String patternForDate(FormatStyle formatStyle, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getDatePattern(formatStyle, locale);
    }

    public static String patternForTime(FormatStyle formatStyle, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getTimePattern(formatStyle, locale);
    }

    public static String patternForTimestamp(FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale) {
        String string = CalendarText.patternForMoment(formatStyle, formatStyle2, locale);
        return FormatUtils.removeZones(string);
    }

    public static String patternForMoment(FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getDateTimePattern(formatStyle, formatStyle2, locale);
    }

    public static String patternForInterval(Locale locale) {
        return FORMAT_PATTERN_PROVIDER.getIntervalPattern(locale);
    }

    public String toString() {
        return this.provider + "(" + this.calendarType + "/" + this.locale + ")";
    }

    public static void clearCache() {
        PropertyBundle.clearCache();
        CACHE.clear();
    }

    public static boolean isRTL(Locale locale) {
        return RTL.contains(locale.getLanguage());
    }

    static String extractCalendarType(Chronology<?> chronology) {
        while (chronology instanceof BridgeChronology) {
            chronology = chronology.preparser();
        }
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private TextAccessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl2) {
        if (bl2) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, TextAccessor>> getMonths(String string, Locale locale, TextProvider textProvider, boolean bl2) {
        EnumMap enumMap = new EnumMap(TextWidth.class);
        boolean bl3 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = textProvider.months(string, locale, textWidth, outputContext, bl2);
                if (bl2 && !bl3) {
                    Object[] objectArray2 = textProvider.months(string, locale, textWidth, outputContext, false);
                    bl3 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new TextAccessor((String[])objectArray));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl2 || bl3 ? enumMap : Collections.emptyMap();
    }

    private String getKeyPrefix(String string) {
        if (this.textForms.containsKey("useShortKeys") && "true".equals(this.textForms.get("useShortKeys"))) {
            switch (string) {
                case "MONTH_OF_YEAR": 
                case "DAY_OF_WEEK": 
                case "QUARTER_OF_YEAR": 
                case "ERA": {
                    return string.substring(0, 1);
                }
                case "EVANGELIST": {
                    return "EV";
                }
                case "SANSCULOTTIDES": {
                    return "S";
                }
                case "DAY_OF_DECADE": {
                    return "D";
                }
            }
        }
        return string;
    }

    private static String getKeyStart(String string, int n2, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length < n2) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            boolean bl2 = true;
            for (int i2 = 0; i2 < stringArray.length - n2; ++i2) {
                if (bl2) {
                    stringBuilder.append('(');
                    bl2 = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[i2]);
            }
            if (!bl2) {
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
        return n2 > 0 ? null : string;
    }

    private static String toKey(String string, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_');
        stringBuilder.append(n2 + n3);
        return stringBuilder.toString();
    }

    static {
        Object object = new HashSet<String>();
        object.add("ar");
        object.add("dv");
        object.add("fa");
        object.add("ha");
        object.add("he");
        object.add("iw");
        object.add("ji");
        object.add("ps");
        object.add("sd");
        object.add("ug");
        object.add("ur");
        object.add("yi");
        RTL = Collections.unmodifiableSet(object);
        object = ResourceLoader.getInstance().services(FormatPatternProvider.class).iterator();
        FormatPatternProvider formatPatternProvider = object.hasNext() ? (FormatPatternProvider)object.next() : IsoTextProviderSPI.SINGLETON;
        FORMAT_PATTERN_PROVIDER = new FormatPatterns(formatPatternProvider);
        JDK_PROVIDER = new JDKTextProvider();
        ROOT_PROVIDER = new FallbackProvider();
        CACHE = new ConcurrentHashMap<String, CalendarText>();
    }

    private static class FormatPatterns
    implements FormatPatternProvider {
        private final FormatPatternProvider delegate;

        FormatPatterns(FormatPatternProvider formatPatternProvider) {
            if (formatPatternProvider == null) {
                throw new NullPointerException("Missing format pattern delegate.");
            }
            this.delegate = formatPatternProvider;
        }

        @Override
        public String getDatePattern(FormatStyle formatStyle, Locale locale) {
            try {
                return this.delegate.getDatePattern(formatStyle, locale);
            }
            catch (MissingResourceException missingResourceException) {
                int n2 = FormatPatterns.toOldStyle(formatStyle);
                DateFormat dateFormat = DateFormat.getDateInstance(n2, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
        }

        @Override
        public String getTimePattern(FormatStyle formatStyle, Locale locale) {
            String string;
            try {
                string = this.delegate.getTimePattern(formatStyle, locale);
            }
            catch (MissingResourceException missingResourceException) {
                int n2 = FormatPatterns.toOldStyle(formatStyle);
                DateFormat dateFormat = DateFormat.getTimeInstance(n2, locale);
                string = FormatPatterns.getFormatPattern(dateFormat);
            }
            return FormatUtils.removeZones(string);
        }

        @Override
        public String getDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale) {
            try {
                String string = this.delegate.getDatePattern(formatStyle, locale);
                String string2 = this.delegate.getTimePattern(formatStyle2, locale);
                String string3 = this.delegate.getDateTimePattern(formatStyle, formatStyle2, locale);
                return string3.replace("{1}", string).replace("{0}", string2);
            }
            catch (MissingResourceException missingResourceException) {
                int n2 = FormatPatterns.toOldStyle(formatStyle);
                int n3 = FormatPatterns.toOldStyle(formatStyle2);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(n2, n3, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            try {
                return this.delegate.getIntervalPattern(locale);
            }
            catch (MissingResourceException missingResourceException) {
                if (locale.getLanguage().isEmpty() && FormatUtils.getRegion(locale).isEmpty()) {
                    return "{0}/{1}";
                }
                return "{0} - {1}";
            }
        }

        private static int toOldStyle(FormatStyle formatStyle) {
            switch (formatStyle) {
                case FULL: {
                    return 0;
                }
                case LONG: {
                    return 1;
                }
                case MEDIUM: {
                    return 2;
                }
                case SHORT: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown: " + (Object)((Object)formatStyle));
        }

        private static String getFormatPattern(DateFormat dateFormat) {
            if (dateFormat instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
            }
            throw new IllegalStateException("Cannot retrieve format pattern: " + dateFormat);
        }
    }

    private static class JDKTextProvider
    implements TextProvider {
        private JDKTextProvider() {
        }

        @Override
        public boolean supportsCalendarType(String string) {
            return CalendarText.ISO_CALENDAR_TYPE.equals(string);
        }

        @Override
        public boolean supportsLanguage(Locale locale) {
            String string = locale.getLanguage();
            for (Locale locale2 : DateFormatSymbols.getAvailableLocales()) {
                if (!locale2.getLanguage().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl2) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[12];
            int n2 = 0;
            for (Month month : Month.values()) {
                stringArray[n2] = month.getDisplayName(textStyle, locale);
                ++n2;
            }
            return stringArray;
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                LocalDate localDate = LocalDate.of(1970, i2 * 3 + 1, 1);
                stringArray[i2] = new DateTimeFormatterBuilder().appendText(IsoFields.QUARTER_OF_YEAR, textStyle).toFormatter(locale).format(localDate);
            }
            return stringArray;
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[7];
            int n2 = 0;
            for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
                stringArray[n2] = dayOfWeek.getDisplayName(textStyle, locale);
                ++n2;
            }
            return stringArray;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, OutputContext.FORMAT);
            String[] stringArray = new String[2];
            int n2 = 0;
            for (IsoEra isoEra : IsoEra.values()) {
                stringArray[n2] = isoEra.getDisplayName(textStyle, locale);
                ++n2;
            }
            return stringArray;
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[2];
            for (int i2 = 0; i2 < 2; ++i2) {
                LocalTime localTime = LocalTime.of(i2 * 12, 0);
                stringArray[i2] = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.AMPM_OF_DAY, textStyle).toFormatter(locale).format(localTime);
            }
            return stringArray;
        }

        public String toString() {
            return "JDKTextProvider";
        }

        private static TextStyle getStyle(TextWidth textWidth, OutputContext outputContext) {
            boolean bl2 = outputContext == OutputContext.STANDALONE;
            switch (textWidth) {
                case WIDE: {
                    return bl2 ? TextStyle.FULL_STANDALONE : TextStyle.FULL;
                }
                case ABBREVIATED: 
                case SHORT: {
                    return bl2 ? TextStyle.SHORT_STANDALONE : TextStyle.SHORT;
                }
                case NARROW: {
                    return bl2 ? TextStyle.NARROW_STANDALONE : TextStyle.NARROW;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }
    }

    private static class FallbackProvider
    implements TextProvider {
        private FallbackProvider() {
        }

        @Override
        public boolean supportsCalendarType(String string) {
            return true;
        }

        @Override
        public boolean supportsLanguage(Locale locale) {
            return true;
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl2) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }

        public String toString() {
            return "FallbackProvider";
        }
    }
}

