/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimeSpan;

public abstract class TimePoint<U, T extends TimePoint<U, T>>
extends ChronoEntity<T>
implements Comparable<T>,
Serializable {
    @Override
    public abstract int compareTo(T var1);

    public T plus(TimeSpan<? extends U> timeSpan) {
        try {
            return (T)timeSpan.addTo((TimePoint)this.getContext());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T minus(TimeSpan<? extends U> timeSpan) {
        try {
            return (T)timeSpan.subtractFrom((TimePoint)this.getContext());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T plus(long l2, U u2) {
        if (l2 == 0L) {
            return (T)((TimePoint)this.getContext());
        }
        try {
            return (T)((TimeAxis)this.getChronology()).getRule(u2).addTo((TimePoint)this.getContext(), l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T minus(long l2, U u2) {
        return this.plus(MathUtils.safeNegate(l2), u2);
    }

    public <P> P until(T t2, TimeMetric<? extends U, P> timeMetric) {
        return timeMetric.between((TimePoint)this.getContext(), t2);
    }

    public long until(T t2, U u2) {
        return ((TimeAxis)this.getChronology()).getRule(u2).between((TimePoint)this.getContext(), (TimePoint)t2);
    }

    public static <U, T extends TimePoint<U, T>> T min(T t2, T t3) {
        return t2.compareTo(t3) > 0 ? t3 : t2;
    }

    public static <U, T extends TimePoint<U, T>> T max(T t2, T t3) {
        return t2.compareTo(t3) > 0 ? t2 : t3;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected abstract TimeAxis<U, T> getChronology();
}

