/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ElementRule;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.RuleNotFoundException;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimePoint;
import net.time4j.engine.VariantSource;

public class Chronology<T>
implements ChronoMerger<T> {
    private static final List<ChronoReference> CHRONOS = new CopyOnWriteArrayList<ChronoReference>();
    private static final ReferenceQueue<Chronology<?>> QUEUE = new ReferenceQueue();
    private final Class<T> chronoType;
    private final ChronoMerger<T> merger;
    private final Map<ChronoElement<?>, ElementRule<T, ?>> ruleMap;
    private final List<ChronoExtension> extensions;
    private final Map<ChronoElement<?>, IntElementRule<T>> intRules;

    Chronology(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        this.chronoType = clazz;
        this.merger = null;
        this.ruleMap = Collections.emptyMap();
        this.extensions = Collections.emptyList();
        this.intRules = Collections.emptyMap();
    }

    Chronology(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, List<ChronoExtension> list) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        if (chronoMerger == null) {
            throw new NullPointerException("Missing chronological merger.");
        }
        this.chronoType = clazz;
        this.merger = chronoMerger;
        this.ruleMap = Collections.unmodifiableMap(map);
        this.extensions = Collections.unmodifiableList(list);
        HashMap hashMap = new HashMap();
        for (ChronoElement<?> chronoElement : this.ruleMap.keySet()) {
            ElementRule<T, ?> elementRule;
            if (chronoElement.getType() != Integer.class || !Chronology.isSingleton(chronoElement) || !((elementRule = this.ruleMap.get(chronoElement)) instanceof IntElementRule)) continue;
            hashMap.put(chronoElement, (IntElementRule)elementRule);
        }
        IdentityHashMap identityHashMap = new IdentityHashMap(hashMap.size());
        identityHashMap.putAll(hashMap);
        this.intRules = identityHashMap;
    }

    public Class<T> getChronoType() {
        return this.chronoType;
    }

    public Set<ChronoElement<?>> getRegisteredElements() {
        return this.ruleMap.keySet();
    }

    public boolean isRegistered(ChronoElement<?> chronoElement) {
        return chronoElement != null && this.ruleMap.containsKey(chronoElement);
    }

    public boolean isSupported(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        return this.isRegistered(chronoElement) || this.getDerivedRule(chronoElement, false) != null;
    }

    @Override
    public T createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
        return this.merger.createFrom(timeSource, attributeQuery);
    }

    @Override
    public T createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
        return this.merger.createFrom(chronoEntity, attributeQuery, bl2, bl3);
    }

    @Override
    public ChronoDisplay preformat(T t2, AttributeQuery attributeQuery) {
        return this.merger.preformat(t2, attributeQuery);
    }

    @Override
    public Chronology<?> preparser() {
        return this.merger.preparser();
    }

    @Override
    public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
        return this.merger.getFormatPattern(formatStyle, locale);
    }

    @Override
    public StartOfDay getDefaultStartOfDay() {
        return this.merger.getDefaultStartOfDay();
    }

    @Override
    public int getDefaultPivotYear() {
        return this.merger.getDefaultPivotYear();
    }

    public List<ChronoExtension> getExtensions() {
        return this.extensions;
    }

    public boolean hasCalendarSystem() {
        return false;
    }

    public CalendarSystem<T> getCalendarSystem() {
        throw new ChronoException("Calendar system is not available.");
    }

    public CalendarSystem<T> getCalendarSystem(String string) {
        throw new ChronoException("Calendar variant is not available: " + string);
    }

    public final CalendarSystem<T> getCalendarSystem(VariantSource variantSource) {
        return this.getCalendarSystem(variantSource.getVariant());
    }

    public static <T> Chronology<T> lookup(Class<T> clazz) {
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        Chronology chronology = null;
        boolean bl2 = false;
        for (ChronoReference chronoReference : CHRONOS) {
            Chronology chronology2 = (Chronology)chronoReference.get();
            if (chronology2 == null) {
                bl2 = true;
                continue;
            }
            if (chronology2.getChronoType() != clazz) continue;
            chronology = chronology2;
            break;
        }
        if (bl2) {
            Chronology.purgeQueue();
        }
        return (Chronology)Chronology.cast(chronology);
    }

    static void register(Chronology<?> chronology) {
        CHRONOS.add(new ChronoReference(chronology, QUEUE));
    }

    <V> ElementRule<T, V> getRule(ChronoElement<V> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        ElementRule<T, Object> elementRule = this.ruleMap.get(chronoElement);
        if (elementRule == null && (elementRule = this.getDerivedRule(chronoElement, true)) == null) {
            throw new RuleNotFoundException(this, chronoElement);
        }
        return (ElementRule)Chronology.cast(elementRule);
    }

    IntElementRule<T> getIntegerRule(ChronoElement<Integer> chronoElement) {
        return this.intRules.get(chronoElement);
    }

    private ElementRule<T, ?> getDerivedRule(ChronoElement<?> chronoElement, boolean bl2) {
        if (chronoElement instanceof BasicElement && ChronoEntity.class.isAssignableFrom(this.getChronoType())) {
            String string;
            BasicElement basicElement = (BasicElement)BasicElement.class.cast(chronoElement);
            String string2 = string = bl2 ? basicElement.getVeto(this) : null;
            if (string == null) {
                Chronology chronology = (Chronology)Chronology.cast(this);
                ElementRule elementRule = basicElement.derive(chronology);
                return (ElementRule)Chronology.cast(elementRule);
            }
            throw new RuleNotFoundException(string);
        }
        return null;
    }

    private static boolean isSingleton(ChronoElement<?> chronoElement) {
        if (chronoElement instanceof BasicElement) {
            return ((BasicElement)BasicElement.class.cast(chronoElement)).isSingleton();
        }
        return false;
    }

    private static void purgeQueue() {
        ChronoReference chronoReference;
        block0: while ((chronoReference = (ChronoReference)QUEUE.poll()) != null) {
            for (ChronoReference chronoReference2 : CHRONOS) {
                if (!chronoReference2.name.equals(chronoReference.name)) continue;
                CHRONOS.remove(chronoReference2);
                continue block0;
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static class ChronoReference
    extends WeakReference<Chronology<?>> {
        private final String name;

        ChronoReference(Chronology<?> chronology, ReferenceQueue<Chronology<?>> referenceQueue) {
            super(chronology, referenceQueue);
            this.name = ((Chronology)chronology).chronoType.getName();
        }
    }

    public static class Builder<T extends ChronoEntity<T>> {
        final Class<T> chronoType;
        final boolean time4j;
        final ChronoMerger<T> merger;
        final Map<ChronoElement<?>, ElementRule<T, ?>> ruleMap;
        final List<ChronoExtension> extensions;

        Builder(Class<T> clazz, ChronoMerger<T> chronoMerger) {
            if (chronoMerger == null) {
                throw new NullPointerException("Missing chronological merger.");
            }
            this.chronoType = clazz;
            this.time4j = clazz.getName().startsWith("net.time4j.");
            this.merger = chronoMerger;
            this.ruleMap = new HashMap();
            this.extensions = new ArrayList<ChronoExtension>();
        }

        public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, ChronoMerger<T> chronoMerger) {
            if (TimePoint.class.isAssignableFrom(clazz)) {
                throw new UnsupportedOperationException("This builder cannot construct a chronology with a time axis, use TimeAxis.Builder instead.");
            }
            return new Builder<T>(clazz, chronoMerger);
        }

        public <V> Builder<T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            this.checkElementDuplicates(chronoElement);
            this.ruleMap.put(chronoElement, elementRule);
            return this;
        }

        public Builder<T> appendExtension(ChronoExtension chronoExtension) {
            if (chronoExtension == null) {
                throw new NullPointerException("Missing chronological extension.");
            }
            if (!this.extensions.contains(chronoExtension)) {
                this.extensions.add(chronoExtension);
            }
            return this;
        }

        public Chronology<T> build() {
            Chronology<T> chronology = new Chronology<T>(this.chronoType, this.merger, this.ruleMap, this.extensions);
            Chronology.register(chronology);
            return chronology;
        }

        private void checkElementDuplicates(ChronoElement<?> chronoElement) {
            if (this.time4j) {
                return;
            }
            if (chronoElement == null) {
                throw new NullPointerException("Static initialization problem: Check if given element statically refer to any chronology causing premature class loading.");
            }
            String string = chronoElement.name();
            for (ChronoElement<?> chronoElement2 : this.ruleMap.keySet()) {
                if (!chronoElement2.equals(chronoElement) && !chronoElement2.name().equals(string)) continue;
                throw new IllegalArgumentException("Element duplicate found: " + string);
            }
        }
    }
}

