/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.engine.CalendarDate;

public final class CalendarDays
implements Comparable<CalendarDays>,
Serializable {
    public static final CalendarDays ZERO = new CalendarDays(0L);
    public static final CalendarDays ONE = new CalendarDays(1L);
    private final long days;

    private CalendarDays(long l2) {
        this.days = l2;
    }

    public static CalendarDays of(long l2) {
        return l2 == 0L ? ZERO : (l2 == 1L ? ONE : new CalendarDays(l2));
    }

    public long getAmount() {
        return this.days;
    }

    public boolean isZero() {
        return this.days == 0L;
    }

    public boolean isNegative() {
        return this.days < 0L;
    }

    public static CalendarDays between(CalendarDate calendarDate, CalendarDate calendarDate2) {
        long l2 = calendarDate.getDaysSinceEpochUTC();
        long l3 = calendarDate2.getDaysSinceEpochUTC();
        return CalendarDays.of(Math.subtractExact(l3, l2));
    }

    public CalendarDays abs() {
        return this.days < 0L ? this.inverse() : this;
    }

    public CalendarDays inverse() {
        return CalendarDays.of(Math.negateExact(this.days));
    }

    public CalendarDays plus(CalendarDays calendarDays) {
        return CalendarDays.of(Math.addExact(this.days, calendarDays.days));
    }

    public CalendarDays minus(CalendarDays calendarDays) {
        return CalendarDays.of(Math.subtractExact(this.days, calendarDays.days));
    }

    @Override
    public int compareTo(CalendarDays calendarDays) {
        return this.days < calendarDays.days ? -1 : (this.days > calendarDays.days ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarDays) {
            return this.days == ((CalendarDays)object).days;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.days ^ this.days >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.days < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        stringBuilder.append(Math.abs(this.days));
        stringBuilder.append('D');
        return stringBuilder.toString();
    }
}

