/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.base.MathUtils;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.frenchrev.FrenchRepublicanCalendar;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.ZonalOffset;

public enum FrenchRepublicanAlgorithm {
    EQUINOX{

        @Override
        public boolean isLeapYear(int n2) {
            if (n2 < 1 || n2 > 1202) {
                throw new IllegalArgumentException("Out of range: " + n2);
            }
            long l2 = this.autumnalEquinox(n2).getDaysSinceEpochUTC();
            long l3 = this.autumnalEquinox(n2 + 1).getDaysSinceEpochUTC();
            return l3 - l2 == 366L;
        }

        @Override
        FrenchRepublicanCalendar transform(long l2) {
            FrenchRepublicanAlgorithm.check(l2);
            PlainDate plainDate = PlainDate.of(l2, EpochDays.UTC);
            int n2 = plainDate.getYear() - 1791;
            if (plainDate.getMonth() < 9) {
                --n2;
            }
            PlainDate plainDate2 = this.autumnalEquinox(n2);
            long l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            while (l3 < 0L) {
                plainDate2 = this.autumnalEquinox(--n2);
                l3 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            }
            int n3 = (int)(l3 + 1L);
            return new FrenchRepublicanCalendar(n2, n3);
        }

        @Override
        long transform(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            long l2 = this.autumnalEquinox(frenchRepublicanCalendar.getYear()).getDaysSinceEpochUTC();
            return l2 + (long)frenchRepublicanCalendar.getDayOfYear() - 1L;
        }

        private PlainDate autumnalEquinox(int n2) {
            PlainTimestamp plainTimestamp = AstronomicalSeason.AUTUMNAL_EQUINOX.inYear(n2 + 1791).get(SolarTime.apparentAt(PARIS_OBSERVATORY));
            return plainTimestamp.getCalendarDate();
        }
    }
    ,
    ROMME{

        @Override
        public boolean isLeapYear(int n2) {
            if (n2 < 1 || n2 > 1202) {
                throw new IllegalArgumentException("Out of range: " + n2);
            }
            if (n2 == 3 || n2 == 7 || n2 == 11) {
                return true;
            }
            if (n2 >= 15) {
                return (n2 & 3) == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
            }
            return false;
        }

        @Override
        FrenchRepublicanCalendar transform(long l2) {
            if (l2 < ABOLITION) {
                return EQUINOX.transform(l2);
            }
            FrenchRepublicanAlgorithm.check(l2);
            int n2 = (int)(MathUtils.floorDivide((l2 - EPOCH + 2L) * 4000L, 1460969) + 1L);
            long l3 = this.transform(new FrenchRepublicanCalendar(n2, 1));
            if (l3 > l2) {
                l3 = this.transform(new FrenchRepublicanCalendar(n2 - 1, 1));
                --n2;
            }
            int n3 = (int)(l2 - l3 + 1L);
            return new FrenchRepublicanCalendar(n2, n3);
        }

        @Override
        long transform(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (frenchRepublicanCalendar.getYear() < 15) {
                return EQUINOX.transform(frenchRepublicanCalendar);
            }
            int n2 = frenchRepublicanCalendar.getYear() - 1;
            return EPOCH - 1L + (long)(365 * n2) + (long)MathUtils.floorDivide(n2, 4) - (long)MathUtils.floorDivide(n2, 100) + (long)MathUtils.floorDivide(n2, 400) + (long)frenchRepublicanCalendar.getDayOfYear();
        }
    };

    private static final ZonalOffset PARIS_OBSERVATORY;
    private static final long ABOLITION;
    private static final long EPOCH;
    private static final AttributeKey<FrenchRepublicanAlgorithm> ATTRIBUTE;

    public static AttributeKey<FrenchRepublicanAlgorithm> attribute() {
        return ATTRIBUTE;
    }

    public boolean isLeapYear(int n2) {
        throw new AbstractMethodError();
    }

    abstract FrenchRepublicanCalendar transform(long var1);

    abstract long transform(FrenchRepublicanCalendar var1);

    private static void check(long l2) {
        if (l2 < -65478L || l2 > 373542L) {
            throw new IllegalArgumentException("Out of range: " + l2);
        }
    }

    static {
        PARIS_OBSERVATORY = ZonalOffset.atLongitude(OffsetSign.AHEAD_OF_UTC, 2, 20, 14.025);
        ABOLITION = PlainDate.of(1806, 1, 1).get(EpochDays.UTC);
        EPOCH = PlainDate.of(1792, 9, 22).get(EpochDays.UTC);
        ATTRIBUTE = Attributes.createKey("FRENCH_REPUBLICAN_ALGORITHM", FrenchRepublicanAlgorithm.class);
    }
}

