/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.SkyPosition;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.engine.ChronoCondition;

public enum Zodiac {
    ARIES('\u2648', 26.766, 11.048),
    TAURUS('\u2649', 51.113, 18.648),
    GEMINI('\u264a', 90.218, 23.439),
    CANCER('\u264b', 120.198, 20.542),
    LEO('\u264c', 140.637, 15.375),
    VIRGO('\u264d', 174.4, 2.423),
    LIBRA('\u264e', 215.634, -14.176),
    SCORPIUS('\u264f', 238.861, -20.359),
    OPHIUCHUS('\u26ce', 245.915, -21.594),
    SAGITTARIUS('\u2650', 265.968, -23.388),
    CAPRICORNUS('\u2651', 301.869, -20.214),
    AQUARIUS('\u2652', 329.79, -12.306),
    PISCES('\u2653', 352.284, -3.331);

    private static final Map<String, String[]> LANG_TO_NAMES;
    private static final double MEAN_TROPICAL_YEAR = 365.242189;
    private static final double MEAN_SYNODIC_MONTH = 29.530588861;
    private final transient char symbol;
    private final transient EquatorialCoordinates entry;

    private Zodiac(char c2, double d2, double d3) {
        this.symbol = c2;
        this.entry = new SkyPosition(d2, d3);
    }

    public static Zodiac constellationPassedBySun(Moment moment) {
        return Zodiac.of('S', moment, false);
    }

    public static Zodiac constellationPassedByMoon(Moment moment) {
        return Zodiac.of('L', moment, false);
    }

    public static Zodiac signPassedBySun(Moment moment) {
        return Zodiac.of('S', moment, true);
    }

    public static Zodiac signPassedByMoon(Moment moment) {
        return Zodiac.of('L', moment, true);
    }

    public char getSymbol() {
        return this.symbol;
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray = LANG_TO_NAMES.get(locale.getLanguage());
        if (stringArray == null) {
            stringArray = LANG_TO_NAMES.get("");
        }
        return stringArray[this.ordinal()];
    }

    public Zodiac previous() {
        return Zodiac.values()[(this.ordinal() + 12) % 13];
    }

    public Zodiac next() {
        return Zodiac.values()[(this.ordinal() + 1) % 13];
    }

    private static Zodiac of(char c2, Moment moment, boolean bl2) {
        Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
        double d2 = JulianDay.ofEphemerisTime(moment2).getValue();
        double d3 = c2 == 'S' ? Zodiac.getSolarLongitude(d2) : Zodiac.getLunarLongitude(d2);
        for (Zodiac zodiac : Zodiac.values()) {
            double d4;
            double d5;
            Zodiac zodiac2 = zodiac.next();
            if (bl2) {
                if (zodiac == OPHIUCHUS) continue;
                if (zodiac2 == OPHIUCHUS) {
                    zodiac2 = SAGITTARIUS;
                }
                int n2 = zodiac.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
                int n3 = zodiac2.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
                d5 = (zodiac.ordinal() + n2) * 30;
                d4 = (zodiac2.ordinal() + n3) * 30;
            } else {
                d5 = Zodiac.toEclipticAngle(moment2, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
                d4 = Zodiac.toEclipticAngle(moment2, zodiac2.entry.getRightAscension(), zodiac2.entry.getDeclination());
            }
            if (d4 < d5) {
                d4 += 360.0;
                if (d3 < 180.0) {
                    d3 += 360.0;
                }
            }
            if (!(d3 >= d5) || !(d3 < d4)) continue;
            return zodiac;
        }
        throw new NoSuchElementException("Unable to determine zodiac.");
    }

    private static double getSolarLongitude(double d2) {
        return StdSolarCalculator.TIME4J.getFeature(d2, "solar-longitude");
    }

    private static double getLunarLongitude(double d2) {
        return StdSolarCalculator.TIME4J.getFeature(d2, "lunar-longitude");
    }

    private static double toEclipticAngle(Moment moment, double d2, double d3) {
        double d4 = JulianDay.ofSimplifiedTime(moment).getCenturyJ2000();
        double d5 = Math.toRadians(StdSolarCalculator.meanObliquity(d4));
        double d6 = (2306.2181 + (0.30188 + 0.017998 * d4) * d4) * d4 / 3600.0;
        double d7 = (2306.2181 + (1.09468 + 0.018203 * d4) * d4) * d4 / 3600.0;
        double d8 = (2004.3109 - (0.42665 + 0.041833 * d4) * d4) * d4 / 3600.0;
        double d9 = Math.toRadians(d2 + d6);
        double d10 = Math.cos(d9);
        double d11 = Math.cos(Math.toRadians(d8));
        double d12 = Math.sin(Math.toRadians(d8));
        double d13 = Math.cos(Math.toRadians(d3));
        double d14 = Math.sin(Math.toRadians(d3));
        double d15 = d13 * Math.sin(d9);
        double d16 = d11 * d13 * d10 - d12 * d14;
        double d17 = d12 * d13 * d10 + d11 * d14;
        double d18 = Math.toRadians(Math.toDegrees(Math.atan2(d15, d16)) + d7);
        double d19 = Math.asin(d17);
        double d20 = Math.toDegrees(Math.atan2(Math.sin(d18) * Math.cos(d5) + Math.tan(d19) * Math.sin(d5), Math.cos(d18)));
        if (d20 < 0.0) {
            d20 += 360.0;
        }
        return d20;
    }

    static {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("", new String[]{"Aries", "Taurus", "Gemini", "Cancer", "Leo", "Virgo", "Libra", "Scorpius", "Ophiuchus", "Sagittarius", "Capricornus", "Aquarius", "Pisces"});
        hashMap.put("da", new String[]{"V\u00e6dderen", "Tyren", "Tvillingerne", "Krebsen", "L\u00f8ven", "Jomfruen", "V\u00e6gten", "Skorpionen", "Slangeb\u00e6reren", "Skytten", "Stenbukken", "Vandmanden", "Fiskene"});
        hashMap.put("de", new String[]{"Widder", "Stier", "Zwillinge", "Krebs", "L\u00f6we", "Jungfrau", "Waage", "Skorpion", "Schlangentr\u00e4ger", "Sch\u00fctze", "Steinbock", "Wassermann", "Fische"});
        hashMap.put("en", new String[]{"Ram", "Bull", "Twins", "Crab", "Lion", "Maiden", "Scales", "Scorpion", "Serpent-bearer", "Archer", "Capricorn", "Water-bearer", "Fish"});
        hashMap.put("es", new String[]{"Aries", "Tauro", "G\u00e9minis", "C\u00e1ncer", "Leo", "Virgo", "Libra", "Escorpio", "Ofiuco", "Sagitario", "Capricornio", "Acuario", "Piscis"});
        hashMap.put("fr", new String[]{"B\u00e9lier", "Taureau", "G\u00e9meaux", "Cancer", "Lion", "Vierge", "Balance", "Scorpion", "Serpentaire", "Sagittaire", "Capricorne", "Verseau", "Poissons"});
        hashMap.put("it", new String[]{"Ariete", "Toro", "Gemelli", "Cancro", "Leone", "Vergine", "Bilancia", "Scorpione", "Ofiuco", "Sagittario", "Capricorno", "Acquario", "Pesci"});
        hashMap.put("nl", new String[]{"Ram", "Stier", "Tweelingen", "Kreeft", "Leeuw", "Maagd", "Weegschaal", "Schorpioen", "Slangendrager", "Schutter", "Steenbok", "Waterman", "Vissen"});
        hashMap.put("ru", new String[]{"\u041e\u0432\u0435\u043d", "\u0422\u0435\u043b\u0435\u0446", "\u0411\u043b\u0438\u0437\u043d\u0435\u0446\u044b", "\u0420\u0430\u043a", "\u041b\u0435\u0432", "\u0414\u0435\u0432\u0430", "\u0412\u0435\u0441\u044b", "\u0421\u043a\u043e\u0440\u043f\u0438\u043e\u043d", "\u0417\u043c\u0435\u0435\u043d\u043e\u0441\u0435\u0446", "\u0421\u0442\u0440\u0435\u043b\u0435\u0446", "\u041a\u043e\u0437\u0435\u0440\u043e\u0433", "\u0412\u043e\u0434\u043e\u043b\u0435\u0439", "\u0420\u044b\u0431\u044b"});
        hashMap.put("tr", new String[]{"Ko\u00e7", "Bo\u011fa", "\u0130kizler", "Yenge\u00e7", "Aslan", "Ba\u015fak", "Terazi", "Akrep", "Ophiuchus", "Yay", "O\u011flak", "Kova", "Bal\u0131k"});
        LANG_TO_NAMES = Collections.unmodifiableMap(hashMap);
    }

    public static class Event
    implements ChronoCondition<Moment> {
        private final char body;
        private final Zodiac zodiac;
        private final boolean horoscope;

        private Event(char c2, Zodiac zodiac, boolean bl2) {
            if (c2 != 'S' && c2 != 'L') {
                throw new IllegalArgumentException("Unsupported celestial body: " + c2);
            }
            if (zodiac == null) {
                throw new IllegalArgumentException("Celestial coordinates must be finite.");
            }
            if (bl2 && zodiac == OPHIUCHUS) {
                throw new IllegalArgumentException("Ophiuchus is not an astrological zodiac sign.");
            }
            this.body = c2;
            this.zodiac = zodiac;
            this.horoscope = bl2;
        }

        public Moment atMomentOfEntry(Moment moment) {
            Moment moment2 = this.atTime(moment, false, true);
            return this.atTime(moment2, false, false);
        }

        public Moment atMomentOfExit(Moment moment) {
            Moment moment2 = this.atTime(moment, true, true);
            return this.atTime(moment2, true, false);
        }

        @Override
        public boolean test(Moment moment) {
            double d2;
            double d3;
            double d4;
            Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
            double d5 = JulianDay.ofEphemerisTime(moment2).getValue();
            double d6 = d4 = this.body == 'S' ? Zodiac.getSolarLongitude(d5) : Zodiac.getLunarLongitude(d5);
            if (this.horoscope) {
                d3 = this.getHoroscopeLongitude(false);
                d2 = this.getHoroscopeLongitude(true);
            } else {
                Zodiac zodiac = this.zodiac;
                Zodiac zodiac2 = zodiac.next();
                d3 = Zodiac.toEclipticAngle(moment2, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
                d2 = Zodiac.toEclipticAngle(moment2, zodiac2.entry.getRightAscension(), zodiac2.entry.getDeclination());
            }
            if (d2 < d3) {
                d2 += 360.0;
                if (d4 < 180.0) {
                    d4 += 360.0;
                }
            }
            return d4 >= d3 && d4 < d2;
        }

        static Event ofSign(char c2, Zodiac zodiac) {
            return new Event(c2, zodiac, true);
        }

        static Event ofConstellation(char c2, Zodiac zodiac) {
            return new Event(c2, zodiac, false);
        }

        private Zodiac getZodiac(boolean bl2) {
            Zodiac zodiac = this.zodiac;
            if (bl2) {
                zodiac = zodiac.next();
            }
            if (this.horoscope && zodiac == OPHIUCHUS) {
                zodiac = SAGITTARIUS;
            }
            return zodiac;
        }

        private int getHoroscopeLongitude(boolean bl2) {
            Zodiac zodiac = this.getZodiac(bl2);
            int n2 = zodiac.compareTo(OPHIUCHUS) < 0 ? 0 : -1;
            return (zodiac.ordinal() + n2) * 30;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Moment atTime(Moment moment, boolean bl2, boolean bl3) {
            double d2;
            double d3;
            double d4;
            if (this.horoscope) {
                if (!bl3) return moment;
                d4 = this.getHoroscopeLongitude(bl2);
            } else {
                Zodiac zodiac = this.getZodiac(bl2);
                d4 = Zodiac.toEclipticAngle(moment, zodiac.entry.getRightAscension(), zodiac.entry.getDeclination());
            }
            double d5 = d3 = JulianDay.ofEphemerisTime(moment).getValue();
            if (this.body == 'S') {
                d2 = d4 - Zodiac.getSolarLongitude(d3);
                if (bl3) {
                    d2 = Event.modulo360(d2);
                }
                d5 += d2 * 365.242189 / 360.0;
            } else {
                d2 = d4 - Zodiac.getLunarLongitude(d3);
                if (bl3) {
                    d2 = Event.modulo360(d2);
                }
                d5 += d2 * 29.530588861 / 360.0;
            }
            d2 = Math.max(d3, d5 - 5.0);
            double d6 = d5 + 5.0;
            while (true) {
                double d7 = (d2 + d6) / 2.0;
                if (d6 - d2 < 1.0E-4) {
                    return (Moment)JulianDay.ofEphemerisTime(d7).toMoment().with(Moment.PRECISION, TimeUnit.SECONDS);
                }
                double d8 = (this.body == 'S' ? Zodiac.getSolarLongitude(d7) : Zodiac.getLunarLongitude(d7)) - d4;
                if (Event.modulo360(d8) < 180.0) {
                    d6 = d7;
                    continue;
                }
                d2 = d7;
            }
        }

        private static double modulo360(double d2) {
            return d2 - 360.0 * Math.floor(d2 / 360.0);
        }
    }
}

