/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import net.time4j.calendar.astro.EquatorialCoordinates;

final class SkyPosition
implements EquatorialCoordinates {
    private final double ra;
    private final double dec;

    SkyPosition(double d2, double d3) {
        if (Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3)) {
            throw new IllegalArgumentException("Not finite: " + d2 + "/" + d3);
        }
        this.ra = d2;
        this.dec = d3;
    }

    @Override
    public double getRightAscension() {
        return this.ra;
    }

    @Override
    public double getDeclination() {
        return this.dec;
    }

    public boolean equals(Object object) {
        if (object instanceof SkyPosition) {
            SkyPosition skyPosition = (SkyPosition)object;
            return this.ra == skyPosition.ra && this.dec == skyPosition.dec;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.ra) + 37 * Double.hashCode(this.dec);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RA/Dec=[");
        stringBuilder.append(this.ra);
        stringBuilder.append(',');
        stringBuilder.append(this.dec);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

