/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

class AstroUtils {
    AstroUtils() {
    }

    static double gmst(double d2) {
        double d3 = Math.floor(d2);
        double d4 = 86400.0 * (d2 - d3);
        double d5 = (d3 - 51544.5) / 36525.0;
        double d6 = (d2 - 51544.5) / 36525.0;
        double d7 = 24110.54841 + 8640184.812866 * d5 + 1.0027379093 * d4 + (0.093104 - 6.2E-6 * d6) * d6 * d6;
        double d8 = d7 / 86400.0;
        return (d8 - Math.floor(d8)) * 2.0 * Math.PI;
    }

    static double getRefraction(double d2) {
        return 1.02 / Math.tan(Math.toRadians(10.3 / (d2 + 5.11) + d2)) + 0.0019279;
    }

    static double refractionFactorOfStdAtmosphere(int n2) {
        double d2 = 1.0 - 0.0065 * (double)n2 / 288.15;
        return Math.pow(d2, 4.255);
    }

    static double toRange_0_360(double d2) {
        while (Double.compare(0.0, d2) > 0) {
            d2 += 360.0;
        }
        while (Double.compare(d2, 360.0) >= 0) {
            d2 -= 360.0;
        }
        return d2;
    }
}

