/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoException;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.Iso8601Format;

public final class Nengo
implements CalendarEra,
Serializable {
    private static final byte COURT_NORTHERN = 1;
    private static final byte COURT_STANDARD = 0;
    private static final byte COURT_SOUTHERN = -1;
    private static final String NEW_ERA_PROPERTY = "net.time4j.calendar.japanese.supplemental.era";
    private static final Nengo[] OFFICIAL_NENGOS;
    private static final Nengo[] NORTHERN_NENGOS;
    private static final Nengo NENGO_KENMU;
    private static final Nengo NENGO_OEI;
    private static final Map<String, Nengo> KANJI_TO_NENGO;
    private static final Map<String, Nengo> CHINESE_TO_NENGO;
    private static final TST KOREAN_TO_NENGO;
    private static final TST RUSSIAN_TO_NENGO;
    private static final TST ROMAJI_TO_NENGO;
    public static final Nengo MEIJI;
    public static final Nengo TAISHO;
    public static final Nengo SHOWA;
    public static final Nengo HEISEI;
    public static final Nengo REIWA;
    public static final Nengo NEWEST;
    public static final AttributeKey<Selector> SELECTOR;
    private static final String[] MODERN_KEYS;
    private static final Nengo[] MODERN_NENGOS;
    private static final long serialVersionUID = 5696395761628504723L;
    private final transient int relgregyear;
    private final transient long start;
    private final transient String kanji;
    private final transient String chinese;
    private final transient String korean;
    private final transient String russian;
    private final transient String romaji;
    private final byte court;
    private final int index;

    private Nengo(int n2, long l2, String string, String string2, String string3, String string4, String string5, byte by2, int n3) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing kanji.");
        }
        if (string5.isEmpty()) {
            throw new IllegalArgumentException("Missing latin transcription.");
        }
        if (by2 > 1 || by2 < -1) {
            throw new IllegalArgumentException("Undefined court byte: " + by2);
        }
        this.relgregyear = n2;
        this.start = l2;
        this.kanji = string;
        this.chinese = string2;
        this.korean = string3;
        this.russian = string4;
        this.romaji = string5;
        this.court = by2;
        this.index = n3;
    }

    public static Nengo ofRelatedGregorianYear(int n2) {
        return Nengo.ofRelatedGregorianYear(n2, Selector.OFFICIAL);
    }

    public static Nengo ofRelatedGregorianYear(int n2, Selector selector) {
        Nengo nengo = null;
        if (n2 >= 701) {
            block0 : switch (selector) {
                case OFFICIAL: {
                    if (n2 >= 1873) {
                        return Nengo.ofRelatedGregorianYear(n2, Selector.MODERN);
                    }
                    int n3 = 0;
                    int n4 = OFFICIAL_NENGOS.length - 1;
                    while (n3 <= n4) {
                        int n5 = n3 + n4 >> 1;
                        if (OFFICIAL_NENGOS[n5].getFirstRelatedGregorianYear() <= n2) {
                            n3 = n5 + 1;
                            continue;
                        }
                        n4 = n5 - 1;
                    }
                    if (n3 == 0) break;
                    return OFFICIAL_NENGOS[n3 - 1];
                }
                case MODERN: {
                    int n6 = Nengo.getLowerBound(selector);
                    for (int i2 = OFFICIAL_NENGOS.length - 1; i2 >= n6; --i2) {
                        Nengo nengo2 = OFFICIAL_NENGOS[i2];
                        if (nengo2.relgregyear > n2) continue;
                        nengo = nengo2;
                        break block0;
                    }
                    break;
                }
                case NORTHERN_COURT: {
                    if (n2 < 1332 || n2 > 1394) break;
                    for (int i3 = NORTHERN_NENGOS.length - 1; i3 >= 0; --i3) {
                        Nengo nengo3 = NORTHERN_NENGOS[i3];
                        if (nengo3.relgregyear > n2) continue;
                        nengo = nengo3;
                        break block0;
                    }
                    break;
                }
                case SOUTHERN_COURT: {
                    if (n2 < 1334 || n2 > 1393) break;
                    int n7 = Nengo.NENGO_OEI.index - 1;
                    while (Nengo.OFFICIAL_NENGOS[n7].court == -1) {
                        Nengo nengo4 = OFFICIAL_NENGOS[n7];
                        if (nengo4.relgregyear <= n2) {
                            nengo = nengo4;
                            break block0;
                        }
                        --n7;
                    }
                    break;
                }
                default: {
                    int n8 = Nengo.getLowerBound(selector);
                    int n9 = Nengo.getUpperBound(selector);
                    if (n2 < Nengo.OFFICIAL_NENGOS[n8].relgregyear || n2 > Nengo.OFFICIAL_NENGOS[n9 + 1].relgregyear) break;
                    for (int i4 = n9; i4 >= n8; --i4) {
                        Nengo nengo5 = OFFICIAL_NENGOS[i4];
                        if (nengo5.relgregyear > n2) continue;
                        nengo = nengo5;
                        break block0;
                    }
                }
            }
        }
        if (nengo == null) {
            throw new IllegalArgumentException("Could not find nengo for year=" + n2 + ", selector=" + selector + ".");
        }
        return nengo;
    }

    public static Nengo ofKanji(String string) {
        Nengo nengo = KANJI_TO_NENGO.get(string);
        if (nengo == null) {
            throw new IllegalArgumentException("Could not find any nengo for Japanese kanji: " + string);
        }
        return nengo;
    }

    public static List<Nengo> parseRomaji(String string) {
        String string2 = Nengo.hepburn(string, 0);
        String string3 = ROMAJI_TO_NENGO.longestPrefixOf(string2, 0);
        return ROMAJI_TO_NENGO.find(string3);
    }

    public static Stream<Nengo> stream() {
        return Nengo.stream(Selector.OFFICIAL);
    }

    public static Stream<Nengo> stream(Selector selector) {
        switch (selector) {
            case NORTHERN_COURT: {
                return Arrays.stream(NORTHERN_NENGOS);
            }
        }
        int n2 = Nengo.getLowerBound(selector);
        int n3 = Nengo.getUpperBound(selector);
        return Arrays.stream(OFFICIAL_NENGOS, n2, n3 + 1);
    }

    public static List<Nengo> list() {
        return Nengo.list(Selector.OFFICIAL);
    }

    public static List<Nengo> list(Selector selector) {
        List<Nengo> list;
        switch (selector) {
            case OFFICIAL: {
                list = Arrays.asList(OFFICIAL_NENGOS);
                break;
            }
            case NORTHERN_COURT: {
                list = Arrays.asList(NORTHERN_NENGOS);
                break;
            }
            default: {
                int n2 = Nengo.getLowerBound(selector);
                int n3 = Nengo.getUpperBound(selector);
                list = new ArrayList<Nengo>(n3 - n2 + 1);
                for (int i2 = n2; i2 <= n3; ++i2) {
                    list.add(OFFICIAL_NENGOS[i2]);
                }
            }
        }
        return Collections.unmodifiableList(list);
    }

    public boolean matches(Selector selector) {
        return selector.test(this);
    }

    public int getFirstRelatedGregorianYear() {
        return this.relgregyear;
    }

    public PlainDate getStart() {
        return PlainDate.of(this.start, EpochDays.UTC);
    }

    public boolean isModern() {
        return this.index >= Nengo.MEIJI.index;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        if (locale.getLanguage().isEmpty()) {
            return this.romaji;
        }
        if (this.index >= Nengo.MEIJI.index && this.index <= Nengo.NEWEST.index && !locale.getLanguage().equals("ru")) {
            String string = null;
            for (int i2 = 0; i2 < MODERN_NENGOS.length; ++i2) {
                if (!this.equals(MODERN_NENGOS[i2])) continue;
                string = MODERN_KEYS[i2];
                break;
            }
            if (string == null) {
                throw new IllegalStateException("Modern nengos need an update.");
            }
            if (textWidth == TextWidth.NARROW) {
                string = string + "_n";
            }
            Map<String, String> map = CalendarText.getInstance("japanese", locale).getTextForms();
            return map.get(string);
        }
        switch (locale.getLanguage()) {
            case "ja": {
                return this.kanji;
            }
            case "zh": {
                return this.chinese;
            }
            case "ko": {
                return this.korean;
            }
            case "ru": {
                return "\u041f\u0435\u0440\u0438\u043e\u0434 " + this.russian;
            }
        }
        return this.romaji;
    }

    public Optional<Nengo> findNext() {
        if (this.court == 1) {
            if (this.index == NORTHERN_NENGOS.length - 1) {
                return Optional.of(NENGO_OEI);
            }
            return Optional.of(NORTHERN_NENGOS[this.index + 1]);
        }
        if (this.index == OFFICIAL_NENGOS.length - 1) {
            return Optional.empty();
        }
        return Optional.of(OFFICIAL_NENGOS[this.index + 1]);
    }

    public Optional<Nengo> findPrevious() {
        if (this.court == 1) {
            if (this.index == 0) {
                return Optional.of(OFFICIAL_NENGOS[Nengo.NENGO_KENMU.index - 1]);
            }
            return Optional.of(NORTHERN_NENGOS[this.index - 1]);
        }
        if (this.index == 0) {
            return Optional.empty();
        }
        return Optional.of(OFFICIAL_NENGOS[this.index - 1]);
    }

    @Override
    public String name() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.romaji);
        stringBuilder.append(" (");
        Optional<Nengo> optional = this.findNext();
        if (optional.isPresent()) {
            stringBuilder.append(this.relgregyear);
            stringBuilder.append('-');
            stringBuilder.append(optional.get().relgregyear);
        } else {
            stringBuilder.append("since ");
            stringBuilder.append(this.relgregyear);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Nengo) {
            Nengo nengo = (Nengo)object;
            return this.relgregyear == nengo.relgregyear && this.start == nengo.start && this.kanji.equals(nengo.kanji) && this.romaji.equals(nengo.romaji) && this.court == nengo.court;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.start ^ this.start >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.romaji);
        stringBuilder.append(' ');
        stringBuilder.append(this.kanji);
        stringBuilder.append(' ');
        Optional<Nengo> optional = this.findNext();
        if (optional.isPresent()) {
            stringBuilder.append(this.relgregyear);
            stringBuilder.append('-');
            stringBuilder.append(optional.get().relgregyear);
        } else {
            stringBuilder.append("since ");
            stringBuilder.append(this.relgregyear);
        }
        if (this.court != 0) {
            stringBuilder.append(" (");
            stringBuilder.append(this.court == 1 ? (char)'N' : 'S');
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    int getValue() {
        if (this.matches(Selector.NORTHERN_COURT)) {
            return this.index - NORTHERN_NENGOS.length + Nengo.NENGO_OEI.index - Nengo.SHOWA.index + 1;
        }
        return this.index - Nengo.SHOWA.index + 1;
    }

    long getStartAsDaysSinceEpochUTC() {
        return this.start;
    }

    int getIndexOfficial() {
        return this.index;
    }

    static Nengo ofIndexOfficial(int n2) {
        return OFFICIAL_NENGOS[n2];
    }

    static String hepburn(CharSequence charSequence, int n2) {
        StringBuilder stringBuilder = null;
        int n3 = Math.min(charSequence.length(), n2 + 32);
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2;
            char c3 = charSequence.charAt(i2);
            if (i2 == n2) {
                c2 = c3 == '\u00d4' || c3 == '\u00f4' || c3 == '\u014d' ? (char)'\u014c' : (char)Character.toUpperCase(c3);
                c2 = c3 == '\u00db' || c3 == '\u00fb' || c3 == '\u016b' ? (char)'\u016a' : c2;
            } else {
                c2 = c3 == '\u00d4' || c3 == '\u00f4' || c3 == '\u014c' ? (char)'\u014d' : (char)Character.toLowerCase(c3);
                c2 = c3 == '\u00db' || c3 == '\u00fb' || c3 == '\u016a' ? (char)'\u016b' : c2;
            }
            c2 = c3 == '\'' ? (char)'\u2019' : c2;
            char c4 = c2 = c3 == ' ' ? (char)'-' : c2;
            if (stringBuilder == null && c2 == c3) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                stringBuilder.append(charSequence.subSequence(n2, i2));
            }
            stringBuilder.append(c2);
        }
        return stringBuilder == null ? charSequence.subSequence(n2, n3).toString() : stringBuilder.toString();
    }

    private static String capitalize(CharSequence charSequence, int n2) {
        StringBuilder stringBuilder = null;
        int n3 = Math.min(charSequence.length(), n2 + 32);
        boolean bl2 = true;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            char c3 = bl2 ? Character.toUpperCase(c2) : Character.toLowerCase(c2);
            boolean bl3 = bl2 = c2 == ' ';
            if (stringBuilder == null && c3 == c2) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                stringBuilder.append(charSequence.subSequence(n2, i2));
            }
            stringBuilder.append(c3);
        }
        return stringBuilder == null ? charSequence.subSequence(n2, n3).toString() : stringBuilder.toString();
    }

    private static int getUpperBound(Selector selector) {
        switch (selector) {
            case EDO_PERIOD: {
                return Nengo.MEIJI.index - 1;
            }
            case AZUCHI_MOMOYAMA_PERIOD: {
                return 187;
            }
            case MUROMACHI_PERIOD: {
                return 184;
            }
            case NORTHERN_COURT: {
                return NORTHERN_NENGOS.length - 1;
            }
            case SOUTHERN_COURT: {
                return Nengo.NENGO_KENMU.index + 8;
            }
            case KAMAKURA_PERIOD: {
                return Nengo.NENGO_KENMU.index - 1;
            }
            case HEIAN_PERIOD: {
                return 102;
            }
            case NARA_PERIOD: {
                return 14;
            }
            case ASUKA_PERIOD: {
                return 2;
            }
        }
        return OFFICIAL_NENGOS.length - 1;
    }

    private static int getLowerBound(Selector selector) {
        switch (selector) {
            case MODERN: {
                return Nengo.MEIJI.index;
            }
            case EDO_PERIOD: {
                return 188;
            }
            case AZUCHI_MOMOYAMA_PERIOD: {
                return 185;
            }
            case MUROMACHI_PERIOD: {
                return Nengo.NENGO_KENMU.index + 1;
            }
            case SOUTHERN_COURT: {
                return Nengo.NENGO_KENMU.index;
            }
            case KAMAKURA_PERIOD: {
                return 103;
            }
            case HEIAN_PERIOD: {
                return 15;
            }
            case NARA_PERIOD: {
                return 3;
            }
        }
        return 0;
    }

    private static Nengo of(int n2, boolean bl2) {
        return bl2 ? NORTHERN_NENGOS[n2] : OFFICIAL_NENGOS[n2];
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return Nengo.of(this.index, this.court == 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException();
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        var0 = new ArrayList<Object>(256);
        var1_1 = new ArrayList<Object>(16);
        var2_2 = null;
        var3_3 = null;
        var4_4 = new HashMap<String, Object>();
        var5_5 = new HashMap<String, Object>();
        var6_6 = new TST();
        var7_7 = new TST();
        var8_8 = new TST();
        var9_9 = "data/nengo.data";
        var10_10 = ResourceLoader.getInstance().locate("base", Nengo.class, var9_9);
        var11_11 = ResourceLoader.getInstance().load(var10_10, true);
        try {
            if (var11_11 == null) {
                var11_11 = ResourceLoader.getInstance().load(Nengo.class, var9_9, true);
            }
            var12_12 = new DataInputStream(var11_11);
            block21: while (true) {
                var13_16 = var12_12.readShort();
                var14_18 = var12_12.readInt();
                var15_20 = var12_12.readUTF();
                var16_22 = var12_12.readUTF();
                var17_24 = var12_12.readUTF();
                var18_26 = var12_12.readUTF();
                var19_28 = var12_12.readByte();
                var20_30 = var12_12.readByte();
                var21_32 = new ArrayList<String>(var20_30);
                for (var22_36 = 0; var22_36 < var20_30; ++var22_36) {
                    var23_38 = var12_12.readUTF();
                    var21_32.add((String)var23_38);
                }
                var22_35 = (String)var21_32.get(0);
                if (var19_28 == 1) {
                    var23_38 = new Nengo(var13_16, var14_18, var15_20, var16_22, var17_24, var18_26, var22_35, var19_28, var1_1.size());
                    var1_1.add(var23_38);
                } else {
                    var23_38 = new Nengo(var13_16, var14_18, var15_20, var16_22, var17_24, var18_26, var22_35, var19_28, var0.size());
                    var0.add(var23_38);
                    if (var13_16 == 1334) {
                        var2_2 = var23_38;
                    } else if (var13_16 == 1394) {
                        var3_3 = var23_38;
                    }
                }
                if (var23_38.court == 1 && var23_38.relgregyear == 1334) continue;
                var4_4.put(var15_20, var23_38);
                if (var5_5.put(var16_22, var23_38) != null) {
                    throw new IllegalStateException(var23_38.relgregyear + " " + var23_38.chinese);
                }
                var6_6.insert(var17_24, (Nengo)var23_38);
                var7_7.insert(var18_26, (Nengo)var23_38);
                var24_40 = var21_32.iterator();
                while (true) {
                    if (var24_40.hasNext()) ** break;
                    continue block21;
                    var25_42 = (String)var24_40.next();
                    var8_8.insert(var25_42, (Nengo)var23_38);
                }
                break;
            }
        }
        catch (EOFException var12_13) {
        }
        catch (IOException var12_14) {
            throw new IllegalStateException("Invalid nengo data.", var12_14);
        }
        var12_15 = System.getProperty("net.time4j.calendar.japanese.supplemental.era");
        if (var12_15 != null) {
            var13_17 = var12_15.split(",");
            var14_19 = null;
            var15_21 = null;
            var16_23 = null;
            var17_25 = null;
            var18_27 = null;
            var19_29 = null;
            block24: for (String var23_39 : var13_17) {
                var24_41 = var23_39.split("=");
                if (var24_41.length != 2) continue;
                var25_43 = var24_41[0];
                var26_44 = -1;
                switch (var25_43.hashCode()) {
                    case 3373707: {
                        if (!var25_43.equals("name")) break;
                        var26_44 = 0;
                        break;
                    }
                    case 101815575: {
                        if (!var25_43.equals("kanji")) break;
                        var26_44 = 1;
                        break;
                    }
                    case 746330349: {
                        if (!var25_43.equals("chinese")) break;
                        var26_44 = 2;
                        break;
                    }
                    case -1125640956: {
                        if (!var25_43.equals("korean")) break;
                        var26_44 = 3;
                        break;
                    }
                    case 1555550099: {
                        if (!var25_43.equals("russian")) break;
                        var26_44 = 4;
                        break;
                    }
                    case 109441850: {
                        if (!var25_43.equals("since")) break;
                        var26_44 = 5;
                    }
                }
                switch (var26_44) {
                    case 0: {
                        var14_19 = Nengo.hepburn(var24_41[1], 0);
                        continue block24;
                    }
                    case 1: {
                        var15_21 = var24_41[1];
                        if (var15_21.length() == 2) continue block24;
                        throw new IllegalArgumentException("Japanese kanji must be of length 2.");
                    }
                    case 2: {
                        var16_23 = var24_41[1];
                        if (var16_23.length() == 2) continue block24;
                        throw new IllegalArgumentException("Chinese kanji must be of length 2.");
                    }
                    case 3: {
                        var17_25 = var24_41[1];
                        continue block24;
                    }
                    case 4: {
                        var18_27 = Nengo.capitalize(var24_41[1], 0);
                        continue block24;
                    }
                    case 5: {
                        try {
                            var19_29 = Iso8601Format.parseDate(var24_41[1]);
                            continue block24;
                        }
                        catch (ParseException var27_45) {
                            // empty catch block
                        }
                    }
                }
            }
            if (var14_19 != null && var15_21 != null && var19_29 != null) {
                var20_31 = (Nengo)var0.get(var0.size() - 1);
                if (var19_29.isBeforeOrEqual(var20_31.getStart())) {
                    throw new IllegalStateException("New Japanese era must be after last defined nengo: " + var20_31.romaji);
                }
                if (var16_23 == null) {
                    var16_23 = var15_21;
                }
                if (var17_25 == null) {
                    var17_25 = var14_19;
                }
                if (var18_27 == null) {
                    var18_27 = var14_19;
                }
                var21_34 = new Nengo(var19_29.getYear(), var19_29.getDaysSinceEpochUTC(), var15_21, var16_23, var17_25, var18_27, var14_19, 0, var0.size());
                var0.add(var21_34);
                var4_4.put(var15_21, var21_34);
                var5_5.put(var16_23, var21_34);
                var6_6.insert(var17_25, var21_34);
                var7_7.insert(var18_27, var21_34);
                var8_8.insert(var14_19, var21_34);
            } else {
                throw new IllegalStateException("Invalid syntax: " + var12_15);
            }
        }
        Nengo.OFFICIAL_NENGOS = var0.toArray(new Nengo[var0.size()]);
        Nengo.NORTHERN_NENGOS = var1_1.toArray(new Nengo[var1_1.size()]);
        Nengo.NENGO_KENMU = var2_2;
        Nengo.NENGO_OEI = var3_3;
        Nengo.KANJI_TO_NENGO = Collections.unmodifiableMap(var4_4);
        Nengo.CHINESE_TO_NENGO = Collections.unmodifiableMap(var5_5);
        Nengo.KOREAN_TO_NENGO = var6_6;
        Nengo.RUSSIAN_TO_NENGO = var7_7;
        Nengo.ROMAJI_TO_NENGO = var8_8;
        Nengo.MEIJI = Nengo.OFFICIAL_NENGOS[223];
        Nengo.TAISHO = Nengo.OFFICIAL_NENGOS[224];
        Nengo.SHOWA = Nengo.OFFICIAL_NENGOS[225];
        Nengo.HEISEI = Nengo.OFFICIAL_NENGOS[226];
        Nengo.REIWA = Nengo.OFFICIAL_NENGOS[227];
        Nengo.NEWEST = Nengo.OFFICIAL_NENGOS[Nengo.OFFICIAL_NENGOS.length - 1];
        Nengo.SELECTOR = Attributes.createKey("NENGO_SELECTOR", Selector.class);
        Nengo.MODERN_KEYS = new String[]{"reiwa", "heisei", "showa", "taisho", "meiji"};
        Nengo.MODERN_NENGOS = new Nengo[]{Nengo.REIWA, Nengo.HEISEI, Nengo.SHOWA, Nengo.TAISHO, Nengo.MEIJI};
    }

    private static class TST {
        private Node root = null;

        private TST() {
        }

        List<Nengo> find(String string) {
            if (string == null || string.length() == 0) {
                return Collections.emptyList();
            }
            Node node = TST.find(this.root, string, 0);
            if (node == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(node.nengos);
        }

        private static Node find(Node node, String string, int n2) {
            if (node == null) {
                return null;
            }
            char c2 = string.charAt(n2);
            if (c2 < node.c) {
                return TST.find(node.left, string, n2);
            }
            if (c2 > node.c) {
                return TST.find(node.right, string, n2);
            }
            if (n2 < string.length() - 1) {
                return TST.find(node.mid, string, n2 + 1);
            }
            return node;
        }

        void insert(String string, Nengo nengo) {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Empty key cannot be inserted.");
            }
            this.root = TST.insert(this.root, string, nengo, 0);
        }

        private static Node insert(Node node, String string, Nengo nengo, int n2) {
            char c2 = string.charAt(n2);
            if (node == null) {
                node = new Node();
                node.c = c2;
            }
            if (c2 < node.c) {
                node.left = TST.insert(node.left, string, nengo, n2);
            } else if (c2 > node.c) {
                node.right = TST.insert(node.right, string, nengo, n2);
            } else if (n2 < string.length() - 1) {
                node.mid = TST.insert(node.mid, string, nengo, n2 + 1);
            } else {
                if (node.nengos == null) {
                    node.nengos = new ArrayList();
                }
                node.nengos.add(nengo);
            }
            return node;
        }

        String longestPrefixOf(CharSequence charSequence, int n2) {
            int n3 = n2;
            Node node = this.root;
            int n4 = n2;
            int n5 = charSequence.length();
            while (node != null && n4 < n5) {
                char c2 = charSequence.charAt(n4);
                if (c2 < node.c) {
                    node = node.left;
                    continue;
                }
                if (c2 > node.c) {
                    node = node.right;
                    continue;
                }
                ++n4;
                if (node.nengos != null) {
                    n3 = n4;
                }
                node = node.mid;
            }
            return n2 >= n3 ? null : charSequence.subSequence(n2, n3).toString();
        }
    }

    public static enum Selector implements ChronoCondition<Nengo>
    {
        OFFICIAL{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.court != 1;
            }
        }
        ,
        MODERN{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.index >= MEIJI.index;
            }
        }
        ,
        EDO_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1603 && nengo.relgregyear < 1868;
            }
        }
        ,
        AZUCHI_MOMOYAMA_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1573 && nengo.relgregyear < 1603;
            }
        }
        ,
        MUROMACHI_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1336 && nengo.relgregyear < 1573 && nengo.court != 1;
            }
        }
        ,
        NORTHERN_COURT{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.court == 1;
            }
        }
        ,
        SOUTHERN_COURT{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.court == -1;
            }
        }
        ,
        KAMAKURA_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 1185 && nengo.relgregyear < 1332;
            }
        }
        ,
        HEIAN_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 794 && nengo.relgregyear < 1185;
            }
        }
        ,
        NARA_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 710 && nengo.relgregyear < 794;
            }
        }
        ,
        ASUKA_PERIOD{

            @Override
            public boolean test(Nengo nengo) {
                return nengo.relgregyear >= 538 && nengo.relgregyear < 710;
            }
        };

    }

    private static class Node {
        private char c = '\u0000';
        private Node left = null;
        private Node mid = null;
        private Node right = null;
        private List<Nengo> nengos = null;

        private Node() {
        }
    }

    static class Element
    implements TextElement<Nengo>,
    Serializable {
        static final Element SINGLETON = new Element();
        private static final long serialVersionUID = -1099321098836107792L;

        private Element() {
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            appendable.append(chronoDisplay.get(this).getDisplayName(locale, textWidth));
        }

        @Override
        public Nengo parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n2;
            Object object;
            List<Nengo> list;
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            Map<String, String> map = CalendarText.getInstance("japanese", locale).getTextForms();
            int n3 = parsePosition.getIndex();
            if (n3 >= charSequence.length()) {
                parsePosition.setErrorIndex(n3);
                return null;
            }
            String string = locale.getLanguage().equals("ru") ? Nengo.capitalize(charSequence, n3) : Nengo.hepburn(charSequence, n3);
            Nengo nengo3 = null;
            int n4 = 0;
            for (int i2 = 0; i2 < MODERN_KEYS.length; ++i2) {
                String string2 = MODERN_KEYS[i2];
                if (textWidth == TextWidth.NARROW) {
                    string2 = string2 + "_n";
                }
                if (!string.startsWith((String)((Object)(list = map.get(string2))))) continue;
                nengo3 = MODERN_NENGOS[i2];
                n4 = ((String)((Object)list)).length();
                if (textWidth == TextWidth.NARROW || nengo3 == SHOWA) break;
                parsePosition.setIndex(n3 + n4);
                return nengo3;
            }
            if (string.length() < 2) {
                if (nengo3 != null) {
                    parsePosition.setIndex(n3 + 1);
                }
                return nengo3;
            }
            String string3 = null;
            int n5 = 0;
            list = Collections.emptyList();
            switch (locale.getLanguage()) {
                case "ja": {
                    int n6 = string.length() >= 4 ? 4 : 2;
                    object = string.substring(0, n6);
                    Nengo nengo4 = (Nengo)KANJI_TO_NENGO.get(object);
                    if (nengo4 == null && n6 == 4) {
                        object = string.substring(0, 2);
                        nengo4 = (Nengo)KANJI_TO_NENGO.get(object);
                    }
                    if (nengo4 == null) break;
                    string3 = object;
                    if (nengo4 == nengo3) {
                        nengo3 = null;
                    }
                    list = Collections.singletonList(nengo4);
                    break;
                }
                case "zh": {
                    int n6 = string.length() >= 4 ? 4 : 2;
                    object = string.substring(0, n6);
                    Nengo nengo5 = (Nengo)CHINESE_TO_NENGO.get(object);
                    if (nengo5 == null && n6 == 4) {
                        object = string.substring(0, 2);
                        nengo5 = (Nengo)CHINESE_TO_NENGO.get(object);
                    }
                    if (nengo5 == null) break;
                    string3 = object;
                    if (nengo5 == nengo3) {
                        nengo3 = null;
                    }
                    list = Collections.singletonList(nengo5);
                    break;
                }
                case "ko": {
                    string3 = KOREAN_TO_NENGO.longestPrefixOf(string, n3);
                    list = KOREAN_TO_NENGO.find(string3);
                    break;
                }
                case "ru": {
                    if (string.startsWith("\u041f\u0435\u0440\u0438\u043e\u0434 ")) {
                        string = string.substring(7);
                        n5 = 7;
                    }
                    string3 = RUSSIAN_TO_NENGO.longestPrefixOf(string, n3);
                    list = RUSSIAN_TO_NENGO.find(string3);
                    break;
                }
                default: {
                    string3 = ROMAJI_TO_NENGO.longestPrefixOf(string, n3);
                    list = ROMAJI_TO_NENGO.find(string3);
                }
            }
            if ((n2 = list.size()) == 0 || string3 == null) {
                if (nengo3 == null) {
                    return null;
                }
                parsePosition.setIndex(n3 + n4);
                return nengo3;
            }
            int n7 = string3.length() + n5;
            if (n4 < n7) {
                nengo3 = null;
            } else if (n4 > n7) {
                parsePosition.setIndex(n3 + n4);
                return nengo3;
            }
            assert (nengo3 == null || nengo3 == SHOWA);
            if (n2 == 1) {
                Nengo nengo6 = list.get(0);
                if (nengo3 == null || nengo6 == nengo3) {
                    parsePosition.setIndex(n3 + n7);
                    return nengo6;
                }
            }
            Selector selector = attributeQuery.get(SELECTOR, Selector.OFFICIAL);
            object = new ArrayList<Nengo>(list);
            if (nengo3 != null && !object.contains(nengo3)) {
                object.add(nengo3);
            }
            object.sort((nengo, nengo2) -> ((Nengo)nengo).start < ((Nengo)nengo2).start ? 1 : (((Nengo)nengo).start == ((Nengo)nengo2).start ? 0 : -1));
            object.removeIf(nengo -> !nengo.matches(selector));
            if (object.size() == 1) {
                parsePosition.setIndex(n3 + n7);
                return (Nengo)object.get(0);
            }
            if (object.size() > 1 && !attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isStrict()) {
                parsePosition.setIndex(n3 + n7);
                return (Nengo)object.get(0);
            }
            return null;
        }

        @Override
        public String name() {
            return "ERA";
        }

        @Override
        public Class<Nengo> getType() {
            return Nengo.class;
        }

        @Override
        public char getSymbol() {
            return 'G';
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            Nengo nengo = chronoDisplay.get(this);
            Nengo nengo2 = chronoDisplay2.get(this);
            if (nengo.start < nengo2.start) {
                return -1;
            }
            if (nengo.start > nengo2.start) {
                return 1;
            }
            if (nengo.court == 1) {
                return nengo2.court == 1 ? 0 : 1;
            }
            return nengo2.court == 1 ? -1 : 0;
        }

        @Override
        public Nengo getDefaultMinimum() {
            return OFFICIAL_NENGOS[0];
        }

        @Override
        public Nengo getDefaultMaximum() {
            return OFFICIAL_NENGOS[OFFICIAL_NENGOS.length - 1];
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        @Override
        public String getDisplayName(Locale locale) {
            String string = "L_era";
            String string2 = CalendarText.getIsoInstance(locale).getTextForms().get(string);
            return string2 == null ? this.name() : string2;
        }

        private Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }
    }
}

