/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.PlainDate;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HebrewMonth;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoFunction;

public enum HebrewAnniversary {
    BIRTHDAY{

        @Override
        public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n2) {
            return calendarDate -> {
                HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
                int n3 = hebrewCalendar.getDayOfMonth();
                if (hebrewCalendar.getMonth() == HebrewMonth.ADAR_II) {
                    return HebrewCalendar.ofBiblical(n2, HebrewCalendar.isLeapYear(n2) ? 13 : 12, n3);
                }
                HebrewMonth hebrewMonth = hebrewCalendar.getMonth();
                if (hebrewMonth == HebrewMonth.ADAR_I && !HebrewCalendar.isLeapYear(n2)) {
                    hebrewMonth = HebrewMonth.ADAR_II;
                }
                if (n3 <= 29) {
                    return HebrewCalendar.of(n2, hebrewMonth, n3);
                }
                return (HebrewCalendar)HebrewCalendar.of(n2, hebrewMonth, 1).plus(CalendarDays.of(n3 - 1));
            };
        }
    }
    ,
    YAHRZEIT{

        @Override
        public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n2) {
            return calendarDate -> {
                HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
                int n3 = hebrewCalendar.getYear();
                HebrewMonth hebrewMonth = hebrewCalendar.getMonth();
                int n4 = hebrewCalendar.getDayOfMonth();
                if (hebrewMonth == HebrewMonth.HESHVAN && n4 == 30 && HebrewCalendar.lengthOfMonth(n3 + 1, HebrewMonth.HESHVAN) == 29) {
                    return (HebrewCalendar)HebrewCalendar.of(n2, HebrewMonth.KISLEV, 1).minus(CalendarDays.ONE);
                }
                if (hebrewMonth == HebrewMonth.KISLEV && n4 == 30 && HebrewCalendar.lengthOfMonth(n3 + 1, HebrewMonth.KISLEV) == 29) {
                    return (HebrewCalendar)HebrewCalendar.of(n2, HebrewMonth.TEVET, 1).minus(CalendarDays.ONE);
                }
                if (hebrewMonth == HebrewMonth.ADAR_II && HebrewCalendar.isLeapYear(n3)) {
                    return HebrewCalendar.of(n2, HebrewMonth.ADAR_II, n4);
                }
                if (hebrewMonth.getBiblicalValue(false) == 12 && n4 == 30 && !HebrewCalendar.isLeapYear(n2)) {
                    return HebrewCalendar.of(n2, HebrewMonth.SHEVAT, 30);
                }
                return (HebrewCalendar)HebrewCalendar.ofBiblical(n2, hebrewMonth.getBiblicalValue(false), 1).plus(CalendarDays.of(n4 - 1));
            };
        }
    };


    public ChronoFunction<CalendarDate, HebrewCalendar> inHebrewYear(int n2) {
        throw new AbstractMethodError();
    }

    public ChronoFunction<CalendarDate, List<PlainDate>> inGregorianYear(int n2) {
        return calendarDate -> {
            HebrewCalendar hebrewCalendar = HebrewAnniversary.convert(calendarDate);
            int n3 = ((HebrewCalendar)PlainDate.of(n2, 1, 1).transform(HebrewCalendar.axis())).getYear();
            PlainDate plainDate = (PlainDate)this.inHebrewYear(n3).apply(hebrewCalendar).transform(PlainDate.axis());
            PlainDate plainDate2 = (PlainDate)this.inHebrewYear(n3 + 1).apply(hebrewCalendar).transform(PlainDate.axis());
            ArrayList<PlainDate> arrayList = new ArrayList<PlainDate>(2);
            if (plainDate.getYear() == n2) {
                arrayList.add(plainDate);
            }
            if (plainDate2.getYear() == n2) {
                arrayList.add(plainDate2);
            }
            return Collections.unmodifiableList(arrayList);
        };
    }

    private static HebrewCalendar convert(CalendarDate calendarDate) {
        return calendarDate instanceof HebrewCalendar ? (HebrewCalendar)calendarDate : (HebrewCalendar)calendarDate.transform(HebrewCalendar.axis());
    }
}

