/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.SolarTerm;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPhase;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.EpochDays;
import net.time4j.tz.ZonalOffset;

abstract class EastAsianCS<D extends EastAsianCalendar<?, D>>
implements CalendarSystem<D> {
    private static final long CALENDAR_REFORM_1645 = PlainDate.of(1645, 1, 28).getDaysSinceEpochUTC();
    private static final long MAX_LIMIT = PlainDate.of(3000, 1, 27).getDaysSinceEpochUTC();
    private static final long EPOCH_CHINESE = PlainDate.of(-2636, 2, 15).getDaysSinceEpochUTC();
    static final double MEAN_SYNODIC_MONTH = 29.530588861;
    static final double MEAN_TROPICAL_YEAR = 365.242189;

    EastAsianCS() {
    }

    @Override
    public final D transform(long l2) {
        int n2;
        long l3 = this.winterOnOrBefore(l2);
        long l4 = this.winterOnOrBefore(l3 + 370L);
        long l5 = this.newMoonOnOrAfter(l3 + 1L);
        long l6 = this.newMoonBefore(l4 + 1L);
        long l7 = this.newMoonBefore(l2 + 1L);
        boolean bl2 = EastAsianCS.lunations(l5, l6) == 12L;
        long l8 = EastAsianCS.lunations(l5, l7);
        if (bl2 && this.hasLeapMonth(l5, l7)) {
            --l8;
        }
        if ((n2 = (int)Math.floorMod(l8, 12L)) == 0) {
            n2 = 12;
        }
        long l9 = (long)Math.floor(1.5 - (double)n2 / 12.0 + (double)(l2 - EPOCH_CHINESE) / 365.242189);
        int n3 = (int)Math.floorDiv(l9 - 1L, 60L) + 1;
        int n4 = (int)Math.floorMod(l9, 60L);
        if (n4 == 0) {
            n4 = 60;
        }
        int n5 = (int)(l2 - l7 + 1L);
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n2);
        if (bl2 && this.hasNoMajorSolarTerm(l7) && !this.hasLeapMonth(l5, this.newMoonBefore(l7))) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return this.create(n3, n4, eastAsianMonth, n5, l2);
    }

    @Override
    public final long transform(D d2) {
        return this.transform(((EastAsianCalendar)d2).getCycle(), ((EastAsianCalendar)d2).getYear().getNumber(), ((EastAsianCalendar)d2).getMonth(), ((EastAsianCalendar)d2).getDayOfMonth());
    }

    @Override
    public long getMinimumSinceUTC() {
        return CALENDAR_REFORM_1645;
    }

    @Override
    public final long getMaximumSinceUTC() {
        return MAX_LIMIT;
    }

    abstract D create(int var1, int var2, EastAsianMonth var3, int var4, long var5);

    abstract ZonalOffset getOffset(long var1);

    abstract int[] getLeapMonths();

    final int getLeapMonth(int n2, int n3) {
        int n4;
        int[] nArray = this.getLeapMonths();
        int n5 = (n2 - 1) * 60 + n3 - 1;
        int n6 = 0;
        for (int i2 = 2 * ((n5 - nArray[0]) / 3); i2 < nArray.length; i2 += Math.max(2 * ((n5 - n4) / 3), 2)) {
            n4 = nArray[i2];
            if (n4 < n5) {
                continue;
            }
            if (n4 > n5) break;
            n6 = nArray[i2 + 1];
            break;
        }
        return n6;
    }

    final long transform(int n2, int n3, EastAsianMonth eastAsianMonth, int n4) {
        if (!this.isValid(n2, n3, eastAsianMonth, n4)) {
            throw new IllegalArgumentException("Invalid date.");
        }
        return this.firstDayOfMonth(n2, n3, eastAsianMonth) + (long)n4 - 1L;
    }

    boolean isValid(int n2, int n3, EastAsianMonth eastAsianMonth, int n4) {
        if (n2 < 72 || n2 > 94 || n3 < 1 || n3 > 60 || n2 == 72 && n3 < 22 || n2 == 94 && n3 > 56 || n4 < 1 || n4 > 30 || eastAsianMonth == null || eastAsianMonth.isLeap() && eastAsianMonth.getNumber() != this.getLeapMonth(n2, n3)) {
            return false;
        }
        if (n4 == 30) {
            long l2 = this.firstDayOfMonth(n2, n3, eastAsianMonth);
            long l3 = this.newMoonOnOrAfter(l2 + 1L);
            return l3 - l2 == 30L;
        }
        return true;
    }

    final long newYear(int n2, int n3) {
        long l2 = (long)Math.floor((double)EPOCH_CHINESE + ((double)((n2 - 1) * 60 + n3) - 0.5) * 365.242189);
        return this.newYearOnOrBefore(l2);
    }

    final int getMajorSolarTerm(long l2) {
        double d2 = JulianDay.ofEphemerisTime(this.midnight(l2)).getValue();
        int n2 = (2 + (int)Math.floor(SolarTerm.solarLongitude(d2) / 30.0)) % 12;
        return n2 == 0 ? 12 : n2;
    }

    final boolean hasNoMajorSolarTerm(long l2) {
        double d2;
        int n2;
        double d3 = JulianDay.ofEphemerisTime(this.midnight(l2)).getValue();
        int n3 = (2 + (int)Math.floor(SolarTerm.solarLongitude(d3) / 30.0)) % 12;
        return n3 == (n2 = (2 + (int)Math.floor(SolarTerm.solarLongitude(d2 = JulianDay.ofEphemerisTime(this.midnight(this.newMoonOnOrAfter(l2 + 1L))).getValue()) / 30.0)) % 12);
    }

    final long newMoonOnOrAfter(long l2) {
        Moment moment = MoonPhase.NEW_MOON.atOrAfter(this.midnight(l2));
        return moment.toZonalTimestamp(this.getOffset(l2)).toDate().getDaysSinceEpochUTC();
    }

    Moment midnight(long l2) {
        return PlainDate.of(l2, EpochDays.UTC).atStartOfDay().at(this.getOffset(l2));
    }

    private long newMoonBefore(long l2) {
        Moment moment = MoonPhase.NEW_MOON.before(this.midnight(l2));
        return moment.toZonalTimestamp(this.getOffset(l2)).toDate().getDaysSinceEpochUTC();
    }

    private static long lunations(long l2, long l3) {
        return Math.round((double)(l3 - l2) / 29.530588861);
    }

    private long newYearInSui(long l2) {
        long l3 = this.winterOnOrBefore(l2);
        long l4 = this.winterOnOrBefore(l3 + 370L);
        long l5 = this.newMoonOnOrAfter(l3 + 1L);
        long l6 = this.newMoonOnOrAfter(l5 + 1L);
        long l7 = this.newMoonBefore(l4 + 1L);
        if (EastAsianCS.lunations(l5, l7) == 12L && (this.hasNoMajorSolarTerm(l5) || this.hasNoMajorSolarTerm(l6))) {
            return this.newMoonOnOrAfter(l6 + 1L);
        }
        return l6;
    }

    private long newYearOnOrBefore(long l2) {
        long l3 = this.newYearInSui(l2);
        if (l2 >= l3) {
            return l3;
        }
        return this.newYearInSui(l2 - 180L);
    }

    private boolean hasLeapMonth(long l2, long l3) {
        return l3 >= l2 && (this.hasNoMajorSolarTerm(l3) || this.hasLeapMonth(l2, this.newMoonBefore(l3)));
    }

    private long firstDayOfMonth(int n2, int n3, EastAsianMonth eastAsianMonth) {
        long l2 = this.newYear(n2, n3);
        long l3 = this.newMoonOnOrAfter(l2 + (long)((eastAsianMonth.getNumber() - 1) * 29));
        if (eastAsianMonth.equals(((EastAsianCalendar)this.transform(l3)).getMonth())) {
            return l3;
        }
        return this.newMoonOnOrAfter(l3 + 1L);
    }

    private long winterOnOrBefore(long l2) {
        ZonalOffset zonalOffset = this.getOffset(l2);
        PlainDate plainDate = PlainDate.of(l2, EpochDays.UTC);
        int n2 = plainDate.getMonth() <= 11 || plainDate.getDayOfMonth() <= 15 ? plainDate.getYear() - 1 : plainDate.getYear();
        Moment moment = AstronomicalSeason.WINTER_SOLSTICE.inYear(n2);
        PlainDate plainDate2 = moment.toZonalTimestamp(zonalOffset).getCalendarDate();
        if (plainDate2.isAfter(plainDate)) {
            moment = AstronomicalSeason.WINTER_SOLSTICE.inYear(n2 - 1);
            plainDate2 = moment.toZonalTimestamp(zonalOffset).getCalendarDate();
        }
        return plainDate2.getDaysSinceEpochUTC();
    }
}

