/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.calendar.ChineseEra;
import net.time4j.calendar.EastAsianYear;
import net.time4j.calendar.SexagesimalName;

public final class CyclicYear
extends SexagesimalName {
    private static final CyclicYear[] INSTANCES;
    private static final long serialVersionUID = 4908662352833192131L;

    private CyclicYear(int n2) {
        super(n2);
    }

    public static CyclicYear of(int n2) {
        if (n2 < 1 || n2 > 60) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return INSTANCES[n2 - 1];
    }

    public static CyclicYear of(SexagesimalName.Stem stem, SexagesimalName.Branch branch) {
        SexagesimalName sexagesimalName = SexagesimalName.of(stem, branch);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    public static CyclicYear parse(String string, Locale locale) throws ParseException {
        SexagesimalName sexagesimalName = SexagesimalName.parse(string, locale);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    @Override
    public CyclicYear roll(int n2) {
        if (n2 == 0) {
            return this;
        }
        SexagesimalName sexagesimalName = super.roll(n2);
        return CyclicYear.of(sexagesimalName.getNumber());
    }

    public EastAsianYear inQingDynasty(ChineseEra chineseEra) {
        if (chineseEra.isQingDynasty()) {
            if (chineseEra == ChineseEra.QING_KANGXI_1662_1723 && this.getNumber() == 39) {
                throw new IllegalArgumentException("Ambivalent cyclic year in Kangxi-era (1662 or 1722): " + this.getDisplayName(Locale.ROOT));
            }
            int n2 = chineseEra.getStartAsGregorianYear();
            int n3 = this.getNumber() - EastAsianYear.forGregorian(n2).getYearOfCycle().getNumber();
            return () -> n2 + n3 + (n3 < 0 ? 2696 : 2636);
        }
        throw new IllegalArgumentException("Chinese era must be related to a Qing dynasty.");
    }

    public EastAsianYear inCycle(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Cycle number must not be smaller than 1: " + n2);
        }
        return () -> (n2 - 1) * 60 + this.getNumber() - 1;
    }

    static CyclicYear parse(CharSequence charSequence, ParsePosition parsePosition, Locale locale, boolean bl2) {
        SexagesimalName sexagesimalName = SexagesimalName.parse(charSequence, parsePosition, locale, bl2);
        return sexagesimalName == null ? null : CyclicYear.of(sexagesimalName.getNumber());
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return CyclicYear.of(super.getNumber());
    }

    static {
        CyclicYear[] cyclicYearArray = new CyclicYear[60];
        for (int i2 = 0; i2 < 60; ++i2) {
            cyclicYearArray[i2] = new CyclicYear(i2 + 1);
        }
        INSTANCES = cyclicYearArray;
    }
}

