/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.service.RelatedGregorianYearElement;
import net.time4j.calendar.service.StdDateElement;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.format.internal.FormatUtils;

public class CommonElements {
    @FormattableElement(format="r")
    public static final ChronoElement<Integer> RELATED_GREGORIAN_YEAR = RelatedGregorianYearElement.SINGLETON;

    private CommonElements() {
    }

    @FormattableElement(format="e", alt="c")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Weekday, T> localDayOfWeek(Chronology<T> chronology, Weekmodel weekmodel) {
        CommonElements.checkSevenDayWeek(chronology);
        return new DayOfWeekElement<T>(chronology.getChronoType(), weekmodel);
    }

    @FormattableElement(format="w")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> weekOfYear(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_YEAR");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement<T>("WEEK_OF_YEAR", chronology.getChronoType(), 1, 52, 'w', weekmodel, chronoElement, false);
    }

    @FormattableElement(format="W")
    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> weekOfMonth(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_MONTH");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement<T>("WEEK_OF_MONTH", chronology.getChronoType(), 1, 5, 'W', weekmodel, chronoElement, false);
    }

    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> boundedWeekOfYear(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_YEAR");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement<T>("BOUNDED_WEEK_OF_YEAR", chronology.getChronoType(), 1, 52, '\u0000', weekmodel, chronoElement, true);
    }

    public static <T extends ChronoEntity<T>> StdCalendarElement<Integer, T> boundedWeekOfMonth(Chronology<T> chronology, Weekmodel weekmodel) {
        ChronoElement<Integer> chronoElement = CommonElements.findDayElement(chronology, "DAY_OF_MONTH");
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot derive a rule for given chronology: " + chronology);
        }
        return new CalendarWeekElement<T>("BOUNDED_WEEK_OF_MONTH", chronology.getChronoType(), 1, 5, '\u0000', weekmodel, chronoElement, true);
    }

    private static <D extends ChronoEntity<D>> int getMax(ChronoElement<?> chronoElement, D d2) {
        return (Integer)Integer.class.cast(d2.getMaximum(chronoElement));
    }

    private static Weekday getDayOfWeek(long l2) {
        return Weekday.valueOf((int)(Math.floorMod(l2 + 5L, 7L) + 1L));
    }

    private static void checkSevenDayWeek(Chronology<?> chronology) {
        if (CalendarDate.class.isAssignableFrom(chronology.getChronoType())) {
            for (ChronoElement<?> chronoElement : chronology.getRegisteredElements()) {
                ?[] objArray;
                if (!chronoElement.name().equals("DAY_OF_WEEK") || (objArray = chronoElement.getType().getEnumConstants()) == null || objArray.length != 7) continue;
                return;
            }
        }
        throw new IllegalArgumentException("No 7-day-week: " + chronology);
    }

    private static <D extends ChronoEntity<D>> ChronoElement<Integer> findDayElement(Chronology<D> chronology, String string) {
        CommonElements.checkSevenDayWeek(chronology);
        for (ChronoElement<Integer> chronoElement : chronology.getRegisteredElements()) {
            if (!chronoElement.name().equals(string)) continue;
            if (chronoElement.getType() != Integer.class) break;
            return chronoElement;
        }
        return null;
    }

    private static class DayOfWeekElement<T extends ChronoEntity<T>>
    extends StdEnumDateElement<Weekday, T> {
        private static final long serialVersionUID = 5613494586572932860L;
        private final Weekmodel model;

        DayOfWeekElement(Class<T> clazz, Weekmodel weekmodel) {
            super("LOCAL_DAY_OF_WEEK", clazz, Weekday.class, 'e');
            this.model = weekmodel;
        }

        @Override
        public ChronoOperator<T> decremented() {
            return new DayOperator(-1);
        }

        @Override
        public ChronoOperator<T> incremented() {
            return new DayOperator(1);
        }

        @Override
        public int numerical(Weekday weekday) {
            return weekday.getValue(this.model);
        }

        @Override
        public Weekday getDefaultMinimum() {
            return this.model.getFirstDayOfWeek();
        }

        @Override
        public Weekday getDefaultMaximum() {
            return this.model.getFirstDayOfWeek().roll(6);
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            int n2;
            int n3 = chronoDisplay.get(this).getValue(this.model);
            return n3 < (n2 = chronoDisplay2.get(this).getValue(this.model)) ? -1 : (n3 == n2 ? 0 : 1);
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            if (super.doEquals(basicElement)) {
                DayOfWeekElement dayOfWeekElement = (DayOfWeekElement)DayOfWeekElement.class.cast(basicElement);
                return this.model.equals(dayOfWeekElement.model);
            }
            return false;
        }

        @Override
        protected <D extends ChronoEntity<D>> ElementRule<D, Weekday> derive(Chronology<D> chronology) {
            if (this.getChronoType().equals(chronology.getChronoType())) {
                return new DRule(this);
            }
            return null;
        }

        @Override
        protected boolean isWeekdayElement() {
            return true;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return this;
        }
    }

    private static class CalendarWeekElement<T extends ChronoEntity<T>>
    extends StdIntegerDateElement<T> {
        private static final long serialVersionUID = -7471192143785466686L;
        private final Weekmodel model;
        private final ChronoElement<Integer> dayElement;
        private final boolean bounded;

        CalendarWeekElement(String string, Class<T> clazz, int n2, int n3, char c2, Weekmodel weekmodel, ChronoElement<Integer> chronoElement, boolean bl2) {
            super(string, clazz, n2, n3, c2);
            if (weekmodel == null) {
                throw new NullPointerException("Missing week model.");
            }
            this.model = weekmodel;
            this.dayElement = chronoElement;
            this.bounded = bl2;
        }

        @Override
        public ChronoOperator<T> decremented() {
            return new DayOperator(-7);
        }

        @Override
        public ChronoOperator<T> incremented() {
            return new DayOperator(7);
        }

        @Override
        public boolean isLenient() {
            return true;
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            if (super.doEquals(basicElement)) {
                CalendarWeekElement calendarWeekElement = (CalendarWeekElement)CalendarWeekElement.class.cast(basicElement);
                return this.model.equals(calendarWeekElement.model) && this.bounded == calendarWeekElement.bounded;
            }
            return false;
        }

        @Override
        protected <D extends ChronoEntity<D>> ElementRule<D, Integer> derive(Chronology<D> chronology) {
            if (this.getChronoType().equals(chronology.getChronoType())) {
                return this.bounded ? new BWRule(this) : new CWRule(this);
            }
            return null;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return this;
        }
    }

    private static class DayOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final int amount;

        DayOperator(int n2) {
            this.amount = n2;
        }

        @Override
        public T apply(T t2) {
            long l2 = Math.addExact(((ChronoEntity)t2).get(EpochDays.UTC), (long)this.amount);
            return ((ChronoEntity)t2).with(EpochDays.UTC, l2);
        }
    }

    private static class DRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Weekday> {
        private final DayOfWeekElement<?> element;

        private DRule(DayOfWeekElement<?> dayOfWeekElement) {
            this.element = dayOfWeekElement;
        }

        @Override
        public Weekday getValue(T t2) {
            return CommonElements.getDayOfWeek(((ChronoEntity)t2).get(EpochDays.UTC));
        }

        @Override
        public Weekday getMinimum(T t2) {
            int n2;
            Chronology<?> chronology = Chronology.lookup(t2.getClass());
            long l2 = t2 instanceof CalendarVariant ? chronology.getCalendarSystem(((CalendarVariant)CalendarVariant.class.cast(t2)).getVariant()).getMinimumSinceUTC() : chronology.getCalendarSystem().getMinimumSinceUTC();
            long l3 = ((ChronoEntity)t2).get(EpochDays.UTC);
            if (l3 + 1L - (long)(n2 = CommonElements.getDayOfWeek(l3).getValue(((DayOfWeekElement)this.element).model)) < l2) {
                return CommonElements.getDayOfWeek(l2);
            }
            return this.element.getDefaultMinimum();
        }

        @Override
        public Weekday getMaximum(T t2) {
            int n2;
            Chronology<?> chronology = Chronology.lookup(t2.getClass());
            long l2 = t2 instanceof CalendarVariant ? chronology.getCalendarSystem(((CalendarVariant)CalendarVariant.class.cast(t2)).getVariant()).getMaximumSinceUTC() : chronology.getCalendarSystem().getMaximumSinceUTC();
            long l3 = ((ChronoEntity)t2).get(EpochDays.UTC);
            if (l3 + 7L - (long)(n2 = CommonElements.getDayOfWeek(l3).getValue(((DayOfWeekElement)this.element).model)) > l2) {
                return CommonElements.getDayOfWeek(l2);
            }
            return this.element.getDefaultMaximum();
        }

        @Override
        public boolean isValid(T t2, Weekday weekday) {
            if (weekday == null) {
                return false;
            }
            try {
                this.withValue(t2, weekday, false);
                return true;
            }
            catch (ArithmeticException | IllegalArgumentException runtimeException) {
                return false;
            }
        }

        @Override
        public T withValue(T t2, Weekday weekday, boolean bl2) {
            long l2 = ((ChronoEntity)t2).get(EpochDays.UTC);
            Weekday weekday2 = CommonElements.getDayOfWeek(l2);
            if (weekday == weekday2) {
                return t2;
            }
            int n2 = weekday2.getValue(((DayOfWeekElement)this.element).model);
            int n3 = weekday.getValue(((DayOfWeekElement)this.element).model);
            return ((ChronoEntity)t2).with(EpochDays.UTC, l2 + (long)n3 - (long)n2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t2) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t2) {
            return null;
        }
    }

    private static class BWRule<D extends ChronoEntity<D>>
    implements ElementRule<D, Integer> {
        private final CalendarWeekElement<?> owner;

        private BWRule(CalendarWeekElement<?> calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        @Override
        public Integer getValue(D d2) {
            return this.getWeek(d2);
        }

        @Override
        public Integer getMinimum(D d2) {
            return this.getMinWeek(d2);
        }

        @Override
        public Integer getMaximum(D d2) {
            return this.getMaxWeek(d2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return this.getChild(d2, false);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return this.getChild(d2, true);
        }

        private ChronoElement<?> getChild(D d2, boolean bl2) {
            DayOfWeekElement dayOfWeekElement = new DayOfWeekElement(d2.getClass(), ((CalendarWeekElement)this.owner).model);
            int n2 = this.getWeek(d2);
            long l2 = ((ChronoEntity)d2).get(EpochDays.UTC);
            int n3 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            if (bl2) {
                Object t2 = ((ChronoEntity)d2).with(dayOfWeekElement, (Weekday)((ChronoEntity)d2).getMaximum(dayOfWeekElement));
                long l3 = ((ChronoEntity)t2).get(EpochDays.UTC) - l2;
                if ((long)((Integer)((ChronoEntity)d2).getMaximum(((CalendarWeekElement)this.owner).dayElement)).intValue() < (long)n3 + l3) {
                    return ((CalendarWeekElement)this.owner).dayElement;
                }
            } else if (n2 <= 1) {
                Object t3 = ((ChronoEntity)d2).with(dayOfWeekElement, (Weekday)((ChronoEntity)d2).getMinimum(dayOfWeekElement));
                long l4 = l2 - ((ChronoEntity)t3).get(EpochDays.UTC);
                if ((long)((Integer)((ChronoEntity)d2).getMinimum(((CalendarWeekElement)this.owner).dayElement)).intValue() > (long)n3 - l4) {
                    return ((CalendarWeekElement)this.owner).dayElement;
                }
            }
            return dayOfWeekElement;
        }

        @Override
        public boolean isValid(D d2, Integer n2) {
            if (n2 == null) {
                return false;
            }
            int n3 = n2;
            return n3 >= this.getMinWeek(d2) && n3 <= this.getMaxWeek(d2);
        }

        @Override
        public D withValue(D d2, Integer n2, boolean bl2) {
            if (n2 == null || !bl2 && !this.isValid(d2, n2)) {
                throw new IllegalArgumentException("Invalid value: " + n2 + " (context=" + d2 + ")");
            }
            return this.setWeek(d2, n2);
        }

        private int getWeek(D d2) {
            return this.getWeek(d2, 0);
        }

        private int getMinWeek(D d2) {
            return this.getWeek(d2, -1);
        }

        private int getMaxWeek(D d2) {
            return this.getWeek(d2, 1);
        }

        private int getWeek(D d2, int n2) {
            int n3;
            int n4 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            Weekday weekday = CommonElements.getDayOfWeek(((ChronoEntity)d2).get(EpochDays.UTC) - (long)n4 + 1L);
            int n5 = weekday.getValue(((CalendarWeekElement)this.owner).model);
            int n6 = n5 <= 8 - ((CalendarWeekElement)this.owner).model.getMinimalDaysInFirstWeek() ? 2 - n5 : 9 - n5;
            switch (n2) {
                case -1: {
                    n3 = 1;
                    break;
                }
                case 0: {
                    n3 = n4;
                    break;
                }
                case 1: {
                    n3 = (Integer)((ChronoEntity)d2).getMaximum(((CalendarWeekElement)this.owner).dayElement);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected: " + n2));
                }
            }
            return MathUtils.floorDivide(n3 - n6, 7) + 1;
        }

        private D setWeek(D d2, int n2) {
            int n3 = this.getWeek(d2);
            if (n2 == n3) {
                return d2;
            }
            int n4 = 7 * (n2 - n3);
            return (D)((ChronoEntity)d2).with(EpochDays.UTC, ((ChronoEntity)d2).get(EpochDays.UTC) + (long)n4);
        }
    }

    private static class CWRule<D extends ChronoEntity<D>>
    implements ElementRule<D, Integer> {
        private final CalendarWeekElement<?> owner;

        private CWRule(CalendarWeekElement<?> calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        @Override
        public Integer getValue(D d2) {
            return this.getCalendarWeek(d2);
        }

        @Override
        public Integer getMinimum(D d2) {
            return 1;
        }

        @Override
        public Integer getMaximum(D d2) {
            return this.getMaxCalendarWeek(d2);
        }

        @Override
        public boolean isValid(D d2, Integer n2) {
            if (n2 == null) {
                return false;
            }
            int n3 = n2;
            return n3 >= 1 && n3 <= this.getMaxCalendarWeek(d2);
        }

        @Override
        public D withValue(D d2, Integer n2, boolean bl2) {
            int n3 = n2;
            if (!bl2 && !this.isValid(d2, n2)) {
                throw new IllegalArgumentException("Invalid value: " + n3 + " (context=" + d2 + ")");
            }
            return this.setCalendarWeek(d2, n3);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return new DayOfWeekElement(d2.getClass(), ((CalendarWeekElement)this.owner).model);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return new DayOfWeekElement(d2.getClass(), ((CalendarWeekElement)this.owner).model);
        }

        private int getMaxCalendarWeek(D d2) {
            int n2 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            int n3 = this.getFirstCalendarWeekAsDay(d2, 0);
            if (n3 <= n2) {
                int n4 = this.getFirstCalendarWeekAsDay(d2, 1) + this.getLengthOfYM(d2, 0);
                if (n4 <= n2) {
                    try {
                        int n5 = this.getFirstCalendarWeekAsDay(d2, 1);
                        Object t2 = ((ChronoEntity)d2).with(EpochDays.UTC, ((ChronoEntity)d2).get(EpochDays.UTC) + 7L);
                        n4 = this.getFirstCalendarWeekAsDay(t2, 1) + this.getLengthOfYM(d2, 1);
                        n3 = n5;
                    }
                    catch (RuntimeException runtimeException) {
                        n4 += 7;
                    }
                }
                return (n4 - n3) / 7;
            }
            int n6 = this.getFirstCalendarWeekAsDay(d2, -1);
            return ((n3 += this.getLengthOfYM(d2, -1)) - n6) / 7;
        }

        private int getFirstCalendarWeekAsDay(D d2, int n2) {
            Weekmodel weekmodel;
            Weekday weekday = this.getWeekdayStart(d2, n2);
            int n3 = weekday.getValue(weekmodel = ((CalendarWeekElement)this.owner).model);
            return n3 <= 8 - weekmodel.getMinimalDaysInFirstWeek() ? 2 - n3 : 9 - n3;
        }

        private Weekday getWeekdayStart(D d2, int n2) {
            int n3 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            switch (n2) {
                case -1: {
                    long l2 = ((ChronoEntity)d2).get(EpochDays.UTC) - (long)n3;
                    int n4 = ((ChronoEntity)((ChronoEntity)d2).with(EpochDays.UTC, l2)).getInt(((CalendarWeekElement)this.owner).dayElement);
                    return CommonElements.getDayOfWeek(l2 - (long)n4 + 1L);
                }
                case 0: {
                    return CommonElements.getDayOfWeek(((ChronoEntity)d2).get(EpochDays.UTC) - (long)n3 + 1L);
                }
                case 1: {
                    int n5 = CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d2);
                    return CommonElements.getDayOfWeek(((ChronoEntity)d2).get(EpochDays.UTC) + (long)n5 + 1L - (long)n3);
                }
            }
            throw new AssertionError((Object)("Unexpected: " + n2));
        }

        private int getLengthOfYM(D d2, int n2) {
            int n3 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            switch (n2) {
                case -1: {
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, ((ChronoEntity)d2).with(EpochDays.UTC, ((ChronoEntity)d2).get(EpochDays.UTC) - (long)n3));
                }
                case 0: {
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d2);
                }
                case 1: {
                    int n4 = CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, d2);
                    return CommonElements.getMax(((CalendarWeekElement)this.owner).dayElement, ((ChronoEntity)d2).with(EpochDays.UTC, ((ChronoEntity)d2).get(EpochDays.UTC) + (long)n4 + 1L - (long)n3));
                }
            }
            throw new AssertionError((Object)("Unexpected: " + n2));
        }

        private int getCalendarWeek(D d2) {
            int n2 = ((ChronoEntity)d2).getInt(((CalendarWeekElement)this.owner).dayElement);
            int n3 = this.getFirstCalendarWeekAsDay(d2, 0);
            if (n3 <= n2) {
                int n4 = this.getFirstCalendarWeekAsDay(d2, 1) + this.getLengthOfYM(d2, 0);
                if (n4 <= n2) {
                    return 1;
                }
                return (n2 - n3) / 7 + 1;
            }
            int n5 = this.getFirstCalendarWeekAsDay(d2, -1);
            int n6 = n2 + this.getLengthOfYM(d2, -1);
            return (n6 - n5) / 7 + 1;
        }

        private D setCalendarWeek(D d2, int n2) {
            int n3 = this.getCalendarWeek(d2);
            if (n2 == n3) {
                return d2;
            }
            return (D)((ChronoEntity)d2).with(EpochDays.UTC, ((ChronoEntity)d2).get(EpochDays.UTC) + (long)(7 * (n2 - n3)));
        }
    }

    static class Weekengine
    implements ChronoExtension {
        private final Class<? extends ChronoEntity> chronoType;
        private final ChronoElement<Integer> dayOfMonthElement;
        private final ChronoElement<Integer> dayOfYearElement;
        private final Weekmodel defaultWeekmodel;

        Weekengine(Class<? extends ChronoEntity> clazz, ChronoElement<Integer> chronoElement, ChronoElement<Integer> chronoElement2, Weekmodel weekmodel) {
            this.chronoType = clazz;
            this.dayOfMonthElement = chronoElement;
            this.dayOfYearElement = chronoElement2;
            this.defaultWeekmodel = weekmodel;
        }

        @Override
        public boolean accept(Class<?> clazz) {
            return this.chronoType.equals(clazz);
        }

        @Override
        public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
            Weekmodel weekmodel = FormatUtils.useDefaultWeekmodel(locale) ? this.defaultWeekmodel : Weekmodel.of(locale);
            HashSet<StdDateElement> hashSet = new HashSet<StdDateElement>();
            hashSet.add(new DayOfWeekElement<ChronoEntity>(this.chronoType, weekmodel));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("WEEK_OF_MONTH", this.chronoType, 1, 5, 'W', weekmodel, this.dayOfMonthElement, false));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("WEEK_OF_YEAR", this.chronoType, 1, 52, 'w', weekmodel, this.dayOfYearElement, false));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("BOUNDED_WEEK_OF_MONTH", this.chronoType, 1, 5, '\u0000', weekmodel, this.dayOfMonthElement, true));
            hashSet.add(new CalendarWeekElement<ChronoEntity>("BOUNDED_WEEK_OF_YEAR", this.chronoType, 1, 52, '\u0000', weekmodel, this.dayOfYearElement, true));
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public ChronoEntity<?> resolve(ChronoEntity<?> chronoEntity, Locale locale, AttributeQuery attributeQuery) {
            return chronoEntity;
        }

        @Override
        public boolean canResolve(ChronoElement<?> chronoElement) {
            return false;
        }
    }
}

