/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.AbstractDateElement;
import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.UnitRule;

final class YOWElement
extends AbstractDateElement<Integer> {
    private static final UnitRule U_RULE = new URule();
    static final YOWElement INSTANCE = new YOWElement("YEAR_OF_WEEKDATE");
    private static final long serialVersionUID = -6907291758376370420L;
    private final transient ElementOperator<PlainDate> previousAdjuster = new YOWRollingAdjuster(-1L);
    private final transient ElementOperator<PlainDate> nextAdjuster = new YOWRollingAdjuster(1L);

    private YOWElement(String string) {
        super(string);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return 'Y';
    }

    @Override
    public Integer getDefaultMinimum() {
        return PlainDate.MIN_YEAR;
    }

    @Override
    public Integer getDefaultMaximum() {
        return PlainDate.MAX_YEAR;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> decremented() {
        return this.previousAdjuster;
    }

    @Override
    public ElementOperator<PlainDate> incremented() {
        return this.nextAdjuster;
    }

    @Override
    protected boolean isSingleton() {
        return true;
    }

    static <T extends ChronoEntity<T>> ElementRule<T, Integer> elementRule(Class<T> clazz) {
        return new ERule();
    }

    static <T extends ChronoEntity<T>> UnitRule<T> unitRule() {
        return U_RULE;
    }

    private static int getFirstCalendarWeekAsDayOfYear(PlainDate plainDate, int n2) {
        return YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate.getYear() + n2);
    }

    private static int getFirstCalendarWeekAsDayOfYear(int n2) {
        Weekday weekday = Weekday.valueOf(GregorianMath.getDayOfWeek(n2, 1, 1));
        int n3 = weekday.getValue(Weekmodel.ISO);
        return n3 <= 8 - Weekmodel.ISO.getMinimalDaysInFirstWeek() ? 2 - n3 : 9 - n3;
    }

    private static int getLengthOfYear(PlainDate plainDate, int n2) {
        return GregorianMath.isLeapYear(plainDate.getYear() + n2) ? 366 : 365;
    }

    private static int getWeekOfYear(PlainDate plainDate) {
        int n2 = plainDate.getDayOfYear();
        int n3 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 0);
        if (n3 <= n2) {
            int n4;
            int n5 = (n2 - n3) / 7 + 1;
            if (n5 >= 53 && (n4 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 1) + YOWElement.getLengthOfYear(plainDate, 0)) <= n2) {
                n5 = 1;
            }
            return n5;
        }
        int n6 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, -1);
        int n7 = n2 + YOWElement.getLengthOfYear(plainDate, -1);
        return (n7 - n6) / 7 + 1;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private static class YOWRollingAdjuster
    extends ElementOperator<PlainDate> {
        private final long amount;
        private final ChronoOperator<PlainTimestamp> yowTS;

        private YOWRollingAdjuster(long l2) {
            super(INSTANCE, 8);
            this.amount = l2;
            this.yowTS = plainTimestamp -> {
                UnitRule<PlainTimestamp> unitRule = YOWElement.unitRule();
                return unitRule.addTo((PlainTimestamp)plainTimestamp, this.amount);
            };
        }

        @Override
        public PlainDate apply(PlainDate plainDate) {
            UnitRule<PlainDate> unitRule = YOWElement.unitRule();
            return unitRule.addTo(plainDate, this.amount);
        }

        @Override
        ChronoOperator<PlainTimestamp> onTimestamp() {
            return this.yowTS;
        }
    }

    private static class ERule<T extends ChronoEntity<T>>
    implements IntElementRule<T> {
        private ERule() {
        }

        @Override
        public Integer getValue(T t2) {
            return this.getInt(t2);
        }

        @Override
        public Integer getMinimum(T t2) {
            return INSTANCE.getDefaultMinimum();
        }

        @Override
        public Integer getMaximum(T t2) {
            return INSTANCE.getDefaultMaximum();
        }

        @Override
        public boolean isValid(T t2, Integer n2) {
            if (n2 == null) {
                return false;
            }
            int n3 = n2;
            return n3 >= -999999999 && n3 <= 999999999;
        }

        @Override
        public T withValue(T t2, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            plainDate = ERule.setYearOfWeekdate(plainDate, n2);
            return ((ChronoEntity)t2).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t2) {
            return this.getChild();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t2) {
            return this.getChild();
        }

        private ChronoElement<?> getChild() {
            return Weekmodel.ISO.weekOfYear();
        }

        private static PlainDate setYearOfWeekdate(PlainDate plainDate, int n2) {
            int n3;
            int n4 = YOWElement.getFirstCalendarWeekAsDayOfYear(n2);
            int n5 = YOWElement.getWeekOfYear(plainDate);
            int n6 = plainDate.getDayOfWeek().getValue(Weekmodel.ISO);
            long l2 = EpochDays.UNIX.transform(GregorianMath.toMJD(n2, 1, 1), EpochDays.MODIFIED_JULIAN_DATE) + (long)(n4 - 1) + (long)((n5 - 1) * 7) + (long)(n6 - 1);
            if (n5 == 53 && ((n3 = YOWElement.getFirstCalendarWeekAsDayOfYear(n2 + 1) + (GregorianMath.isLeapYear(n2) ? 366 : 365)) - n4) / 7 < 53) {
                l2 -= 7L;
            }
            return plainDate.withDaysSinceUTC(l2 - 730L);
        }

        @Override
        public int getInt(T t2) {
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            int n2 = plainDate.getYear();
            int n3 = plainDate.getDayOfYear();
            int n4 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 0);
            if (n4 <= n3) {
                if ((n3 - n4) / 7 + 1 >= 53 && YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 1) + YOWElement.getLengthOfYear(plainDate, 0) <= n3) {
                    ++n2;
                }
            } else {
                --n2;
            }
            return n2;
        }

        @Override
        public boolean isValid(T t2, int n2) {
            return n2 >= -999999999 && n2 <= 999999999;
        }

        @Override
        public T withValue(T t2, int n2, boolean bl2) {
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            plainDate = ERule.setYearOfWeekdate(plainDate, n2);
            return ((ChronoEntity)t2).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }
    }

    private static class URule<T extends ChronoEntity<T>>
    implements UnitRule<T> {
        private URule() {
        }

        @Override
        public T addTo(T t2, long l2) {
            if (l2 == 0L) {
                return t2;
            }
            int n2 = MathUtils.safeCast(MathUtils.safeAdd((long)((ChronoEntity)t2).get(INSTANCE).intValue(), l2));
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            int n3 = plainDate.getWeekOfYear();
            Weekday weekday = plainDate.getDayOfWeek();
            if (n3 == 53) {
                PlainDate plainDate2 = PlainDate.of(n2, 26, weekday);
                n3 = (Integer)plainDate2.getMaximum(Weekmodel.ISO.weekOfYear());
            }
            return ((ChronoEntity)t2).with(PlainDate.CALENDAR_DATE, (PlainDate)PlainDate.of(n2, n3, weekday));
        }

        @Override
        public long between(T t2, T t3) {
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            PlainDate plainDate2 = ((ChronoEntity)t3).get(PlainDate.CALENDAR_DATE);
            int n2 = plainDate.get(INSTANCE);
            int n3 = plainDate2.get(INSTANCE);
            long l2 = n3 - n2;
            if (l2 != 0L) {
                int n4 = YOWElement.getWeekOfYear(plainDate);
                int n5 = YOWElement.getWeekOfYear(plainDate2);
                if (l2 > 0L && n4 > n5) {
                    --l2;
                } else if (l2 < 0L && n4 < n5) {
                    ++l2;
                }
                if (l2 != 0L && n4 == n5) {
                    int n6 = plainDate.getDayOfWeek().getValue();
                    int n7 = plainDate2.getDayOfWeek().getValue();
                    if (l2 > 0L && n6 > n7) {
                        --l2;
                    } else if (l2 < 0L && n6 < n7) {
                        ++l2;
                    }
                    if (l2 != 0L && n6 == n7 && ((ChronoEntity)t2).contains(PlainTime.WALL_TIME) && ((ChronoEntity)t3).contains(PlainTime.WALL_TIME)) {
                        PlainTime plainTime = ((ChronoEntity)t2).get(PlainTime.WALL_TIME);
                        PlainTime plainTime2 = ((ChronoEntity)t3).get(PlainTime.WALL_TIME);
                        if (l2 > 0L && plainTime.isAfter(plainTime2)) {
                            --l2;
                        } else if (l2 < 0L && plainTime.isBefore(plainTime2)) {
                            ++l2;
                        }
                    }
                }
            }
            return l2;
        }
    }
}

