/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.CalendarUnit;
import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.ChronoOperator;

final class WallTimeOperator
extends ElementOperator<PlainTimestamp> {
    private final int mode;
    private final PlainTime value;

    WallTimeOperator(int n2, PlainTime plainTime) {
        super(PlainTime.COMPONENT, n2);
        if (plainTime == null) {
            throw new NullPointerException("Missing target wall time.");
        }
        this.mode = n2;
        this.value = plainTime;
    }

    @Override
    public PlainTimestamp apply(PlainTimestamp plainTimestamp) {
        PlainTime plainTime = plainTimestamp.getWallTime();
        if (this.value.isSimultaneous(plainTime)) {
            return this.handleSameTimes(plainTimestamp);
        }
        if (this.value.getHour() == 24) {
            return this.handleMidnight24(plainTimestamp);
        }
        if (this.value.isAfter(plainTime)) {
            return this.handleLater(plainTimestamp);
        }
        return this.handleEarlier(plainTimestamp);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this;
    }

    private PlainTimestamp handleSameTimes(PlainTimestamp plainTimestamp) {
        switch (this.mode) {
            case 9: {
                return plainTimestamp.plus(1L, CalendarUnit.DAYS);
            }
            case 10: {
                return plainTimestamp.minus(1L, CalendarUnit.DAYS);
            }
            case 11: 
            case 12: {
                return plainTimestamp;
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.mode));
    }

    private PlainTimestamp handleMidnight24(PlainTimestamp plainTimestamp) {
        PlainDate plainDate = plainTimestamp.getCalendarDate();
        switch (this.mode) {
            case 9: 
            case 11: {
                return plainDate.plus(1L, CalendarUnit.DAYS).atStartOfDay();
            }
            case 10: 
            case 12: {
                return plainDate.atStartOfDay();
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.mode));
    }

    private PlainTimestamp handleLater(PlainTimestamp plainTimestamp) {
        switch (this.mode) {
            case 9: 
            case 11: {
                return plainTimestamp.with(this.value);
            }
            case 10: 
            case 12: {
                return plainTimestamp.minus(1L, CalendarUnit.DAYS).with(this.value);
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.mode));
    }

    private PlainTimestamp handleEarlier(PlainTimestamp plainTimestamp) {
        switch (this.mode) {
            case 9: 
            case 11: {
                return plainTimestamp.plus(1L, CalendarUnit.DAYS).with(this.value);
            }
            case 10: 
            case 12: {
                return plainTimestamp.with(this.value);
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.mode));
    }
}

