/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.ArrayList;
import java.util.Comparator;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeSpan;

class StdNormalizer<U extends IsoUnit>
implements Normalizer<U>,
Comparator<TimeSpan.Item<? extends ChronoUnit>> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private final boolean mixed;

    private StdNormalizer(boolean bl2) {
        this.mixed = bl2;
    }

    static StdNormalizer<IsoUnit> ofMixedUnits() {
        return new StdNormalizer<IsoUnit>(true);
    }

    static StdNormalizer<CalendarUnit> ofCalendarUnits() {
        return new StdNormalizer<CalendarUnit>(false);
    }

    static StdNormalizer<ClockUnit> ofClockUnits() {
        return new StdNormalizer<ClockUnit>(false);
    }

    static Comparator<TimeSpan.Item<? extends ChronoUnit>> comparator() {
        return new StdNormalizer(false);
    }

    @Override
    public int compare(TimeSpan.Item<? extends ChronoUnit> item, TimeSpan.Item<? extends ChronoUnit> item2) {
        return StdNormalizer.compare(item.getUnit(), item2.getUnit());
    }

    @Override
    public Duration<U> normalize(TimeSpan<? extends U> timeSpan) {
        Enum enum_;
        long l2;
        int n2 = timeSpan.getTotalLength().size();
        ArrayList arrayList = new ArrayList(n2);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        block18: for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item<U> item = timeSpan.getTotalLength().get(i2);
            l2 = item.getAmount();
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (isoUnit instanceof CalendarUnit) {
                switch ((CalendarUnit)CalendarUnit.class.cast(isoUnit)) {
                    case MILLENNIA: {
                        l3 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 1000L), l3);
                        continue block18;
                    }
                    case CENTURIES: {
                        l3 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 100L), l3);
                        continue block18;
                    }
                    case DECADES: {
                        l3 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 10L), l3);
                        continue block18;
                    }
                    case YEARS: {
                        l3 = MathUtils.safeAdd(l2, l3);
                        continue block18;
                    }
                    case QUARTERS: {
                        l4 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 3L), l4);
                        continue block18;
                    }
                    case MONTHS: {
                        l4 = MathUtils.safeAdd(l2, l4);
                        continue block18;
                    }
                    case WEEKS: {
                        l5 = l2;
                        continue block18;
                    }
                    case DAYS: {
                        l6 = l2;
                        continue block18;
                    }
                    default: {
                        throw new UnsupportedOperationException(isoUnit.toString());
                    }
                }
            }
            if (isoUnit instanceof ClockUnit) {
                switch ((ClockUnit)ClockUnit.class.cast(isoUnit)) {
                    case HOURS: {
                        l7 = l2;
                        continue block18;
                    }
                    case MINUTES: {
                        l8 = l2;
                        continue block18;
                    }
                    case SECONDS: {
                        l9 = l2;
                        continue block18;
                    }
                    case MILLIS: {
                        l10 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 1000000L), l10);
                        continue block18;
                    }
                    case MICROS: {
                        l10 = MathUtils.safeAdd(MathUtils.safeMultiply(l2, 1000L), l10);
                        continue block18;
                    }
                    case NANOS: {
                        l10 = MathUtils.safeAdd(l2, l10);
                        continue block18;
                    }
                    default: {
                        throw new UnsupportedOperationException(isoUnit.toString());
                    }
                }
            }
            arrayList.add(TimeSpan.Item.of(l2, isoUnit));
        }
        long l11 = 0L;
        l2 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        if ((l7 | l8 | l9 | l10) != 0L) {
            l11 = l10 % 1000000000L;
            l9 = MathUtils.safeAdd(l9, l10 / 1000000000L);
            l2 = l9 % 60L;
            l8 = MathUtils.safeAdd(l8, l9 / 60L);
            l12 = l8 % 60L;
            l7 = MathUtils.safeAdd(l7, l8 / 60L);
            if (this.mixed) {
                l13 = l7 % 24L;
                l6 = MathUtils.safeAdd(l6, l7 / 24L);
            } else {
                l13 = l7;
            }
        }
        if ((l3 | l4 | l6) != 0L) {
            long l14 = MathUtils.safeAdd(l3, l4 / 12L);
            long l15 = l4 % 12L;
            long l16 = MathUtils.safeAdd(MathUtils.safeMultiply(l5, 7L), l6);
            if (l14 != 0L) {
                enum_ = CalendarUnit.YEARS;
                arrayList.add(TimeSpan.Item.of(l14, enum_));
            }
            if (l15 != 0L) {
                enum_ = CalendarUnit.MONTHS;
                arrayList.add(TimeSpan.Item.of(l15, enum_));
            }
            if (l16 != 0L) {
                enum_ = CalendarUnit.DAYS;
                arrayList.add(TimeSpan.Item.of(l16, enum_));
            }
        } else if (l5 != 0L) {
            enum_ = CalendarUnit.WEEKS;
            arrayList.add(TimeSpan.Item.of(l5, enum_));
        }
        if (l13 != 0L) {
            enum_ = ClockUnit.HOURS;
            arrayList.add(TimeSpan.Item.of(l13, enum_));
        }
        if (l12 != 0L) {
            enum_ = ClockUnit.MINUTES;
            arrayList.add(TimeSpan.Item.of(l12, enum_));
        }
        if (l2 != 0L) {
            enum_ = ClockUnit.SECONDS;
            arrayList.add(TimeSpan.Item.of(l2, enum_));
        }
        if (l11 != 0L) {
            enum_ = ClockUnit.NANOS;
            arrayList.add(TimeSpan.Item.of(l11, enum_));
        }
        return new Duration(arrayList, timeSpan.isNegative());
    }

    static int compare(ChronoUnit chronoUnit, ChronoUnit chronoUnit2) {
        int n2 = Double.compare(chronoUnit2.getLength(), chronoUnit.getLength());
        if (n2 == 0 && !chronoUnit.equals(chronoUnit2)) {
            throw new IllegalArgumentException("Mixing different units of same length not allowed.");
        }
        return n2;
    }
}

