/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.time4j.DayPeriod;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.MachineTime;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.engine.TimeSpan;
import net.time4j.format.internal.FormatUtils;
import net.time4j.scale.TimeScale;

final class SPX
implements Externalizable {
    static final int DATE_TYPE = 1;
    static final int TIME_TYPE = 2;
    static final int WEEKMODEL_TYPE = 3;
    static final int MOMENT_TYPE = 4;
    static final int MACHINE_TIME_TYPE = 5;
    static final int DURATION_TYPE = 6;
    static final int DAY_PERIOD_TYPE = 7;
    static final int TIMESTAMP_TYPE = 8;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: {
                this.writeDate(objectOutput);
                break;
            }
            case 2: {
                this.writeTime(objectOutput);
                break;
            }
            case 3: {
                this.writeWeekmodel(objectOutput);
                break;
            }
            case 4: {
                this.writeMoment(objectOutput);
                break;
            }
            case 5: {
                this.writeMachineTime(objectOutput);
                break;
            }
            case 6: {
                this.writeDuration(objectOutput);
                break;
            }
            case 7: {
                this.writeDayPeriod(objectOutput);
                break;
            }
            case 8: {
                this.writeTimestamp(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        switch ((by2 & 0xFF) >> 4) {
            case 1: {
                this.obj = this.readDate(objectInput, by2);
                break;
            }
            case 2: {
                this.obj = this.readTime(objectInput);
                break;
            }
            case 3: {
                this.obj = this.readWeekmodel(objectInput, by2);
                break;
            }
            case 4: {
                this.obj = this.readMoment(objectInput, by2);
                break;
            }
            case 5: {
                this.obj = this.readMachineTime(objectInput, by2);
                break;
            }
            case 6: {
                this.obj = this.readDuration(objectInput, by2);
                break;
            }
            case 7: {
                this.obj = this.readDayPeriod(objectInput, by2);
                break;
            }
            case 8: {
                this.obj = this.readTimestamp(objectInput, by2);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeDate(DataOutput dataOutput) throws IOException {
        PlainDate plainDate = (PlainDate)this.obj;
        SPX.writeDate(plainDate, 1, dataOutput);
    }

    private static void writeDate(PlainDate plainDate, int n2, DataOutput dataOutput) throws IOException {
        int n3 = plainDate.getYear();
        int n4 = n3 >= 1850 && n3 <= 2100 ? 1 : (Math.abs(n3) < 10000 ? 2 : 3);
        int n5 = n2;
        n5 <<= 4;
        dataOutput.writeByte(n5 |= plainDate.getMonth());
        int n6 = n4;
        n6 <<= 5;
        dataOutput.writeByte(n6 |= plainDate.getDayOfMonth());
        if (n4 == 1) {
            dataOutput.writeByte(n3 - 1850 - 128);
        } else if (n4 == 2) {
            dataOutput.writeShort(n3);
        } else {
            dataOutput.writeInt(n3);
        }
    }

    private PlainDate readDate(DataInput dataInput, byte by2) throws IOException {
        int n2;
        int n3 = by2 & 0xF;
        byte by3 = dataInput.readByte();
        int n4 = by3 >> 5 & 3;
        int n5 = by3 & 0x1F;
        switch (n4) {
            case 1: {
                n2 = dataInput.readByte() + 1850 + 128;
                break;
            }
            case 2: {
                n2 = dataInput.readShort();
                break;
            }
            case 3: {
                n2 = dataInput.readInt();
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown year range.");
            }
        }
        return PlainDate.of(n2, Month.valueOf(n3), n5);
    }

    private void writeTime(DataOutput dataOutput) throws IOException {
        PlainTime plainTime = (PlainTime)this.obj;
        dataOutput.writeByte(32);
        SPX.writeTime(plainTime, dataOutput);
    }

    private static void writeTime(PlainTime plainTime, DataOutput dataOutput) throws IOException {
        if (plainTime.getNanosecond() == 0) {
            if (plainTime.getSecond() == 0) {
                if (plainTime.getMinute() == 0) {
                    dataOutput.writeByte(~plainTime.getHour());
                } else {
                    dataOutput.writeByte(plainTime.getHour());
                    dataOutput.writeByte(~plainTime.getMinute());
                }
            } else {
                dataOutput.writeByte(plainTime.getHour());
                dataOutput.writeByte(plainTime.getMinute());
                dataOutput.writeByte(~plainTime.getSecond());
            }
        } else {
            dataOutput.writeByte(plainTime.getHour());
            dataOutput.writeByte(plainTime.getMinute());
            dataOutput.writeByte(plainTime.getSecond());
            dataOutput.writeInt(plainTime.getNanosecond());
        }
    }

    private PlainTime readTime(DataInput dataInput) throws IOException {
        byte by2 = dataInput.readByte();
        if (by2 < 0) {
            return PlainTime.of(~by2);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = dataInput.readByte();
        if (n4 < 0) {
            n4 ^= 0xFFFFFFFF;
        } else {
            n2 = dataInput.readByte();
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            } else {
                n3 = dataInput.readInt();
            }
        }
        return PlainTime.of(by2, n4, n2, n3);
    }

    private void writeWeekmodel(DataOutput dataOutput) throws IOException {
        Weekmodel weekmodel = (Weekmodel)this.obj;
        boolean bl2 = weekmodel.getStartOfWeekend() == Weekday.SATURDAY && weekmodel.getEndOfWeekend() == Weekday.SUNDAY;
        int n2 = 3;
        n2 <<= 4;
        if (!bl2) {
            n2 |= 1;
        }
        dataOutput.writeByte(n2);
        int n3 = weekmodel.getFirstDayOfWeek().getValue();
        n3 <<= 4;
        dataOutput.writeByte(n3 |= weekmodel.getMinimalDaysInFirstWeek());
        if (!bl2) {
            n3 = weekmodel.getStartOfWeekend().getValue();
            n3 <<= 4;
            dataOutput.writeByte(n3 |= weekmodel.getEndOfWeekend().getValue());
        }
    }

    private Object readWeekmodel(DataInput dataInput, byte by2) throws IOException {
        byte by3 = dataInput.readByte();
        Weekday weekday = Weekday.valueOf(by3 >> 4);
        int n2 = by3 & 0xF;
        Weekday weekday2 = Weekday.SATURDAY;
        Weekday weekday3 = Weekday.SUNDAY;
        if ((by2 & 0xF) == 1) {
            by3 = dataInput.readByte();
            weekday2 = Weekday.valueOf(by3 >> 4);
            weekday3 = Weekday.valueOf(by3 & 0xF);
        }
        return Weekmodel.of(weekday, n2, weekday2, weekday3);
    }

    private void writeMoment(DataOutput dataOutput) throws IOException {
        Moment moment = (Moment)this.obj;
        moment.writeTimestamp(dataOutput);
    }

    private Object readMoment(DataInput dataInput, byte by2) throws IOException {
        int n2 = by2 & 1;
        int n3 = (by2 & 2) >>> 1;
        boolean bl2 = n2 != 0;
        boolean bl3 = n3 != 0;
        return Moment.readTimestamp(dataInput, bl2, bl3);
    }

    private void writeTimestamp(DataOutput dataOutput) throws IOException {
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.obj;
        SPX.writeDate(plainTimestamp.getCalendarDate(), 8, dataOutput);
        SPX.writeTime(plainTimestamp.getWallTime(), dataOutput);
    }

    private Object readTimestamp(DataInput dataInput, byte by2) throws IOException {
        PlainDate plainDate = this.readDate(dataInput, by2);
        PlainTime plainTime = this.readTime(dataInput);
        return PlainTimestamp.of(plainDate, plainTime);
    }

    private void writeDuration(ObjectOutput objectOutput) throws IOException {
        int n2;
        Duration duration = (Duration)Duration.class.cast(this.obj);
        int n3 = duration.getTotalLength().size();
        boolean bl2 = false;
        int n4 = Math.min(n3, 6);
        for (n2 = 0; n2 < n4; ++n2) {
            if (duration.getTotalLength().get(n2).getAmount() < 1000L) continue;
            bl2 = true;
            break;
        }
        n2 = 6;
        n2 <<= 4;
        if (bl2) {
            n2 |= 1;
        }
        objectOutput.writeByte(n2);
        objectOutput.writeInt(n3);
        for (n4 = 0; n4 < n3; ++n4) {
            TimeSpan.Item item = duration.getTotalLength().get(n4);
            if (bl2) {
                objectOutput.writeLong(item.getAmount());
            } else {
                objectOutput.writeInt((int)item.getAmount());
            }
            objectOutput.writeObject(item.getUnit());
        }
        if (n3 > 0) {
            objectOutput.writeBoolean(duration.isNegative());
        }
    }

    private Object readDuration(ObjectInput objectInput, byte by2) throws IOException, ClassNotFoundException {
        int n2;
        boolean bl2 = (by2 & 0xF) == 1;
        int n3 = objectInput.readInt();
        if (n3 == 0) {
            return Duration.ofZero();
        }
        ArrayList arrayList = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            long l2 = bl2 ? objectInput.readLong() : (long)objectInput.readInt();
            IsoUnit isoUnit = (IsoUnit)objectInput.readObject();
            arrayList.add(TimeSpan.Item.of(l2, isoUnit));
        }
        n2 = objectInput.readBoolean() ? 1 : 0;
        return new Duration(arrayList, n2 != 0);
    }

    private void writeDayPeriod(ObjectOutput objectOutput) throws IOException {
        DayPeriod.Element element = (DayPeriod.Element)DayPeriod.Element.class.cast(this.obj);
        Locale locale = element.getLocale();
        int n2 = 7;
        n2 <<= 4;
        if (element.isFixed()) {
            n2 |= 1;
        }
        if (locale == null) {
            n2 |= 2;
        }
        objectOutput.writeByte(n2);
        if (locale == null) {
            objectOutput.writeObject(element.getCodeMap());
        } else {
            String string = locale.getLanguage();
            String string2 = FormatUtils.getRegion(locale);
            if (!string2.isEmpty()) {
                string = string + "-" + string2;
            }
            objectOutput.writeUTF(string);
            objectOutput.writeUTF(element.getCalendarType());
        }
    }

    private Object readDayPeriod(ObjectInput objectInput, byte by2) throws IOException, ClassNotFoundException {
        boolean bl2;
        boolean bl3 = (by2 & 1) == 1;
        boolean bl4 = bl2 = (by2 & 2) == 2;
        if (bl2) {
            Map map = (Map)objectInput.readObject();
            return new DayPeriod.Element(bl3, DayPeriod.of(map));
        }
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        int n2 = string.indexOf("-");
        Locale locale = n2 == -1 ? new Locale(string) : new Locale(string.substring(0, n2), string.substring(n2 + 1));
        return new DayPeriod.Element(bl3, locale, string2);
    }

    private void writeMachineTime(ObjectOutput objectOutput) throws IOException {
        MachineTime machineTime = (MachineTime)MachineTime.class.cast(this.obj);
        int n2 = 5;
        n2 <<= 4;
        if (machineTime.getScale() == TimeScale.UTC) {
            n2 |= 1;
        }
        if (machineTime.getFraction() == 0) {
            objectOutput.writeByte(n2);
            objectOutput.writeLong(machineTime.getSeconds());
        } else {
            objectOutput.writeByte(n2 |= 2);
            objectOutput.writeLong(machineTime.getSeconds());
            objectOutput.writeInt(machineTime.getFraction());
        }
    }

    private Object readMachineTime(ObjectInput objectInput, byte by2) throws IOException {
        int n2;
        TimeScale timeScale = (by2 & 1) == 1 ? TimeScale.UTC : TimeScale.POSIX;
        long l2 = objectInput.readLong();
        int n3 = n2 = (by2 & 2) == 2 ? objectInput.readInt() : 0;
        if (timeScale == TimeScale.UTC) {
            return MachineTime.ofSIUnits(l2, n2);
        }
        return MachineTime.ofPosixUnits(l2, n2);
    }
}

