/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;

final class ProportionalFunction
implements ChronoFunction<ChronoEntity<?>, BigDecimal> {
    private final ChronoElement<? extends Number> element;
    private final boolean extendedRange;

    ProportionalFunction(ChronoElement<? extends Number> chronoElement, boolean bl2) {
        this.element = chronoElement;
        this.extendedRange = bl2;
    }

    @Override
    public BigDecimal apply(ChronoEntity<?> chronoEntity) {
        long l2 = chronoEntity.get(this.element).longValue();
        long l3 = chronoEntity.getMinimum(this.element).longValue();
        long l4 = chronoEntity.getMaximum(this.element).longValue();
        if (l2 > l4) {
            l2 = l4;
        }
        if (l2 == l3) {
            return BigDecimal.ZERO;
        }
        if (this.extendedRange && chronoEntity instanceof PlainTime && !((PlainTime)PlainTime.class.cast(chronoEntity)).hasReducedRange(this.element)) {
            if (l2 == l4) {
                return BigDecimal.ONE;
            }
            --l4;
        }
        BigDecimal bigDecimal = new BigDecimal(l2 - l3).setScale(15, RoundingMode.UNNECESSARY);
        BigDecimal bigDecimal2 = new BigDecimal(l4 - l3 + 1L);
        return bigDecimal.divide(bigDecimal2, RoundingMode.HALF_UP).stripTrailingZeros();
    }
}

