/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.AdjustableElement;
import net.time4j.CalendarDateElement;
import net.time4j.CalendarUnit;
import net.time4j.DateElement;
import net.time4j.Duration;
import net.time4j.EnumElement;
import net.time4j.IntegerDateElement;
import net.time4j.IsoDateUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.NavigableElement;
import net.time4j.OrdinalWeekdayElement;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.ProportionalElement;
import net.time4j.Quarter;
import net.time4j.SPX;
import net.time4j.TemporalType;
import net.time4j.WeekExtension;
import net.time4j.Weekcycle;
import net.time4j.Weekday;
import net.time4j.WeekdayInMonthElement;
import net.time4j.Weekmodel;
import net.time4j.YOWElement;
import net.time4j.ZonalClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.Normalizer;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeSpan;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;

@CalendarType(value="iso8601")
public final class PlainDate
extends Calendrical<IsoDateUnit, PlainDate>
implements GregorianDate,
Normalizer<CalendarUnit>,
ThreetenAdapter,
LocalizedPatternSupport {
    private static final int WIM_INDEX = 19;
    static final PlainDate MIN = new PlainDate(-999999999, 1, 1, Weekday.MONDAY);
    static final PlainDate MAX = new PlainDate(999999999, 12, 31, Weekday.FRIDAY);
    static final Integer MIN_YEAR = -999999999;
    static final Integer MAX_YEAR = 999999999;
    private static final Integer VALUE_1 = 1;
    private static final Integer VALUE_12 = 12;
    private static final Integer STD_YEAR_LEN = 365;
    private static final Integer LEAP_YEAR_LEN = 366;
    private static final int[] DAY_OF_YEAR_PER_MONTH = new int[12];
    private static final int[] DAY_OF_LEAP_YEAR_PER_MONTH = new int[12];
    static final ChronoElement<PlainDate> CALENDAR_DATE;
    public static final CalendarDateElement COMPONENT;
    @FormattableElement(format="u")
    public static final AdjustableElement<Integer, PlainDate> YEAR;
    @FormattableElement(format="Y")
    public static final AdjustableElement<Integer, PlainDate> YEAR_OF_WEEKDATE;
    @FormattableElement(format="Q", alt="q")
    public static final NavigableElement<Quarter> QUARTER_OF_YEAR;
    @FormattableElement(format="M", alt="L")
    public static final NavigableElement<Month> MONTH_OF_YEAR;
    @FormattableElement(format="M")
    public static final ProportionalElement<Integer, PlainDate> MONTH_AS_NUMBER;
    @FormattableElement(format="d")
    public static final ProportionalElement<Integer, PlainDate> DAY_OF_MONTH;
    @FormattableElement(format="E")
    public static final NavigableElement<Weekday> DAY_OF_WEEK;
    @FormattableElement(format="D")
    public static final ProportionalElement<Integer, PlainDate> DAY_OF_YEAR;
    public static final ProportionalElement<Integer, PlainDate> DAY_OF_QUARTER;
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement WEEKDAY_IN_MONTH;
    private static final long serialVersionUID = -6698431452072325688L;
    private static final Map<String, Object> ELEMENTS;
    private static final CalendarSystem<PlainDate> TRANSFORMER;
    private static final TimeAxis<IsoDateUnit, PlainDate> ENGINE;
    private static final Chronology<LocalDate> THREETEN;
    private final transient int year;
    private final transient byte month;
    private final transient byte dayOfMonth;
    private final transient Weekday weekday;

    private PlainDate(int n2, int n3, int n4, Weekday weekday) {
        this.year = n2;
        this.month = (byte)n3;
        this.dayOfMonth = (byte)n4;
        this.weekday = weekday;
    }

    public static PlainDate of(int n2, int n3, int n4) {
        return PlainDate.create(n2, n3, n4, null, true);
    }

    public static PlainDate of(int n2, Month month, int n3) {
        return PlainDate.create(n2, month.getValue(), n3, null, true);
    }

    public static PlainDate of(int n2, int n3) {
        return PlainDate.ofYearDay(n2, n3, null);
    }

    public static PlainDate of(int n2, int n3, Weekday weekday) {
        return PlainDate.ofWeekdate(n2, n3, weekday, true);
    }

    public static PlainDate of(long l2, EpochDays epochDays) {
        return TRANSFORMER.transform(EpochDays.UTC.transform(l2, epochDays));
    }

    public static PlainDate nowInSystemTime() {
        return ZonalClock.ofSystem().today();
    }

    public static PlainDate from(GregorianDate gregorianDate) {
        if (gregorianDate instanceof PlainDate) {
            return (PlainDate)gregorianDate;
        }
        return PlainDate.of(gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
    }

    public static PlainDate from(LocalDate localDate) {
        return TemporalType.LOCAL_DATE.translate(localDate);
    }

    public PlainTimestamp atStartOfDay() {
        return this.at(PlainTime.MIN);
    }

    public PlainTimestamp atStartOfDay(TZID tZID) {
        return this.atStartOfDay(Timezone.of(tZID).getHistory());
    }

    public PlainTimestamp atStartOfDay(String string) {
        return this.atStartOfDay(Timezone.of(string).getHistory());
    }

    public Moment atFirstMoment(TZID tZID) {
        return this.atFirstMoment(Timezone.of(tZID));
    }

    public Moment atFirstMoment(String string) {
        return this.atFirstMoment(Timezone.of(string));
    }

    public PlainTimestamp at(PlainTime plainTime) {
        return PlainTimestamp.of(this, plainTime);
    }

    public PlainTimestamp atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    public PlainTimestamp atTime(int n2, int n3, int n4) {
        return this.at(PlainTime.of(n2, n3, n4));
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        Weekday weekday = this.weekday;
        if (weekday == null) {
            weekday = Weekday.valueOf(GregorianMath.getDayOfWeek(this.year, this.month, this.dayOfMonth));
        }
        return weekday;
    }

    public int getDayOfYear() {
        switch (this.month) {
            case 1: {
                return this.dayOfMonth;
            }
            case 2: {
                return 31 + this.dayOfMonth;
            }
        }
        return DAY_OF_YEAR_PER_MONTH[this.month - 2] + this.dayOfMonth + (GregorianMath.isLeapYear(this.year) ? 1 : 0);
    }

    public int lengthOfMonth() {
        return GregorianMath.getLengthOfMonth(this.year, this.month);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return GregorianMath.isLeapYear(this.year);
    }

    public boolean isWeekend(Locale locale) {
        return this.matches(Weekmodel.of(locale).weekend());
    }

    public static boolean isValid(int n2, int n3, int n4) {
        return GregorianMath.isValid(n2, n3, n4);
    }

    @Override
    public PlainDate plus(long l2, CalendarUnit calendarUnit) {
        if (calendarUnit == null) {
            throw new NullPointerException("Missing unit.");
        }
        if (l2 == 0L) {
            return this;
        }
        try {
            return PlainDate.doAdd(calendarUnit, this, l2, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    @Override
    public PlainDate minus(long l2, CalendarUnit calendarUnit) {
        return this.plus(Math.negateExact(l2), calendarUnit);
    }

    public String print(TemporalFormatter<PlainDate> temporalFormatter) {
        return temporalFormatter.print(this);
    }

    public static PlainDate parse(String string, TemporalFormatter<PlainDate> temporalFormatter) {
        try {
            return temporalFormatter.parse(string);
        }
        catch (ParseException parseException) {
            throw new ChronoException(parseException.getMessage(), parseException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PlainDate) {
            PlainDate plainDate = (PlainDate)object;
            return this.dayOfMonth == plainDate.dayOfMonth && this.month == plainDate.month && this.year == plainDate.year;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = this.year;
        return n2 & 0xFFFFF800 ^ (n2 << 11) + (this.month << 6) + this.dayOfMonth;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        PlainDate.formatYear(stringBuilder, this.year);
        PlainDate.format2Digits(stringBuilder, this.month);
        PlainDate.format2Digits(stringBuilder, this.dayOfMonth);
        return stringBuilder.toString();
    }

    @Override
    public Duration<CalendarUnit> normalize(TimeSpan<? extends CalendarUnit> timeSpan) {
        return this.until((PlainDate)this.plus(timeSpan), Duration.inYearsMonthsDays());
    }

    @Override
    public LocalDate toTemporalAccessor() {
        return TemporalType.LOCAL_DATE.from(this);
    }

    @Override
    public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
        return ENGINE.getFormatPattern(formatStyle, locale);
    }

    public static TimeAxis<IsoDateUnit, PlainDate> axis() {
        return ENGINE;
    }

    public static Chronology<LocalDate> threeten() {
        return THREETEN;
    }

    @Override
    protected TimeAxis<IsoDateUnit, PlainDate> getChronology() {
        return ENGINE;
    }

    @Override
    protected PlainDate getContext() {
        return this;
    }

    @Override
    protected int compareByTime(CalendarDate calendarDate) {
        if (calendarDate instanceof PlainDate) {
            PlainDate plainDate = this;
            PlainDate plainDate2 = (PlainDate)calendarDate;
            int n2 = plainDate.year - plainDate2.year;
            if (n2 == 0 && (n2 = plainDate.month - plainDate2.month) == 0) {
                n2 = plainDate.dayOfMonth - plainDate2.dayOfMonth;
            }
            return n2;
        }
        return super.compareByTime(calendarDate);
    }

    long getDaysSinceUTC() {
        return TRANSFORMER.transform(this);
    }

    PlainDate withDaysSinceUTC(long l2) {
        return TRANSFORMER.transform(l2);
    }

    static PlainDate from(UnixTime unixTime, ZonalOffset zonalOffset) {
        long l2 = unixTime.getPosixTime() + (long)zonalOffset.getIntegralAmount();
        int n2 = unixTime.getNanosecond() + zonalOffset.getFractionalAmount();
        if (n2 < 0) {
            --l2;
        } else if (n2 >= 1000000000) {
            ++l2;
        }
        long l3 = EpochDays.MODIFIED_JULIAN_DATE.transform(MathUtils.floorDivide(l2, 86400), EpochDays.UNIX);
        long l4 = GregorianMath.toPackedDate(l3);
        return PlainDate.of(GregorianMath.readYear(l4), GregorianMath.readMonth(l4), GregorianMath.readDayOfMonth(l4));
    }

    static Object lookupElement(String string) {
        return ELEMENTS.get(string);
    }

    static PlainDate doAdd(CalendarUnit calendarUnit, PlainDate plainDate, long l2, int n2) {
        switch (calendarUnit) {
            case MILLENNIA: {
                return PlainDate.doAdd(CalendarUnit.MONTHS, plainDate, MathUtils.safeMultiply(l2, 12000L), n2);
            }
            case CENTURIES: {
                return PlainDate.doAdd(CalendarUnit.MONTHS, plainDate, MathUtils.safeMultiply(l2, 1200L), n2);
            }
            case DECADES: {
                return PlainDate.doAdd(CalendarUnit.MONTHS, plainDate, MathUtils.safeMultiply(l2, 120L), n2);
            }
            case YEARS: {
                return PlainDate.doAdd(CalendarUnit.MONTHS, plainDate, MathUtils.safeMultiply(l2, 12L), n2);
            }
            case QUARTERS: {
                return PlainDate.doAdd(CalendarUnit.MONTHS, plainDate, MathUtils.safeMultiply(l2, 3L), n2);
            }
            case MONTHS: {
                long l3 = MathUtils.safeAdd(plainDate.getEpochMonths(), l2);
                return PlainDate.fromEpochMonths(plainDate, l3, plainDate.dayOfMonth, n2);
            }
            case WEEKS: {
                return PlainDate.doAdd(CalendarUnit.DAYS, plainDate, MathUtils.safeMultiply(l2, 7L), n2);
            }
            case DAYS: {
                return PlainDate.addDays(plainDate, l2);
            }
        }
        throw new UnsupportedOperationException(calendarUnit.name());
    }

    long getEpochMonths() {
        return (long)(this.year - 1970) * 12L + (long)this.month - 1L;
    }

    int getWeekOfYear() {
        return (Integer)this.get(Weekmodel.ISO.weekOfYear());
    }

    private PlainTimestamp atStartOfDay(TransitionHistory transitionHistory) {
        if (transitionHistory == null) {
            throw new UnsupportedOperationException("Timezone repository does not expose its transition history: " + Timezone.getProviderInfo());
        }
        ZonalTransition zonalTransition = transitionHistory.getConflictTransition(this, PlainTime.MIN);
        if (zonalTransition != null && zonalTransition.isGap()) {
            long l2 = zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset();
            PlainDate plainDate = PlainDate.of(MathUtils.floorDivide(l2, 86400), EpochDays.UNIX);
            int n2 = MathUtils.floorModulo(l2, 86400);
            int n3 = n2 % 60;
            int n4 = n2 / 60;
            int n5 = n4 % 60;
            int n6 = n4 / 60;
            PlainTime plainTime = PlainTime.of(n6, n5, n3);
            return PlainTimestamp.of(plainDate, plainTime);
        }
        return this.at(PlainTime.MIN);
    }

    private Moment atFirstMoment(Timezone timezone) {
        TransitionHistory transitionHistory = timezone.getHistory();
        if (transitionHistory == null) {
            throw new UnsupportedOperationException("Timezone repository does not expose its transition history: " + Timezone.getProviderInfo());
        }
        ZonalTransition zonalTransition = transitionHistory.getConflictTransition(this, PlainTime.MIN);
        if (zonalTransition != null && zonalTransition.isGap()) {
            return Moment.of(zonalTransition.getPosixTime(), TimeScale.POSIX);
        }
        return this.at(PlainTime.MIN).in(timezone);
    }

    private int getDayOfQuarter() {
        switch (this.month) {
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                return this.dayOfMonth;
            }
            case 2: 
            case 8: 
            case 11: {
                return 31 + this.dayOfMonth;
            }
            case 3: {
                return (GregorianMath.isLeapYear(this.year) ? 60 : 59) + this.dayOfMonth;
            }
            case 5: {
                return 30 + this.dayOfMonth;
            }
            case 6: 
            case 12: {
                return 61 + this.dayOfMonth;
            }
            case 9: {
                return 62 + this.dayOfMonth;
            }
        }
        throw new AssertionError((Object)("Unknown month: " + this.month));
    }

    private PlainDate withYear(int n2) {
        if (this.year == n2) {
            return this;
        }
        int n3 = GregorianMath.getLengthOfMonth(n2, this.month);
        return PlainDate.of(n2, (int)this.month, Math.min(n3, this.dayOfMonth));
    }

    private PlainDate withMonth(int n2) {
        if (this.month == n2) {
            return this;
        }
        int n3 = GregorianMath.getLengthOfMonth(this.year, n2);
        return PlainDate.of(this.year, n2, Math.min(n3, this.dayOfMonth));
    }

    private PlainDate withDayOfMonth(int n2) {
        if (this.dayOfMonth == n2) {
            return this;
        }
        return PlainDate.of(this.year, (int)this.month, n2);
    }

    private PlainDate withDayOfWeek(Weekday weekday) {
        PlainDate plainDate;
        Weekday weekday2 = this.getDayOfWeek();
        PlainDate plainDate2 = plainDate = this.weekday == null ? new PlainDate(this.year, this.month, this.dayOfMonth, weekday2) : this;
        if (weekday2 == weekday) {
            return plainDate;
        }
        return PlainDate.addDays(plainDate, weekday.getValue() - weekday2.getValue());
    }

    private PlainDate withDayOfYear(int n2) {
        if (this.getDayOfYear() == n2) {
            return this;
        }
        return PlainDate.of(this.year, n2);
    }

    private static PlainDate fromEpochMonths(PlainDate plainDate, long l2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        block9: {
            int n7;
            block8: {
                if (n3 == 5 && plainDate.dayOfMonth == plainDate.lengthOfMonth()) {
                    n3 = 2;
                }
                n6 = MathUtils.safeCast(MathUtils.safeAdd(MathUtils.floorDivide(l2, 12), 1970L));
                n5 = MathUtils.floorModulo(l2, 12) + 1;
                n7 = GregorianMath.getLengthOfMonth(n6, n5);
                n4 = n2;
                if (n2 <= n7) break block8;
                switch (n3) {
                    case 0: 
                    case 2: 
                    case 5: 
                    case 6: {
                        n4 = n7;
                        break block9;
                    }
                    case 1: {
                        return PlainDate.fromEpochMonths(plainDate, MathUtils.safeAdd(l2, 1L), 1, n3);
                    }
                    case 3: {
                        return PlainDate.fromEpochMonths(plainDate, MathUtils.safeAdd(l2, 1L), n2 - n7, n3);
                    }
                    case 4: {
                        StringBuilder stringBuilder = new StringBuilder(32);
                        stringBuilder.append("Day of month out of range: ");
                        PlainDate.formatYear(stringBuilder, n6);
                        PlainDate.format2Digits(stringBuilder, n5);
                        PlainDate.format2Digits(stringBuilder, n2);
                        throw new ChronoException(stringBuilder.toString());
                    }
                    default: {
                        throw new UnsupportedOperationException("Overflow policy not implemented: " + n3);
                    }
                }
            }
            if (n2 < n7 && n3 == 2) {
                n4 = n7;
            }
        }
        return PlainDate.of(n6, n5, n4);
    }

    private static PlainDate addDays(PlainDate plainDate, long l2) {
        boolean bl2;
        long l3 = MathUtils.safeAdd((long)plainDate.dayOfMonth, l2);
        Weekday weekday = null;
        boolean bl3 = bl2 = plainDate.weekday != null;
        if (bl2) {
            if (l2 == 1L) {
                weekday = plainDate.weekday.next();
            } else if (l2 == 7L) {
                weekday = plainDate.weekday;
            }
        }
        if (l3 >= 1L && l3 <= 28L) {
            if (bl2 && weekday == null) {
                weekday = plainDate.weekday.roll((int)l2);
            }
            return PlainDate.create(plainDate.year, plainDate.month, (int)l3, weekday, false);
        }
        long l4 = MathUtils.safeAdd((long)plainDate.getDayOfYear(), l2);
        if (l4 >= 1L && l4 <= 365L) {
            if (bl2 && weekday == null) {
                weekday = plainDate.weekday.roll((int)l2);
            }
            return PlainDate.ofYearDay(plainDate.year, (int)l4, weekday);
        }
        return TRANSFORMER.transform(MathUtils.safeAdd(plainDate.getDaysSinceUTC(), l2));
    }

    private static void fill(Map<String, Object> map, ChronoElement<?> chronoElement) {
        map.put(chronoElement.name(), chronoElement);
    }

    private static void formatYear(StringBuilder stringBuilder, int n2) {
        int n3 = n2;
        if (n3 < 0) {
            stringBuilder.append('-');
            n3 = MathUtils.safeNegate(n2);
        }
        if (n3 >= 10000) {
            if (n2 > 0) {
                stringBuilder.append('+');
            }
        } else if (n3 < 1000) {
            stringBuilder.append('0');
            if (n3 < 100) {
                stringBuilder.append('0');
                if (n3 < 10) {
                    stringBuilder.append('0');
                }
            }
        }
        stringBuilder.append(n3);
    }

    private static void format2Digits(StringBuilder stringBuilder, int n2) {
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }

    private static void registerExtensions(TimeAxis.Builder<IsoDateUnit, PlainDate> builder) {
        for (ChronoExtension chronoExtension : ResourceLoader.getInstance().services(ChronoExtension.class)) {
            if (!chronoExtension.accept(PlainDate.class)) continue;
            builder.appendExtension(chronoExtension);
        }
        builder.appendExtension(new WeekExtension());
    }

    private static void registerUnits(TimeAxis.Builder<IsoDateUnit, PlainDate> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, new CalendarUnit.Rule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private static String yowFailed(int n2) {
        return "YEAR_OF_WEEKDATE (ISO) out of range: " + n2;
    }

    private static String woyFailed(int n2) {
        return "WEEK_OF_YEAR (ISO) out of range: " + n2;
    }

    private static PlainDate ofWeekdate(int n2, int n3, Weekday weekday, boolean bl2) {
        if (n3 < 1 || n3 > 53) {
            if (bl2) {
                throw new IllegalArgumentException(PlainDate.woyFailed(n3));
            }
            return null;
        }
        if (bl2 && (n2 < MIN_YEAR || n2 > MAX_YEAR)) {
            throw new IllegalArgumentException(PlainDate.yowFailed(n2));
        }
        Weekday weekday2 = Weekday.valueOf(GregorianMath.getDayOfWeek(n2, 1, 1));
        int n4 = weekday2.getValue();
        int n5 = (n4 <= 4 ? 2 - n4 : 9 - n4) + (n3 - 1) * 7 + weekday.getValue() - 1;
        int n6 = n2;
        if (n5 <= 0) {
            n5 += GregorianMath.isLeapYear(--n6) ? 366 : 365;
        } else {
            int n7;
            int n8 = n7 = GregorianMath.isLeapYear(n6) ? 366 : 365;
            if (n5 > n7) {
                n5 -= n7;
                ++n6;
            }
        }
        PlainDate plainDate = PlainDate.ofYearDay(n6, n5, weekday);
        if (n3 == 53 && plainDate.getWeekOfYear() != 53) {
            if (bl2) {
                throw new IllegalArgumentException(PlainDate.woyFailed(n3));
            }
            return null;
        }
        return plainDate;
    }

    private static PlainDate ofYearDay(int n2, int n3, Weekday weekday) {
        int n4;
        if (n3 < 1) {
            throw new IllegalArgumentException("Day of year out of range: " + n3);
        }
        if (n3 <= 31) {
            return PlainDate.of(n2, 1, n3);
        }
        int[] nArray = GregorianMath.isLeapYear(n2) ? DAY_OF_LEAP_YEAR_PER_MONTH : DAY_OF_YEAR_PER_MONTH;
        int n5 = n4 = n3 > nArray[6] ? 7 : 1;
        while (n4 < 12) {
            if (n3 <= nArray[n4]) {
                int n6 = n3 - nArray[n4 - 1];
                return PlainDate.create(n2, n4 + 1, n6, weekday, false);
            }
            ++n4;
        }
        throw new IllegalArgumentException("Day of year out of range: " + n3);
    }

    private static PlainDate create(int n2, int n3, int n4, Weekday weekday, boolean bl2) {
        if (bl2) {
            GregorianMath.checkDate(n2, n3, n4);
        }
        return new PlainDate(n2, n3, n4, weekday);
    }

    private Object writeReplace() {
        return new SPX(this, 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        PlainDate.DAY_OF_YEAR_PER_MONTH[0] = 31;
        PlainDate.DAY_OF_YEAR_PER_MONTH[1] = 59;
        PlainDate.DAY_OF_YEAR_PER_MONTH[2] = 90;
        PlainDate.DAY_OF_YEAR_PER_MONTH[3] = 120;
        PlainDate.DAY_OF_YEAR_PER_MONTH[4] = 151;
        PlainDate.DAY_OF_YEAR_PER_MONTH[5] = 181;
        PlainDate.DAY_OF_YEAR_PER_MONTH[6] = 212;
        PlainDate.DAY_OF_YEAR_PER_MONTH[7] = 243;
        PlainDate.DAY_OF_YEAR_PER_MONTH[8] = 273;
        PlainDate.DAY_OF_YEAR_PER_MONTH[9] = 304;
        PlainDate.DAY_OF_YEAR_PER_MONTH[10] = 334;
        PlainDate.DAY_OF_YEAR_PER_MONTH[11] = 365;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[0] = 31;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[1] = 60;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[2] = 91;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[3] = 121;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[4] = 152;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[5] = 182;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[6] = 213;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[7] = 244;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[8] = 274;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[9] = 305;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[10] = 335;
        PlainDate.DAY_OF_LEAP_YEAR_PER_MONTH[11] = 366;
        CALENDAR_DATE = DateElement.INSTANCE;
        COMPONENT = DateElement.INSTANCE;
        YEAR = IntegerDateElement.create("YEAR", 14, -999999999, 999999999, 'u');
        YEAR_OF_WEEKDATE = YOWElement.INSTANCE;
        QUARTER_OF_YEAR = new EnumElement<Quarter>("QUARTER_OF_YEAR", Quarter.class, Quarter.Q1, Quarter.Q4, 103, 'Q');
        MONTH_OF_YEAR = new EnumElement<Month>("MONTH_OF_YEAR", Month.class, Month.JANUARY, Month.DECEMBER, 101, 'M');
        MONTH_AS_NUMBER = IntegerDateElement.create("MONTH_AS_NUMBER", 15, 1, 12, 'M');
        DAY_OF_MONTH = IntegerDateElement.create("DAY_OF_MONTH", 16, 1, 31, 'd');
        DAY_OF_WEEK = new EnumElement<Weekday>("DAY_OF_WEEK", Weekday.class, Weekday.MONDAY, Weekday.SUNDAY, 102, 'E');
        DAY_OF_YEAR = IntegerDateElement.create("DAY_OF_YEAR", 17, 1, 365, 'D');
        DAY_OF_QUARTER = IntegerDateElement.create("DAY_OF_QUARTER", 18, 1, 92, '\u0000');
        WEEKDAY_IN_MONTH = WeekdayInMonthElement.INSTANCE;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PlainDate.fill(hashMap, CALENDAR_DATE);
        PlainDate.fill(hashMap, YEAR);
        PlainDate.fill(hashMap, YEAR_OF_WEEKDATE);
        PlainDate.fill(hashMap, QUARTER_OF_YEAR);
        PlainDate.fill(hashMap, MONTH_OF_YEAR);
        PlainDate.fill(hashMap, MONTH_AS_NUMBER);
        PlainDate.fill(hashMap, DAY_OF_MONTH);
        PlainDate.fill(hashMap, DAY_OF_WEEK);
        PlainDate.fill(hashMap, DAY_OF_YEAR);
        PlainDate.fill(hashMap, DAY_OF_QUARTER);
        PlainDate.fill(hashMap, WEEKDAY_IN_MONTH);
        ELEMENTS = Collections.unmodifiableMap(hashMap);
        TRANSFORMER = new Transformer();
        TimeAxis.Builder<IsoDateUnit, PlainDate> builder = TimeAxis.Builder.setUp(IsoDateUnit.class, PlainDate.class, new Merger(), TRANSFORMER).appendElement(CALENDAR_DATE, new DateElementRule(), CalendarUnit.DAYS).appendElement(YEAR, new IntegerElementRule(YEAR), CalendarUnit.YEARS).appendElement(YEAR_OF_WEEKDATE, YOWElement.elementRule(PlainDate.class), Weekcycle.YEARS).appendElement(QUARTER_OF_YEAR, EnumElementRule.of(QUARTER_OF_YEAR), CalendarUnit.QUARTERS).appendElement(MONTH_OF_YEAR, EnumElementRule.of(MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement(MONTH_AS_NUMBER, new IntegerElementRule(MONTH_AS_NUMBER), CalendarUnit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerElementRule(DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, EnumElementRule.of(DAY_OF_WEEK), CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, new IntegerElementRule(DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(DAY_OF_QUARTER, new IntegerElementRule(DAY_OF_QUARTER), CalendarUnit.DAYS).appendElement(WEEKDAY_IN_MONTH, new IntegerElementRule(19, WEEKDAY_IN_MONTH), CalendarUnit.WEEKS);
        PlainDate.registerUnits(builder);
        PlainDate.registerExtensions(builder);
        ENGINE = builder.build();
        THREETEN = new BridgeChronology<LocalDate, PlainDate>(TemporalType.LOCAL_DATE, ENGINE);
    }

    private static class Transformer
    implements CalendarSystem<PlainDate> {
        private static final long MIN_LONG = -365243219892L;
        private static final long MAX_LONG = 365241779741L;

        private Transformer() {
        }

        @Override
        public PlainDate transform(long l2) {
            if (l2 == -365243219892L) {
                return MIN;
            }
            if (l2 == 365241779741L) {
                return MAX;
            }
            long l3 = EpochDays.MODIFIED_JULIAN_DATE.transform(l2, EpochDays.UTC);
            long l4 = GregorianMath.toPackedDate(l3);
            return PlainDate.create(GregorianMath.readYear(l4), GregorianMath.readMonth(l4), GregorianMath.readDayOfMonth(l4), Weekmodel.getDayOfWeek(l2), false);
        }

        @Override
        public long transform(PlainDate plainDate) {
            return EpochDays.UTC.transform(GregorianMath.toMJD(plainDate), EpochDays.MODIFIED_JULIAN_DATE);
        }

        @Override
        public long getMinimumSinceUTC() {
            return -365243219892L;
        }

        @Override
        public long getMaximumSinceUTC() {
            return 365241779741L;
        }

        @Override
        public List<CalendarEra> getEras() {
            return Collections.emptyList();
        }
    }

    private static class Merger
    implements ChronoMerger<PlainDate> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return CalendarText.patternForDate(formatStyle, locale);
        }

        @Override
        public PlainDate createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            Object obj = timeSource.currentTime();
            return PlainDate.from(obj, timezone.getOffset((UnixTime)obj));
        }

        @Override
        public PlainDate createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2;
            int n3;
            if (chronoEntity.contains(CALENDAR_DATE)) {
                return chronoEntity.get(CALENDAR_DATE);
            }
            int n4 = chronoEntity.getInt(YEAR);
            if (n4 != Integer.MIN_VALUE) {
                n3 = chronoEntity.getInt(MONTH_AS_NUMBER);
                if (n3 == Integer.MIN_VALUE && chronoEntity.contains(MONTH_OF_YEAR)) {
                    n3 = chronoEntity.get(MONTH_OF_YEAR).getValue();
                }
                if (n3 != Integer.MIN_VALUE && (n2 = chronoEntity.getInt(DAY_OF_MONTH)) != Integer.MIN_VALUE) {
                    if (bl2) {
                        PlainDate plainDate = PlainDate.of(n4, 1, 1);
                        plainDate = plainDate.with(MONTH_AS_NUMBER.setLenient(n3));
                        return plainDate.with(DAY_OF_MONTH.setLenient(n2));
                    }
                    if (Merger.validateYear(chronoEntity, n4) && Merger.validateMonth(chronoEntity, n3) && Merger.validateDayOfMonth(chronoEntity, n4, n3, n2)) {
                        return PlainDate.create(n4, n3, n2, null, false);
                    }
                    return null;
                }
                n2 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n2 != Integer.MIN_VALUE) {
                    if (bl2) {
                        PlainDate plainDate = PlainDate.of(n4, 1);
                        return plainDate.with(DAY_OF_YEAR.setLenient(n2));
                    }
                    if (Merger.validateYear(chronoEntity, n4) && Merger.validateDayOfYear(chronoEntity, n4, n2)) {
                        return PlainDate.of(n4, n2);
                    }
                    return null;
                }
                int n5 = chronoEntity.getInt(DAY_OF_QUARTER);
                if (n5 != Integer.MIN_VALUE && chronoEntity.contains(QUARTER_OF_YEAR)) {
                    Quarter quarter = chronoEntity.get(QUARTER_OF_YEAR);
                    boolean bl4 = GregorianMath.isLeapYear(n4);
                    n2 = n5 + (bl4 ? 91 : 90);
                    if (quarter == Quarter.Q1) {
                        n2 = n5;
                    } else if (quarter == Quarter.Q3) {
                        n2 += 91;
                    } else if (quarter == Quarter.Q4) {
                        n2 += 183;
                    }
                    if (bl2) {
                        PlainDate plainDate = PlainDate.of(n4, 1);
                        return plainDate.with(DAY_OF_YEAR.setLenient(n2));
                    }
                    if (Merger.validateYear(chronoEntity, n4) && Merger.validateDayOfQuarter(chronoEntity, bl4, quarter, n5)) {
                        return PlainDate.of(n4, n2);
                    }
                    return null;
                }
            }
            if ((n3 = chronoEntity.getInt(YEAR_OF_WEEKDATE)) != Integer.MIN_VALUE && chronoEntity.contains(Weekmodel.ISO.weekOfYear())) {
                Weekday weekday;
                n2 = (Integer)chronoEntity.get(Weekmodel.ISO.weekOfYear());
                if (chronoEntity.contains(DAY_OF_WEEK)) {
                    weekday = chronoEntity.get(DAY_OF_WEEK);
                } else if (chronoEntity.contains(Weekmodel.ISO.localDayOfWeek())) {
                    weekday = chronoEntity.get(Weekmodel.ISO.localDayOfWeek());
                } else {
                    return null;
                }
                if (n3 < -999999999 || n3 > 999999999) {
                    Merger.flagValidationError(chronoEntity, PlainDate.yowFailed(n3));
                    return null;
                }
                PlainDate plainDate = PlainDate.ofWeekdate(n3, n2, weekday, false);
                if (plainDate == null) {
                    Merger.flagValidationError(chronoEntity, PlainDate.woyFailed(n2));
                }
                return plainDate;
            }
            if (chronoEntity.contains(EpochDays.MODIFIED_JULIAN_DATE)) {
                Long l2 = chronoEntity.get(EpochDays.MODIFIED_JULIAN_DATE);
                long l3 = EpochDays.UTC.transform(l2, EpochDays.MODIFIED_JULIAN_DATE);
                return (PlainDate)TRANSFORMER.transform(l3);
            }
            if (chronoEntity instanceof UnixTime) {
                return ((PlainTimestamp)PlainTimestamp.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl3)).getCalendarDate();
            }
            return null;
        }

        private static boolean validateYear(ChronoEntity<?> chronoEntity, int n2) {
            if (n2 < -999999999 || n2 > 999999999) {
                Merger.flagValidationError(chronoEntity, "YEAR out of range: " + n2);
                return false;
            }
            return true;
        }

        private static boolean validateMonth(ChronoEntity<?> chronoEntity, int n2) {
            if (n2 < 1 || n2 > 12) {
                Merger.flagValidationError(chronoEntity, "MONTH_OF_YEAR out of range: " + n2);
                return false;
            }
            return true;
        }

        private static boolean validateDayOfMonth(ChronoEntity<?> chronoEntity, int n2, int n3, int n4) {
            if (n4 < 1 || n4 > 28 && n4 > GregorianMath.getLengthOfMonth(n2, n3)) {
                Merger.flagValidationError(chronoEntity, "DAY_OF_MONTH out of range: " + n4);
                return false;
            }
            return true;
        }

        private static boolean validateDayOfYear(ChronoEntity<?> chronoEntity, int n2, int n3) {
            if (n3 < 1 || n3 > 365 && n3 > (GregorianMath.isLeapYear(n2) ? 366 : 365)) {
                Merger.flagValidationError(chronoEntity, "DAY_OF_YEAR out of range: " + n3);
                return false;
            }
            return true;
        }

        private static boolean validateDayOfQuarter(ChronoEntity<?> chronoEntity, boolean bl2, Quarter quarter, int n2) {
            int n3;
            switch (quarter) {
                case Q1: {
                    n3 = bl2 ? 91 : 90;
                    break;
                }
                case Q2: {
                    n3 = 91;
                    break;
                }
                default: {
                    n3 = 92;
                }
            }
            if (n2 < 1 || n2 > n3) {
                Merger.flagValidationError(chronoEntity, "DAY_OF_QUARTER out of range: " + n2);
                return false;
            }
            return true;
        }

        private static void flagValidationError(ChronoEntity<?> chronoEntity, String string) {
            if (chronoEntity.isValid(ValidationElement.ERROR_MESSAGE, string)) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, string);
            }
        }
    }

    private static class DateElementRule
    implements ElementRule<PlainDate, PlainDate> {
        private DateElementRule() {
        }

        @Override
        public PlainDate getValue(PlainDate plainDate) {
            return plainDate;
        }

        @Override
        public PlainDate withValue(PlainDate plainDate, PlainDate plainDate2, boolean bl2) {
            if (plainDate2 == null) {
                throw new IllegalArgumentException("Missing date value.");
            }
            return plainDate2;
        }

        @Override
        public boolean isValid(PlainDate plainDate, PlainDate plainDate2) {
            return plainDate2 != null;
        }

        @Override
        public PlainDate getMinimum(PlainDate plainDate) {
            return MIN;
        }

        @Override
        public PlainDate getMaximum(PlainDate plainDate) {
            return MAX;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainDate plainDate) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainDate plainDate) {
            return null;
        }
    }

    private static class IntegerElementRule
    implements IntElementRule<PlainDate> {
        private final ChronoElement<?> ref;
        private final String name;
        private final int index;

        IntegerElementRule(ChronoElement<Integer> chronoElement) {
            this(((IntegerDateElement)chronoElement).getRuleIndex(), chronoElement);
        }

        IntegerElementRule(int n2, ChronoElement<?> chronoElement) {
            this.ref = chronoElement;
            this.name = chronoElement.name();
            this.index = n2;
        }

        @Override
        public Integer getValue(PlainDate plainDate) {
            return this.getInt(plainDate);
        }

        @Override
        public int getInt(PlainDate plainDate) {
            switch (this.index) {
                case 14: {
                    return plainDate.year;
                }
                case 15: {
                    return plainDate.month;
                }
                case 16: {
                    return plainDate.dayOfMonth;
                }
                case 17: {
                    return plainDate.getDayOfYear();
                }
                case 18: {
                    return plainDate.getDayOfQuarter();
                }
                case 19: {
                    return (plainDate.dayOfMonth - 1) / 7 + 1;
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public PlainDate withValue(PlainDate plainDate, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            return this.withValue(plainDate, (int)n2, bl2);
        }

        @Override
        public PlainDate withValue(PlainDate plainDate, int n2, boolean bl2) {
            if (bl2) {
                IsoDateUnit isoDateUnit = (IsoDateUnit)ENGINE.getBaseUnit(this.ref);
                int n3 = MathUtils.safeSubtract(n2, this.getInt(plainDate));
                return (PlainDate)plainDate.plus((long)n3, isoDateUnit);
            }
            switch (this.index) {
                case 14: {
                    return plainDate.withYear(n2);
                }
                case 15: {
                    return plainDate.withMonth(n2);
                }
                case 16: {
                    return plainDate.withDayOfMonth(n2);
                }
                case 17: {
                    return plainDate.withDayOfYear(n2);
                }
                case 18: {
                    if (n2 >= 1 && n2 <= IntegerElementRule.getMaximumOfQuarterDay(plainDate)) {
                        return plainDate.plus((long)(n2 - plainDate.getDayOfQuarter()), CalendarUnit.DAYS);
                    }
                    throw new IllegalArgumentException("Out of range: " + n2);
                }
                case 19: {
                    if (n2 >= 1 && n2 <= this.getMaximumOfWIM(plainDate)) {
                        int n4 = (plainDate.dayOfMonth - 1) / 7 + 1;
                        return plainDate.plus((long)(n2 - n4), CalendarUnit.WEEKS);
                    }
                    throw new IllegalArgumentException("Out of range: " + n2);
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public boolean isValid(PlainDate plainDate, Integer n2) {
            return n2 != null && this.isValid(plainDate, (int)n2);
        }

        @Override
        public boolean isValid(PlainDate plainDate, int n2) {
            switch (this.index) {
                case 14: {
                    return n2 >= -999999999 && n2 <= 999999999;
                }
                case 15: {
                    return n2 >= 1 && n2 <= 12;
                }
                case 16: {
                    return n2 >= 1 && n2 <= GregorianMath.getLengthOfMonth(plainDate.year, plainDate.month);
                }
                case 17: {
                    return n2 >= 1 && n2 <= (GregorianMath.isLeapYear(plainDate.year) ? 366 : 365);
                }
                case 18: {
                    return n2 >= 1 && n2 <= IntegerElementRule.getMaximumOfQuarterDay(plainDate);
                }
                case 19: {
                    return n2 >= 1 && n2 <= this.getMaximumOfWIM(plainDate);
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public Integer getMinimum(PlainDate plainDate) {
            switch (this.index) {
                case 14: {
                    return MIN_YEAR;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return VALUE_1;
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public Integer getMaximum(PlainDate plainDate) {
            switch (this.index) {
                case 14: {
                    return MAX_YEAR;
                }
                case 15: {
                    return VALUE_12;
                }
                case 16: {
                    return GregorianMath.getLengthOfMonth(plainDate.year, plainDate.month);
                }
                case 17: {
                    return GregorianMath.isLeapYear(plainDate.year) ? LEAP_YEAR_LEN : STD_YEAR_LEN;
                }
                case 18: {
                    return IntegerElementRule.getMaximumOfQuarterDay(plainDate);
                }
                case 19: {
                    return this.getMaximumOfWIM(plainDate);
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainDate plainDate) {
            return this.getChild();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainDate plainDate) {
            return this.getChild();
        }

        private ChronoElement<?> getChild() {
            switch (this.index) {
                case 14: {
                    return MONTH_AS_NUMBER;
                }
                case 15: {
                    return DAY_OF_MONTH;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return null;
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        private static int getMaximumOfQuarterDay(PlainDate plainDate) {
            int n2 = (plainDate.month - 1) / 3 + 1;
            if (n2 == 1) {
                return GregorianMath.isLeapYear(plainDate.year) ? 91 : 90;
            }
            if (n2 == 2) {
                return 91;
            }
            return 92;
        }

        private int getMaximumOfWIM(PlainDate plainDate) {
            int n2 = GregorianMath.getLengthOfMonth(plainDate.year, plainDate.month);
            byte by2 = plainDate.dayOfMonth;
            int n3 = 0;
            while (by2 + (n3 + 1) * 7 <= n2) {
                ++n3;
            }
            return (by2 + n3 * 7 - 1) / 7 + 1;
        }
    }

    private static class EnumElementRule<V extends Enum<V>>
    implements ElementRule<PlainDate, V> {
        private final String name;
        private final Class<V> type;
        private final V min;
        private final V max;
        private final int index;

        EnumElementRule(String string, Class<V> clazz, V v2, V v3, int n2) {
            this.name = string;
            this.type = clazz;
            this.min = v2;
            this.max = v3;
            this.index = n2;
        }

        static <V extends Enum<V>> EnumElementRule<V> of(ChronoElement<V> chronoElement) {
            return new EnumElementRule<Enum>(chronoElement.name(), chronoElement.getType(), (Enum)chronoElement.getDefaultMinimum(), (Enum)chronoElement.getDefaultMaximum(), ((EnumElement)chronoElement).getIndex());
        }

        @Override
        public V getValue(PlainDate plainDate) {
            Enum enum_;
            switch (this.index) {
                case 101: {
                    enum_ = Month.valueOf(plainDate.month);
                    break;
                }
                case 102: {
                    enum_ = plainDate.getDayOfWeek();
                    break;
                }
                case 103: {
                    enum_ = Quarter.valueOf((plainDate.month - 1) / 3 + 1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.name);
                }
            }
            return (V)((Enum)this.type.cast(enum_));
        }

        @Override
        public V getMinimum(PlainDate plainDate) {
            return this.min;
        }

        @Override
        public V getMaximum(PlainDate plainDate) {
            if (this.index == 102 && plainDate.year == 999999999 && plainDate.month == 12 && plainDate.dayOfMonth >= 27) {
                return (V)((Enum)this.type.cast(Weekday.FRIDAY));
            }
            return this.max;
        }

        @Override
        public boolean isValid(PlainDate plainDate, V v2) {
            if (v2 == null) {
                return false;
            }
            if (this.index == 102 && plainDate.year == 999999999) {
                try {
                    this.withValue(plainDate, v2, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public PlainDate withValue(PlainDate plainDate, V v2, boolean bl2) {
            if (v2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            switch (this.index) {
                case 101: {
                    return plainDate.withMonth(((Month)Month.class.cast(v2)).getValue());
                }
                case 102: {
                    return plainDate.withDayOfWeek((Weekday)Weekday.class.cast(v2));
                }
                case 103: {
                    int n2 = (plainDate.month - 1) / 3 + 1;
                    int n3 = ((Quarter)Quarter.class.cast(v2)).getValue();
                    return plainDate.plus((long)(n3 - n2), CalendarUnit.QUARTERS);
                }
            }
            throw new UnsupportedOperationException(this.name);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainDate plainDate) {
            return this.getChild();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainDate plainDate) {
            return this.getChild();
        }

        private ChronoElement<?> getChild() {
            switch (this.index) {
                case 101: {
                    return DAY_OF_MONTH;
                }
                case 102: {
                    return null;
                }
                case 103: {
                    return DAY_OF_QUARTER;
                }
            }
            throw new UnsupportedOperationException(this.name);
        }
    }
}

