/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.AbstractDateElement;
import net.time4j.ElementOperator;
import net.time4j.NavigableElement;
import net.time4j.NavigationOperator;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.GregorianTextElement;

final class EnumElement<V extends Enum<V>>
extends AbstractDateElement<V>
implements NavigableElement<V>,
NumericalElement<V>,
GregorianTextElement<V> {
    static final int MONTH = 101;
    static final int DAY_OF_WEEK = 102;
    static final int QUARTER_OF_YEAR = 103;
    private static final long serialVersionUID = 2055272540517425102L;
    private final transient Class<V> type;
    private final transient V dmin;
    private final transient V dmax;
    private final transient int index;
    private final transient char symbol;

    EnumElement(String string, Class<V> clazz, V v2, V v3, int n2, char c2) {
        super(string);
        this.type = clazz;
        this.dmin = v2;
        this.dmax = v3;
        this.index = n2;
        this.symbol = c2;
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public V getDefaultMinimum() {
        return this.dmin;
    }

    @Override
    public V getDefaultMaximum() {
        return this.dmax;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> setToNext(V v2) {
        return new NavigationOperator<V>(this, 9, v2);
    }

    @Override
    public ElementOperator<PlainDate> setToPrevious(V v2) {
        return new NavigationOperator<V>(this, 10, v2);
    }

    @Override
    public ElementOperator<PlainDate> setToNextOrSame(V v2) {
        return new NavigationOperator<V>(this, 11, v2);
    }

    @Override
    public ElementOperator<PlainDate> setToPreviousOrSame(V v2) {
        return new NavigationOperator<V>(this, 12, v2);
    }

    @Override
    public int numerical(V v2) {
        return ((Enum)v2).ordinal() + 1;
    }

    @Override
    public boolean parseFromInt(ChronoEntity<?> chronoEntity, int n2) {
        try {
            chronoEntity.with(this, ((Enum[])this.type.getEnumConstants())[n2 - 1]);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        appendable.append(this.accessor(locale, textWidth, outputContext).print((Enum)chronoDisplay.get(this)));
    }

    @Override
    public V parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        OutputContext outputContext;
        TextWidth textWidth;
        int n2 = parsePosition.getIndex();
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        V v2 = this.accessor(locale, textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE), outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT)).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        if (v2 == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n2);
            outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
            v2 = this.accessor(locale, textWidth, outputContext).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }
        return v2;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, Locale locale, TextWidth textWidth, OutputContext outputContext) throws IOException, ChronoException {
        appendable.append(this.accessor(locale, textWidth, outputContext).print((Enum)chronoDisplay.get(this)));
    }

    @Override
    public V parse(CharSequence charSequence, ParsePosition parsePosition, Locale locale, TextWidth textWidth, OutputContext outputContext, Leniency leniency) {
        int n2 = parsePosition.getIndex();
        V v2 = this.accessor(locale, textWidth, outputContext).parse(charSequence, parsePosition, this.getType(), leniency);
        if (v2 == null && !leniency.isStrict()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n2);
            outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
            v2 = this.accessor(locale, textWidth, outputContext).parse(charSequence, parsePosition, this.getType(), leniency);
        }
        return v2;
    }

    @Override
    protected boolean isSingleton() {
        return true;
    }

    int getIndex() {
        return this.index;
    }

    private TextAccessor accessor(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        switch (this.index) {
            case 101: {
                return CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext);
            }
            case 102: {
                return CalendarText.getIsoInstance(locale).getWeekdays(textWidth, outputContext);
            }
            case 103: {
                return CalendarText.getIsoInstance(locale).getQuarters(textWidth, outputContext);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainDate.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

